/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.recording.ProxiedServeEventFilters;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class ProxiedServeEventFiltersTest {
    @Test
    public void applyWithUniversalRequestPattern() {
        ServeEvent serveEvent = this.proxiedServeEvent(MockRequest.mockRequest());
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(RequestPattern.ANYTHING, null, false);
        Assert.assertTrue((boolean)filters.apply(serveEvent));
        filters = new ProxiedServeEventFilters(null, null, false);
        Assert.assertTrue((boolean)filters.apply(serveEvent));
    }

    @Test
    public void applyWithUnproxiedServeEvent() {
        ServeEvent serveEvent = this.toServeEvent(null, null, ResponseDefinition.ok());
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(null, null, false);
        Assert.assertFalse((boolean)filters.apply(serveEvent));
    }

    @Test
    public void applyWithMethodPattern() {
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.anyUrl()).build(), null, false);
        MockRequest request = MockRequest.mockRequest().method(RequestMethod.GET).url("/foo");
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(request)));
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(request.url("/bar"))));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(request.method(RequestMethod.POST))));
    }

    @Test
    public void applyWithIds() {
        List<UUID> ids = Arrays.asList(UUID.fromString("00000000-0000-0000-0000-000000000000"), UUID.fromString("00000000-0000-0000-0000-000000000001"));
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(null, ids, false);
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(ids.get(0))));
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(ids.get(1))));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(UUID.fromString("00000000-0000-0000-0000-000000000002"))));
    }

    @Test
    public void applyWithMethodAndUrlPattern() {
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/foo")).build(), null, false);
        MockRequest request = MockRequest.mockRequest().method(RequestMethod.GET).url("/foo");
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(request)));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(request.url("/bar"))));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(request.method(RequestMethod.POST))));
    }

    @Test
    public void applyWithIdsAndMethodPattern() {
        MockRequest request = MockRequest.mockRequest().method(RequestMethod.GET).url("/foo");
        List<UUID> ids = Arrays.asList(UUID.fromString("00000000-0000-0000-0000-000000000000"), UUID.fromString("00000000-0000-0000-0000-000000000001"));
        ProxiedServeEventFilters filters = new ProxiedServeEventFilters(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.anyUrl()).build(), ids, false);
        Assert.assertTrue((boolean)filters.apply(this.proxiedServeEvent(ids.get(0), request)));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(UUID.fromString("00000000-0000-0000-0000-000000000002"), request)));
        Assert.assertFalse((boolean)filters.apply(this.proxiedServeEvent(ids.get(0), request.method(RequestMethod.POST))));
    }

    private ServeEvent toServeEvent(UUID id, MockRequest request, ResponseDefinition responseDefinition) {
        return new ServeEvent(id, request != null ? request.asLoggedRequest() : null, null, responseDefinition, null, true, Timing.UNTIMED);
    }

    private ServeEvent proxiedServeEvent(UUID id, MockRequest request) {
        return this.toServeEvent(id, request, new ResponseDefinitionBuilder().proxiedFrom("http://localhost").build());
    }

    private ServeEvent proxiedServeEvent(MockRequest request) {
        return this.proxiedServeEvent(null, request);
    }

    private ServeEvent proxiedServeEvent(UUID id) {
        return this.proxiedServeEvent(id, null);
    }
}

