/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.recording.RequestBodyAutomaticPatternFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RequestBodyAutomaticPatternFactoryTest {
    private static final String JSON_TEST_STRING = "{ \"foo\": 1 }";
    private static final String XML_TEST_STRING = "<foo/>";
    private static final String MULTIPART_TEST_STRING = "--abc\nContent-Disposition: form-data; name=\"test1\"\n\ntest one\n--abc\nContent-Disposition: form-data; name=\"texs2\"\n\ntest two\n--abc";

    @Test
    public void forRequestWithTextBodyIsCaseSensitiveByDefault() {
        MockRequest request = MockRequest.mockRequest().body(JSON_TEST_STRING);
        EqualToPattern pattern = (EqualToPattern)RequestBodyAutomaticPatternFactoryTest.patternForRequest(request);
        MatcherAssert.assertThat((Object)pattern.getEqualTo(), (Matcher)Matchers.is((Object)JSON_TEST_STRING));
        MatcherAssert.assertThat((Object)pattern.getCaseInsensitive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void forRequestWithTextBodyRespectsCaseInsensitiveOption() {
        MockRequest request = MockRequest.mockRequest().body(JSON_TEST_STRING);
        RequestBodyAutomaticPatternFactory patternFactory = new RequestBodyAutomaticPatternFactory(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
        EqualToPattern pattern = (EqualToPattern)patternFactory.forRequest((Request)request);
        MatcherAssert.assertThat((Object)pattern.getEqualTo(), (Matcher)Matchers.is((Object)JSON_TEST_STRING));
        MatcherAssert.assertThat((Object)pattern.getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void forRequestWithJsonBodyIgnoresExtraElementsAndArrayOrderByDefault() {
        MockRequest request = MockRequest.mockRequest().header("Content-Type", "application/json").body(JSON_TEST_STRING);
        EqualToJsonPattern pattern = (EqualToJsonPattern)RequestBodyAutomaticPatternFactoryTest.patternForRequest(request);
        MatcherAssert.assertThat((Object)pattern.getEqualToJson(), (Matcher)Matchers.is((Object)JSON_TEST_STRING));
        MatcherAssert.assertThat((Object)pattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)pattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void forRequestWithJsonBodyRespectsOptions() {
        RequestBodyAutomaticPatternFactory patternFactory = new RequestBodyAutomaticPatternFactory(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        MockRequest request = MockRequest.mockRequest().header("Content-Type", "application/json").body(JSON_TEST_STRING);
        EqualToJsonPattern pattern = (EqualToJsonPattern)patternFactory.forRequest((Request)request);
        MatcherAssert.assertThat((Object)pattern.getEqualToJson(), (Matcher)Matchers.is((Object)JSON_TEST_STRING));
        MatcherAssert.assertThat((Object)pattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)pattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void forRequestWithXmlBody() {
        MockRequest request = MockRequest.mockRequest().header("Content-Type", "application/xml").body(XML_TEST_STRING);
        EqualToXmlPattern pattern = (EqualToXmlPattern)RequestBodyAutomaticPatternFactoryTest.patternForRequest(request);
        MatcherAssert.assertThat((Object)pattern.getEqualToXml(), (Matcher)Matchers.is((Object)XML_TEST_STRING));
    }

    @Test
    public void forRequestWithMultipartBody() {
        MockRequest request = MockRequest.mockRequest().header("Content-Type", "multipart/form-data").body(MULTIPART_TEST_STRING);
        AnythingPattern pattern = (AnythingPattern)RequestBodyAutomaticPatternFactoryTest.patternForRequest(request);
        MatcherAssert.assertThat((Object)pattern.toString(), (Matcher)Matchers.is((Object)"anything"));
    }

    @Test
    public void forRequestWithBinaryBody() {
        MockRequest request = MockRequest.mockRequest().header("Content-Type", "application/octet-stream").body(new byte[]{1, 2, 3});
        BinaryEqualToPattern pattern = (BinaryEqualToPattern)RequestBodyAutomaticPatternFactoryTest.patternForRequest(request);
        MatcherAssert.assertThat((Object)pattern.toString(), (Matcher)Matchers.is((Object)"binaryEqualTo AQID"));
    }

    private static ContentPattern<?> patternForRequest(Request request) {
        return RequestBodyAutomaticPatternFactory.DEFAULTS.forRequest(request);
    }
}

