/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.recording.RequestBodyAutomaticPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyEqualToXmlPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RequestBodyPatternFactoryJsonDeserializerTest {
    @Test
    public void correctlyDeserializesWithEmptyObject() {
        RequestBodyPatternFactory bodyPatternFactory = RequestBodyPatternFactoryJsonDeserializerTest.deserializeJson("{}");
        MatcherAssert.assertThat((Object)bodyPatternFactory, (Matcher)Matchers.instanceOf(RequestBodyAutomaticPatternFactory.class));
    }

    @Test
    public void correctlyDeserializesWithAutoMatcher() {
        RequestBodyPatternFactory bodyPatternFactory = RequestBodyPatternFactoryJsonDeserializerTest.deserializeJson("{ \"matcher\": \"auto\" }");
        MatcherAssert.assertThat((Object)bodyPatternFactory, (Matcher)Matchers.instanceOf(RequestBodyAutomaticPatternFactory.class));
    }

    @Test
    public void correctlyDeserializesWithEqualToMatcher() {
        RequestBodyPatternFactory bodyPatternFactory = RequestBodyPatternFactoryJsonDeserializerTest.deserializeJson("{                                    \n    \"matcher\": \"equalTo\",        \n    \"caseInsensitive\": true        \n}                                      ");
        EqualToPattern bodyPattern = (EqualToPattern)bodyPatternFactory.forRequest((Request)MockRequest.mockRequest().body("this body text"));
        MatcherAssert.assertThat((Object)bodyPattern.getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bodyPattern.getExpected(), (Matcher)Matchers.is((Object)"this body text"));
    }

    @Test
    public void correctlyDeserializesWithEqualToJsonMatcher() {
        RequestBodyPatternFactory bodyPatternFactory = RequestBodyPatternFactoryJsonDeserializerTest.deserializeJson("{                                    \n    \"matcher\": \"equalToJson\",    \n    \"ignoreArrayOrder\": false,     \n    \"ignoreExtraElements\": true    \n}                                      ");
        EqualToJsonPattern bodyPattern = (EqualToJsonPattern)bodyPatternFactory.forRequest((Request)MockRequest.mockRequest().body("1"));
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void correctlyDeserializesWithEqualToXmlMatcher() {
        RequestBodyPatternFactory bodyPatternFactory = RequestBodyPatternFactoryJsonDeserializerTest.deserializeJson("{ \"matcher\": \"equalToXml\" }");
        MatcherAssert.assertThat((Object)bodyPatternFactory, (Matcher)Matchers.instanceOf(RequestBodyEqualToXmlPatternFactory.class));
    }

    private static RequestBodyPatternFactory deserializeJson(String json) {
        return (RequestBodyPatternFactory)Json.read((String)json, RequestBodyPatternFactory.class);
    }
}

