/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.RequestPatternTransformer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class RequestPatternTransformerTest {
    @Test
    public void applyIncludesMethodAndUrlMatchers() {
        MockRequest request = MockRequest.mockRequest().url("/foo").method(RequestMethod.GET).header("User-Agent", "foo").header("X-Foo", "bar");
        RequestPatternBuilder expected = new RequestPatternBuilder(RequestMethod.GET, WireMock.urlEqualTo((String)"/foo"));
        Assert.assertEquals((Object)expected.build(), (Object)new RequestPatternTransformer(null, null).apply((Request)request).build());
    }

    @Test
    public void applyWithHeaders() {
        MockRequest request = MockRequest.mockRequest().url("/").method(RequestMethod.POST).header("X-CaseSensitive", "foo").header("X-Ignored", "ignored").header("X-CaseInsensitive", "Baz");
        RequestPatternBuilder expected = new RequestPatternBuilder(RequestMethod.POST, WireMock.urlEqualTo((String)"/")).withHeader("X-CaseSensitive", WireMock.equalTo((String)"foo")).withHeader("X-CaseInsensitive", WireMock.equalToIgnoreCase((String)"Baz"));
        ImmutableMap headers = ImmutableMap.of((Object)"X-CaseSensitive", (Object)new CaptureHeadersSpec(Boolean.valueOf(false)), (Object)"X-CaseInsensitive", (Object)new CaptureHeadersSpec(Boolean.valueOf(true)));
        Assert.assertEquals((Object)expected.build(), (Object)new RequestPatternTransformer((Map)headers, null).apply((Request)request).build());
    }
}

