/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcherDeserializer;
import com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;

public class ResponseDefinitionBodyMatcherDeserializerTest {
    @Test
    public void correctlyParsesFileSize() {
        ImmutableMap testCases = ImmutableMap.builder().put((Object)"100", (Object)100L).put((Object)"1KB", (Object)1024L).put((Object)"1 kb", (Object)1024L).put((Object)"1024 K", (Object)0x100000L).put((Object)"10 Mb", (Object)0xA00000L).put((Object)"10.5 GB", (Object)Math.round(1.1274289152E10)).build();
        for (String input : testCases.keySet()) {
            Long expected = (Long)testCases.get(input);
            Long actual = ResponseDefinitionBodyMatcherDeserializer.parseFilesize((String)input);
            Assert.assertEquals((String)("Failed with " + input), (Object)expected, (Object)actual);
        }
    }

    @Test
    public void correctlyDeserializesWithEmptyNode() {
        ResponseDefinitionBodyMatcher matcher = (ResponseDefinitionBodyMatcher)Json.read((String)"{}", ResponseDefinitionBodyMatcher.class);
        Assert.assertEquals((Object)new ResponseDefinitionBodyMatcher(Long.MAX_VALUE, Long.MAX_VALUE), (Object)matcher);
    }

    @Test
    public void correctlyDeserializesWithSingleValue() {
        ResponseDefinitionBodyMatcher matcher = (ResponseDefinitionBodyMatcher)Json.read((String)"{ \"textSizeThreshold\": 100 }", ResponseDefinitionBodyMatcher.class);
        Assert.assertEquals((Object)new ResponseDefinitionBodyMatcher(100L, Long.MAX_VALUE), (Object)matcher);
    }

    @Test
    public void correctlyDeserializesWithBothValues() {
        ResponseDefinitionBodyMatcher matcher = (ResponseDefinitionBodyMatcher)Json.read((String)"{ \"textSizeThreshold\": 100, \"binarySizeThreshold\": 10 }", ResponseDefinitionBodyMatcher.class);
        Assert.assertEquals((Object)new ResponseDefinitionBodyMatcher(100L, 10L), (Object)matcher);
    }
}

