/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.recording.ScenarioProcessor;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ScenarioProcessorTest {
    private final ScenarioProcessor processor = new ScenarioProcessor();

    @Test
    public void placesStubMappingsIntoScenariosWhenRepetitionsArePresent() {
        StubMapping foobar1 = WireMock.get((String)"/foo/bar").build();
        StubMapping other1 = WireMock.get((String)"/other").build();
        StubMapping foobar2 = WireMock.get((String)"/foo/bar").build();
        StubMapping foobar3 = WireMock.get((String)"/foo/bar").build();
        StubMapping other2 = WireMock.get((String)"/other").build();
        this.processor.putRepeatedRequestsInScenarios(Arrays.asList(foobar1, other1, foobar2, foobar3, other2));
        MatcherAssert.assertThat((Object)foobar1.getScenarioName(), (Matcher)Matchers.is((Object)"scenario-1-foo-bar"));
        MatcherAssert.assertThat((Object)foobar1.getRequiredScenarioState(), (Matcher)Matchers.is((Object)"Started"));
        MatcherAssert.assertThat((Object)"scenario-1-foo-bar-2", (Matcher)Matchers.is((Object)foobar1.getNewScenarioState()));
        MatcherAssert.assertThat((Object)foobar2.getScenarioName(), (Matcher)Matchers.is((Object)foobar1.getScenarioName()));
        MatcherAssert.assertThat((Object)foobar2.getRequiredScenarioState(), (Matcher)Matchers.is((Object)"scenario-1-foo-bar-2"));
        MatcherAssert.assertThat((Object)foobar2.getNewScenarioState(), (Matcher)Matchers.is((Object)"scenario-1-foo-bar-3"));
        MatcherAssert.assertThat((Object)foobar1.getScenarioName(), (Matcher)Matchers.is((Object)foobar3.getScenarioName()));
        MatcherAssert.assertThat((Object)foobar3.getRequiredScenarioState(), (Matcher)Matchers.is((Object)"scenario-1-foo-bar-3"));
        MatcherAssert.assertThat((String)"Last mapping should not have a state transition", (Object)foobar3.getNewScenarioState(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)other1.getScenarioName(), (Matcher)Matchers.is((Object)"scenario-2-other"));
        MatcherAssert.assertThat((Object)other1.getNewScenarioState(), (Matcher)Matchers.is((Object)"scenario-2-other-2"));
        MatcherAssert.assertThat((Object)other2.getRequiredScenarioState(), (Matcher)Matchers.is((Object)"scenario-2-other-2"));
    }

    @Test
    public void doesNothingWhenNoRepeatedRequests() {
        StubMapping one = WireMock.get((String)"/one").build();
        StubMapping two = WireMock.get((String)"/two").build();
        StubMapping three = WireMock.get((String)"/three").build();
        this.processor.putRepeatedRequestsInScenarios(Arrays.asList(one, two, three));
        MatcherAssert.assertThat((Object)one.getScenarioName(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)two.getScenarioName(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)three.getScenarioName(), (Matcher)Matchers.nullValue());
    }
}

