/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SnapshotStubMappingBodyExtractorTest {
    private FileSource filesSource;
    private SnapshotStubMappingBodyExtractor bodyExtractor;
    private Mockery context;

    @Before
    public void init() {
        this.context = new Mockery();
        this.filesSource = (FileSource)this.context.mock(FileSource.class, "filesFileSource");
        this.bodyExtractor = new SnapshotStubMappingBodyExtractor(this.filesSource);
    }

    @Test
    public void updatesStubMapping() {
        StubMapping stubMapping = WireMock.get((String)"/foo").willReturn(WireMock.ok((String)"")).build();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileSource)this.one(SnapshotStubMappingBodyExtractorTest.this.filesSource)).writeBinaryFile((String)this.with(1.any(String.class)), (byte[])this.with(1.any(byte[].class)));
            }
        });
        this.bodyExtractor.extractInPlace(stubMapping);
        MatcherAssert.assertThat((Object)stubMapping.getResponse().getBodyFileName(), (Matcher)Matchers.is((Object)("foo-" + stubMapping.getId() + ".txt")));
        MatcherAssert.assertThat((Object)stubMapping.getResponse().specifiesBodyFile(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)stubMapping.getResponse().specifiesBodyContent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void determinesFileNameProperlyFromUrlWithJson() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.json").willReturn(WireMock.ok((String)"{}")).build();
        this.setFileExpectations("foobarjson-" + stubMapping.getId() + ".json", "{}");
        this.bodyExtractor.extractInPlace(stubMapping);
    }

    @Test
    public void determinesFileNameProperlyFromUrlWithText() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.txt").willReturn(WireMock.ok((String)"")).build();
        this.setFileExpectations("foobartxt-" + stubMapping.getId() + ".txt", "");
        this.bodyExtractor.extractInPlace(stubMapping);
    }

    @Test
    public void determinesFileNameProperlyFromMimeTypeWithJson() {
        StubMapping stubMapping = WireMock.get((String)"/foo/bar.txt").willReturn(WireMock.okJson((String)"{}")).build();
        this.setFileExpectations("foobartxt-" + stubMapping.getId() + ".json", "{}");
        this.bodyExtractor.extractInPlace(stubMapping);
    }

    @Test
    public void determinesFileNameProperlyWithNamedStubMapping() {
        StubMapping stubMapping = WireMock.get((String)"/foo").willReturn(WireMock.okJson((String)"{}")).build();
        stubMapping.setName("TEST NAME!");
        this.setFileExpectations("test-name-" + stubMapping.getId() + ".json", "{}");
        this.bodyExtractor.extractInPlace(stubMapping);
    }

    private void setFileExpectations(final String filename, final String body) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileSource)this.one(SnapshotStubMappingBodyExtractorTest.this.filesSource)).writeBinaryFile((String)this.with(2.equal((Object)filename)), (byte[])this.with(2.equal((Object)body.getBytes())));
            }
        });
    }
}

