/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.LoggedResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.recording.RequestPatternTransformer;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingGenerator;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Mockery;
import org.junit.Test;

public class SnapshotStubMappingGeneratorTest {
    @Test
    public void apply() {
        RequestPatternBuilder requestPatternBuilder = RequestPatternBuilder.newRequestPattern().withUrl("/foo");
        ResponseDefinition responseDefinition = ResponseDefinition.ok();
        SnapshotStubMappingGenerator stubMappingTransformer = new SnapshotStubMappingGenerator(SnapshotStubMappingGeneratorTest.requestPatternTransformer(requestPatternBuilder), SnapshotStubMappingGeneratorTest.responseDefinitionTransformer(responseDefinition));
        StubMapping actual = stubMappingTransformer.apply(SnapshotStubMappingGeneratorTest.serveEvent());
        StubMapping expected = new StubMapping(requestPatternBuilder.build(), responseDefinition);
        expected.setId(actual.getId());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
    }

    private static RequestPatternTransformer requestPatternTransformer(final RequestPatternBuilder requestPatternBuilder) {
        return new RequestPatternTransformer(null, null){

            public RequestPatternBuilder apply(Request request) {
                return requestPatternBuilder;
            }
        };
    }

    private static LoggedResponseDefinitionTransformer responseDefinitionTransformer(final ResponseDefinition responseDefinition) {
        return new LoggedResponseDefinitionTransformer(){

            public ResponseDefinition apply(LoggedResponse response) {
                return responseDefinition;
            }
        };
    }

    private static ServeEvent serveEvent() {
        return new ServeEvent(null, LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(new Mockery()).build()), null, null, LoggedResponse.from((Response)Response.notConfigured()), false, Timing.UNTIMED);
    }
}

