/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingPostProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SnapshotStubMappingPostProcessorTest {
    private static final List<StubMapping> TEST_STUB_MAPPINGS = ImmutableList.of((Object)WireMock.get((String)"/foo").build(), (Object)WireMock.get((String)"/bar").build(), (Object)WireMock.get((String)"/foo").build());

    @Test
    public void processFiltersRepeatedRequestsWhenNotRecordingScenarios() {
        List actual = new SnapshotStubMappingPostProcessor(false, SnapshotStubMappingPostProcessorTest.noopTransformerRunner(), null, null).process(TEST_STUB_MAPPINGS);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(0)).getRequest().getUrl(), (Matcher)Matchers.equalTo((Object)"/foo"));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(1)).getRequest().getUrl(), (Matcher)Matchers.equalTo((Object)"/bar"));
    }

    @Test
    public void processRunsTransformers() {
        SnapshotStubMappingTransformerRunner transformerRunner = new SnapshotStubMappingTransformerRunner(null){

            public StubMapping apply(StubMapping stubMapping) {
                String url = stubMapping.getRequest().getUrl();
                return new StubMapping(RequestPatternBuilder.newRequestPattern().withUrl(url + "/transformed").build(), ResponseDefinition.ok());
            }
        };
        List actual = new SnapshotStubMappingPostProcessor(false, transformerRunner, null, null).process(TEST_STUB_MAPPINGS);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(0)).getRequest().getUrl(), (Matcher)Matchers.equalTo((Object)"/foo/transformed"));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(1)).getRequest().getUrl(), (Matcher)Matchers.equalTo((Object)"/bar/transformed"));
    }

    @Test
    public void processExtractsBodiesWhenMatched() {
        ResponseDefinitionBodyMatcher bodyMatcher = new ResponseDefinitionBodyMatcher(0L, 0L){

            public MatchResult match(ResponseDefinition responseDefinition) {
                return responseDefinition == ((StubMapping)TEST_STUB_MAPPINGS.get(1)).getResponse() ? MatchResult.exactMatch() : MatchResult.noMatch();
            }
        };
        SnapshotStubMappingBodyExtractor bodyExtractor = new SnapshotStubMappingBodyExtractor(null){

            public void extractInPlace(StubMapping stubMapping) {
                stubMapping.setRequest(RequestPatternBuilder.newRequestPattern().withUrl("/extracted").build());
            }
        };
        List actual = new SnapshotStubMappingPostProcessor(false, SnapshotStubMappingPostProcessorTest.noopTransformerRunner(), bodyMatcher, bodyExtractor).process(TEST_STUB_MAPPINGS);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/foo"));
        MatcherAssert.assertThat((Object)((StubMapping)actual.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/extracted"));
    }

    private static SnapshotStubMappingTransformerRunner noopTransformerRunner() {
        return new SnapshotStubMappingTransformerRunner(null){

            public StubMapping apply(StubMapping stubMapping) {
                return stubMapping;
            }
        };
    }
}

