/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.servlet.AltHttpServerFactory;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AlternativeServletContainerTest {
    @Rule
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().httpServerFactory((HttpServerFactory)new AltHttpServerFactory()));
    WireMockTestClient client;

    @Before
    public void init() {
        this.client = new WireMockTestClient(this.wm.port());
        WireMock.configureFor((int)this.wm.port());
    }

    @Test
    public void supportsAlternativeHttpServerForBasicStub() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/alt-server")).willReturn(WireMock.aResponse().withStatus(204)));
        MatcherAssert.assertThat((Object)this.client.get("/alt-server", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void supportsAlternativeHttpServerForFaultInjection() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/alt-server")).willReturn(WireMock.aResponse().withFault(Fault.EMPTY_RESPONSE)));
        WireMockResponse response = this.client.get("/alt-server", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)418));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"No fault injector is configured!"));
    }
}

