/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.trafficlistener.ConsoleNotifyingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CommandLineOptionsTest {
    @Test
    public void returnsVerboseTrueWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--verbose"});
        MatcherAssert.assertThat((Object)options.verboseLoggingEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsVerboseFalseWhenOptionNotPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{""});
        MatcherAssert.assertThat((Object)options.verboseLoggingEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsRecordMappingsTrueWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--record-mappings"});
        MatcherAssert.assertThat((Object)options.recordMappingsEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsHeaderMatchingEnabledWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--match-headers", "Accept,Content-Type"});
        MatcherAssert.assertThat((Object)options.matchingHeaders(), (Matcher)Matchers.hasItems((Object[])new CaseInsensitiveKey[]{CaseInsensitiveKey.from((String)"Accept"), CaseInsensitiveKey.from((String)"Content-Type")}));
    }

    @Test
    public void returnsRecordMappingsFalseWhenOptionNotPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{""});
        MatcherAssert.assertThat((Object)options.recordMappingsEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void setsPortNumberWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--port", "8086"});
        MatcherAssert.assertThat((Object)options.portNumber(), (Matcher)Matchers.is((Object)8086));
    }

    @Test
    public void disablesHttpWhenOptionPresentAndHttpsEnabled() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--disable-http", "--https-port", "8443"});
        MatcherAssert.assertThat((Object)options.getHttpDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void enablesHttpsAndSetsPortNumberWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--https-port", "8443"});
        MatcherAssert.assertThat((Object)options.httpsSettings().enabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.httpsSettings().port(), (Matcher)Matchers.is((Object)8443));
    }

    @Test
    public void defaultsKeystorePathIfNotSpecifiedWhenHttpsEnabled() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--https-port", "8443"});
        MatcherAssert.assertThat((Object)options.httpsSettings().keyStorePath(), (Matcher)Matchers.endsWith((String)"/keystore"));
    }

    @Test
    public void setsRequireClientCert() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--https-port", "8443", "--https-keystore", "/my/keystore", "--https-truststore", "/my/truststore", "--https-require-client-cert"});
        MatcherAssert.assertThat((Object)options.httpsSettings().needClientAuth(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void setsTrustStoreOptions() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--https-port", "8443", "--https-keystore", "/my/keystore", "--https-truststore", "/my/truststore", "--truststore-type", "PKCS12", "--truststore-password", "sometrustpwd"});
        MatcherAssert.assertThat((Object)options.httpsSettings().trustStorePath(), (Matcher)Matchers.is((Object)"/my/truststore"));
        MatcherAssert.assertThat((Object)options.httpsSettings().trustStoreType(), (Matcher)Matchers.is((Object)"PKCS12"));
        MatcherAssert.assertThat((Object)options.httpsSettings().trustStorePassword(), (Matcher)Matchers.is((Object)"sometrustpwd"));
    }

    @Test
    public void setsHttpsKeyStorePathOptions() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--https-port", "8443", "--https-keystore", "/my/keystore", "--keystore-type", "pkcs12", "--keystore-password", "someotherpwd", "--key-manager-password", "keymanpass"});
        MatcherAssert.assertThat((Object)options.httpsSettings().keyStorePath(), (Matcher)Matchers.is((Object)"/my/keystore"));
        MatcherAssert.assertThat((Object)options.httpsSettings().keyStoreType(), (Matcher)Matchers.is((Object)"pkcs12"));
        MatcherAssert.assertThat((Object)options.httpsSettings().keyStorePassword(), (Matcher)Matchers.is((Object)"someotherpwd"));
        MatcherAssert.assertThat((Object)options.httpsSettings().keyManagerPassword(), (Matcher)Matchers.is((Object)"keymanpass"));
    }

    @Test(expected=Exception.class)
    public void throwsExceptionWhenPortNumberSpecifiedWithoutNumber() {
        new CommandLineOptions(new String[]{"--port"});
    }

    @Test
    public void returnsCorrecteyParsedBindAddress() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--bind-address", "127.0.0.1"});
        MatcherAssert.assertThat((Object)options.bindAddress(), (Matcher)Matchers.is((Object)"127.0.0.1"));
    }

    @Test
    public void setsProxyAllRootWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--proxy-all", "http://someotherhost.com/site"});
        MatcherAssert.assertThat((Object)options.specifiesProxyUrl(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.proxyUrl(), (Matcher)Matchers.is((Object)"http://someotherhost.com/site"));
    }

    @Test
    public void setsProxyHostHeaderWithTrailingPortInformation() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--proxy-all", "http://someotherhost.com:8080/site"});
        MatcherAssert.assertThat((Object)options.proxyHostHeader(), (Matcher)Matchers.is((Object)"someotherhost.com:8080"));
    }

    @Test(expected=Exception.class)
    public void throwsExceptionWhenProxyAllSpecifiedWithoutUrl() {
        new CommandLineOptions(new String[]{"--proxy-all"});
    }

    @Test
    public void returnsBrowserProxyingEnabledWhenOptionSet() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying"});
        MatcherAssert.assertThat((Object)options.browserProxyingEnabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.browserProxySettings().enabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsBrowserProxyingDisabledWhenOptionNoSet() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.browserProxyingEnabled(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)options.browserProxySettings().enabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void setsAll() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--verbose", "--record-mappings", "--port", "8088", "--proxy-all", "http://somewhere.com"});
        MatcherAssert.assertThat((Object)options.verboseLoggingEnabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.recordMappingsEnabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.portNumber(), (Matcher)Matchers.is((Object)8088));
        MatcherAssert.assertThat((Object)options.specifiesProxyUrl(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)options.proxyUrl(), (Matcher)Matchers.is((Object)"http://somewhere.com"));
    }

    @Test
    public void returnsHelpText() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--help"});
        MatcherAssert.assertThat((Object)options.helpText(), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"verbose")}));
    }

    @Test
    public void returnsCorrectlyParsedProxyViaParameter() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--proxy-via", "somehost.mysite.com:8080"});
        MatcherAssert.assertThat((Object)options.proxyVia().host(), (Matcher)Matchers.is((Object)"somehost.mysite.com"));
        MatcherAssert.assertThat((Object)options.proxyVia().port(), (Matcher)Matchers.is((Object)8080));
        MatcherAssert.assertThat((Object)options.proxyVia().getUsername(), (Matcher)Matchers.isEmptyOrNullString());
        MatcherAssert.assertThat((Object)options.proxyVia().getPassword(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void returnsCorrectlyParsedProxyViaParameterWithCredentials() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--proxy-via", "user:password@somehost.mysite.com:8080"});
        MatcherAssert.assertThat((Object)options.proxyVia().host(), (Matcher)Matchers.is((Object)"somehost.mysite.com"));
        MatcherAssert.assertThat((Object)options.proxyVia().port(), (Matcher)Matchers.is((Object)8080));
        MatcherAssert.assertThat((Object)options.proxyVia().getUsername(), (Matcher)Matchers.is((Object)"user"));
        MatcherAssert.assertThat((Object)options.proxyVia().getPassword(), (Matcher)Matchers.is((Object)"password"));
    }

    @Test
    public void returnsNoProxyWhenNoProxyViaSpecified() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.proxyVia(), (Matcher)Matchers.is((Object)ProxySettings.NO_PROXY));
    }

    @Test
    public void returnsDisabledRequestJournal() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--no-request-journal"});
        MatcherAssert.assertThat((Object)options.requestJournalDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsMaxRequestJournalEntries() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--max-request-journal-entries", "2"});
        MatcherAssert.assertThat((Object)options.maxRequestJournalEntries(), (Matcher)Matchers.is((Object)Optional.of((Object)2)));
        CommandLineOptions optionsNoMax = new CommandLineOptions(new String[]{""});
        MatcherAssert.assertThat((Object)optionsNoMax.maxRequestJournalEntries().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnPreserveHostHeaderTrueWhenPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--preserve-host-header"});
        MatcherAssert.assertThat((Object)options.shouldPreserveHostHeader(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnPreserveHostHeaderFalseWhenNotPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--port", "8080"});
        MatcherAssert.assertThat((Object)options.shouldPreserveHostHeader(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsCorrectlyParsedNumberOfThreads() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--container-threads", "300"});
        MatcherAssert.assertThat((Object)options.containerThreads(), (Matcher)Matchers.is((Object)300));
    }

    @Test
    public void defaultsContainerThreadsTo14() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.containerThreads(), (Matcher)Matchers.is((Object)14));
    }

    @Test
    public void returnsCorrectlyParsedJettyAcceptorThreads() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--jetty-acceptor-threads", "400"});
        MatcherAssert.assertThat((Object)options.jettySettings().getAcceptors().get(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void returnsCorrectlyParsedJettyAcceptQueueSize() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--jetty-accept-queue-size", "10"});
        MatcherAssert.assertThat((Object)options.jettySettings().getAcceptQueueSize().get(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void returnsCorrectlyParsedJettyHeaderBufferSize() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--jetty-header-buffer-size", "16384"});
        MatcherAssert.assertThat((Object)options.jettySettings().getRequestHeaderSize().get(), (Matcher)Matchers.is((Object)16384));
    }

    @Test
    public void returnsCorrectlyParsedJettyStopTimeout() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--jetty-stop-timeout", "1000"});
        MatcherAssert.assertThat((Object)options.jettySettings().getStopTimeout().get(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void returnsAbsentIfJettyAcceptQueueSizeNotSet() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.jettySettings().getAcceptQueueSize().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsAbsentIfJettyAcceptorsNotSet() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.jettySettings().getAcceptors().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsAbsentIfJettyHeaderBufferSizeNotSet() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.jettySettings().getRequestHeaderSize().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsAbsentIfJettyStopTimeoutNotSet() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.jettySettings().getStopTimeout().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void preventsRecordingWhenRequestJournalDisabled() {
        new CommandLineOptions(new String[]{"--no-request-journal", "--record-mappings"});
    }

    @Test
    public void returnsExtensionsSpecifiedAsClassNames() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--extensions", "com.github.tomakehurst.wiremock.standalone.CommandLineOptionsTest$ResponseDefinitionTransformerExt1,com.github.tomakehurst.wiremock.standalone.CommandLineOptionsTest$ResponseDefinitionTransformerExt2,com.github.tomakehurst.wiremock.standalone.CommandLineOptionsTest$RequestExt1"});
        Map extensions = options.extensionsOfType(ResponseDefinitionTransformer.class);
        MatcherAssert.assertThat(extensions.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(extensions.get("ResponseDefinitionTransformer_One"), (Matcher)Matchers.instanceOf(ResponseDefinitionTransformerExt1.class));
        MatcherAssert.assertThat(extensions.get("ResponseDefinitionTransformer_Two"), (Matcher)Matchers.instanceOf(ResponseDefinitionTransformerExt2.class));
    }

    @Test
    public void returnsRequestMatcherExtensionsSpecifiedAsClassNames() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--extensions", "com.github.tomakehurst.wiremock.standalone.CommandLineOptionsTest$RequestExt1,com.github.tomakehurst.wiremock.standalone.CommandLineOptionsTest$ResponseDefinitionTransformerExt1"});
        Map extensions = options.extensionsOfType(RequestMatcherExtension.class);
        MatcherAssert.assertThat(extensions.entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(extensions.get("RequestMatcherExtension_One"), (Matcher)Matchers.instanceOf(RequestExt1.class));
    }

    @Test
    public void returnsEmptySetForNoExtensionsSpecifiedAsClassNames() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        Map extensions = options.extensionsOfType(RequestMatcherExtension.class);
        MatcherAssert.assertThat(extensions.entrySet(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void returnsAConsoleNotifyingListenerWhenOptionPresent() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--print-all-network-traffic"});
        MatcherAssert.assertThat((Object)options.networkTrafficListener(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ConsoleNotifyingWiremockNetworkTrafficListener.class)));
    }

    @Test
    public void enablesGlobalResponseTemplating() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--global-response-templating"});
        Map extensions = options.extensionsOfType(ResponseTemplateTransformer.class);
        MatcherAssert.assertThat(extensions.entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ResponseTemplateTransformer)extensions.get("response-template")).applyGlobally(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void enablesLocalResponseTemplating() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--local-response-templating"});
        Map extensions = options.extensionsOfType(ResponseTemplateTransformer.class);
        MatcherAssert.assertThat(extensions.entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ResponseTemplateTransformer)extensions.get("response-template")).applyGlobally(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void supportsAdminApiBasicAuth() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--admin-api-basic-auth", "user:pass"});
        Authenticator authenticator = options.getAdminAuthenticator();
        String correctAuthHeader = new BasicCredentials("user", "pass").asAuthorizationHeaderValue();
        String incorrectAuthHeader = new BasicCredentials("user", "wrong_pass").asAuthorizationHeaderValue();
        MatcherAssert.assertThat((Object)authenticator.authenticate((Request)MockRequest.mockRequest().header("Authorization", correctAuthHeader)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)authenticator.authenticate((Request)MockRequest.mockRequest().header("Authorization", incorrectAuthHeader)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void canRequireHttpsForAdminApi() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--admin-api-require-https"});
        MatcherAssert.assertThat((Object)options.getHttpsRequiredForAdminApi(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToNotRequiringHttpsForAdminApi() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getHttpsRequiredForAdminApi(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void enablesAsynchronousResponse() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--async-response-enabled", "true"});
        MatcherAssert.assertThat((Object)options.getAsynchronousResponseSettings().isEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void disablesAsynchronousResponseByDefault() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getAsynchronousResponseSettings().isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void setsNumberOfAsynchronousResponseThreads() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--async-response-threads", "20"});
        MatcherAssert.assertThat((Object)options.getAsynchronousResponseSettings().getThreads(), (Matcher)Matchers.is((Object)20));
    }

    @Test
    public void setsChunkedEncodingPolicy() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--use-chunked-encoding", "always"});
        MatcherAssert.assertThat((Object)options.getChunkedEncodingPolicy(), (Matcher)Matchers.is((Object)Options.ChunkedEncodingPolicy.ALWAYS));
    }

    @Test
    public void setsDefaultNumberOfAsynchronousResponseThreads() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getAsynchronousResponseSettings().getThreads(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void configuresMaxTemplateCacheEntriesIfSpecified() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--global-response-templating", "--max-template-cache-entries", "5"});
        Map extensions = options.extensionsOfType(ResponseTemplateTransformer.class);
        ResponseTemplateTransformer transformer = (ResponseTemplateTransformer)extensions.get("response-template");
        MatcherAssert.assertThat((Object)transformer.getMaxCacheEntries(), (Matcher)Matchers.is((Object)5L));
    }

    @Test
    public void configuresMaxTemplateCacheEntriesToNullIfNotSpecified() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--global-response-templating"});
        Map extensions = options.extensionsOfType(ResponseTemplateTransformer.class);
        ResponseTemplateTransformer transformer = (ResponseTemplateTransformer)extensions.get("response-template");
        MatcherAssert.assertThat((Object)transformer.getMaxCacheEntries(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void configuresPermittedSystemKeysIfSpecified() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--global-response-templating", "--permitted-system-keys", "java*,path*"});
        MatcherAssert.assertThat((Object)options.getPermittedSystemKeys(), (Matcher)Matchers.hasItems((Object[])new String[]{"java*", "path*"}));
    }

    @Test
    public void returnsEmptyPermittedKeysIfNotSpecified() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--global-response-templating"});
        MatcherAssert.assertThat((Object)options.getPermittedSystemKeys(), (Matcher)Matchers.emptyCollectionOf(String.class));
    }

    @Test
    public void disablesGzip() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--disable-gzip"});
        MatcherAssert.assertThat((Object)options.getGzipDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToGzipEnabled() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getGzipDisabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void disablesRequestLogging() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--disable-request-logging"});
        MatcherAssert.assertThat((Object)options.getStubRequestLoggingDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToRequestLoggingEnabled() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getStubRequestLoggingDisabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void printsTheActualPortOnlyWhenHttpsDisabled() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        options.setActualHttpPort(5432);
        String dump = options.toString();
        MatcherAssert.assertThat((Object)dump, WireMatchers.matchesMultiLine(".*port:.*5432.*"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"https-port")));
    }

    @Test
    public void enablesStubCors() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-stub-cors"});
        MatcherAssert.assertThat((Object)options.getStubCorsEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToNoStubCors() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        MatcherAssert.assertThat((Object)options.getStubCorsEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void trustAllProxyTargets() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--trust-all-proxy-targets"});
        MatcherAssert.assertThat((Object)options.browserProxySettings().trustAllProxyTargets(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToNotTrustingAllProxyTargets() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying"});
        MatcherAssert.assertThat((Object)options.browserProxySettings().trustAllProxyTargets(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void trustsOneProxyTarget1() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--trust-proxy-target", "localhost"});
        MatcherAssert.assertThat((Object)options.browserProxySettings().trustedProxyTargets(), (Matcher)Matchers.is(Collections.singletonList("localhost")));
    }

    @Test
    public void trustsManyProxyTargets() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--trust-proxy-target=localhost", "--trust-proxy-target", "wiremock.org", "--trust-proxy-target=www.google.com"});
        MatcherAssert.assertThat((Object)options.browserProxySettings().trustedProxyTargets(), (Matcher)Matchers.is(Arrays.asList("localhost", "wiremock.org", "www.google.com")));
    }

    @Test
    public void defaultsToNoTrustedProxyTargets() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying"});
        MatcherAssert.assertThat((Object)options.browserProxySettings().trustedProxyTargets(), (Matcher)Matchers.is(Collections.emptyList()));
    }

    @Test
    public void setsCaKeyStorePathAndPassword() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--ca-keystore", "/my/keystore", "--ca-keystore-password", "someotherpwd", "--ca-keystore-type", "pkcs12"});
        KeyStoreSettings caKeyStore = options.browserProxySettings().caKeyStore();
        MatcherAssert.assertThat((Object)caKeyStore.path(), (Matcher)Matchers.is((Object)"/my/keystore"));
        MatcherAssert.assertThat((Object)caKeyStore.password(), (Matcher)Matchers.is((Object)"someotherpwd"));
        MatcherAssert.assertThat((Object)caKeyStore.type(), (Matcher)Matchers.is((Object)"pkcs12"));
    }

    @Test
    public void defaultsCaKeyStorePathAndPassword() {
        CommandLineOptions options = new CommandLineOptions(new String[]{"--enable-browser-proxying"});
        KeyStoreSettings caKeyStore = options.browserProxySettings().caKeyStore();
        MatcherAssert.assertThat((Object)caKeyStore.path(), (Matcher)Matchers.is((Object)BrowserProxySettings.DEFAULT_CA_KEYSTORE_PATH));
        MatcherAssert.assertThat((Object)caKeyStore.password(), (Matcher)Matchers.is((Object)"password"));
        MatcherAssert.assertThat((Object)caKeyStore.type(), (Matcher)Matchers.is((Object)"jks"));
    }

    @Test
    public void printsBothActualPortsOnlyWhenHttpsEnabled() {
        CommandLineOptions options = new CommandLineOptions(new String[0]);
        options.setActualHttpPort(5432);
        options.setActualHttpsPort(2345);
        String dump = options.toString();
        MatcherAssert.assertThat((Object)dump, WireMatchers.matchesMultiLine(".*port:.*5432.*"));
        MatcherAssert.assertThat((Object)dump, WireMatchers.matchesMultiLine(".*https-port:.*2345.*"));
    }

    @Test
    public void toStringWithTrustAllProxyTargetsWorks() {
        String options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--trust-all-proxy-targets"}).toString();
        MatcherAssert.assertThat((Object)options, WireMatchers.matchesMultiLine(".*enable-browser-proxying: *true.*"));
        MatcherAssert.assertThat((Object)options, WireMatchers.matchesMultiLine(".*trust-all-proxy-targets: *true.*"));
    }

    @Test
    public void toStringWithTrustProxyTarget() {
        String options = new CommandLineOptions(new String[]{"--enable-browser-proxying", "--trust-proxy-target", "localhost", "--trust-proxy-target", "example.com"}).toString();
        MatcherAssert.assertThat((Object)options, WireMatchers.matchesMultiLine(".*enable-browser-proxying: *true.*"));
        MatcherAssert.assertThat((Object)options, WireMatchers.matchesMultiLine(".*trust-proxy-target: *localhost, example\\.com.*"));
    }

    public static class RequestExt1
    extends RequestMatcherExtension {
        public MatchResult match(Request request, Parameters parameters) {
            return MatchResult.noMatch();
        }

        public String getName() {
            return "RequestMatcherExtension_One";
        }
    }

    public static class ResponseDefinitionTransformerExt2
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return null;
        }

        public String getName() {
            return "ResponseDefinitionTransformer_Two";
        }
    }

    public static class ResponseDefinitionTransformerExt1
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return null;
        }

        public String getName() {
            return "ResponseDefinitionTransformer_One";
        }
    }
}

