/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.testsupport.MockHttpResponder;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class AdminRequestHandlerTest {
    private Mockery context;
    private Admin admin;
    private MockHttpResponder httpResponder;
    private AdminRequestHandler handler;
    private static final String REQUEST_PATTERN_SAMPLE = "{\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"method\": \"DELETE\",\t\t\t\t\t\t\n\t\"url\": \"/some/resource\"\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String GLOBAL_SETTINGS_JSON = "{\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"fixedDelay\": 2000\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t";

    @Before
    public void init() {
        this.context = new Mockery();
        this.admin = (Admin)this.context.mock(Admin.class);
        this.httpResponder = new MockHttpResponder();
        this.handler = new AdminRequestHandler(AdminRoutes.defaults(), this.admin, (ResponseRenderer)new BasicResponseRenderer(), (Authenticator)new NoAuthenticator(), false, Collections.emptyList());
    }

    @Test
    public void shouldSaveMappingsWhenSaveCalled() {
        Request request = MockRequestBuilder.aRequest(this.context).withUrl("/mappings/save").withMethod(RequestMethod.POST).build();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Admin)this.one(AdminRequestHandlerTest.this.admin)).saveMappings();
            }
        });
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void shouldClearMappingsJournalAndRequestDelayWhenResetCalled() {
        Request request = MockRequestBuilder.aRequest(this.context).withUrl("/reset").withMethod(RequestMethod.POST).build();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Admin)this.one(AdminRequestHandlerTest.this.admin)).resetAll();
            }
        });
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void shouldClearJournalWhenResetRequestsCalled() {
        Request request = MockRequestBuilder.aRequest(this.context).withUrl("/requests/reset").withMethod(RequestMethod.POST).build();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Admin)this.one(AdminRequestHandlerTest.this.admin)).resetRequests();
            }
        });
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void shouldReturnCountOfMatchingRequests() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.DELETE, (UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).build();
                ((Admin)this.allowing(AdminRequestHandlerTest.this.admin)).countRequestsMatching(requestPattern);
                this.will(4.returnValue((Object)VerificationResult.withCount((int)5)));
            }
        });
        this.handler.handle(MockRequestBuilder.aRequest(this.context).withUrl("/requests/count").withMethod(RequestMethod.POST).withBody(REQUEST_PATTERN_SAMPLE).build(), (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), WireMatchers.equalToJson("{ \"count\": 5, \"requestJournalDisabled\" : false}"));
    }

    @Test
    public void shouldUpdateGlobalSettings() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                GlobalSettings expectedSettings = GlobalSettings.builder().fixedDelay(Integer.valueOf(2000)).build();
                ((Admin)this.allowing(AdminRequestHandlerTest.this.admin)).updateGlobalSettings(expectedSettings);
            }
        });
        this.handler.handle(MockRequestBuilder.aRequest(this.context).withUrl("/settings").withMethod(RequestMethod.POST).withBody(GLOBAL_SETTINGS_JSON).build(), (HttpResponder)this.httpResponder);
    }
}

