/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ScenariosTest {
    Scenarios scenarios;

    @Before
    public void init() {
        this.scenarios = new Scenarios();
    }

    @Test
    public void addsANewScenarioWhenStubAddedWithNewScenarioName() {
        StubMapping stub = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(stub);
        Scenario scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getState(), (Matcher)Matchers.is((Object)"Started"));
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step_2"}));
    }

    @Test
    public void updatesAnExistingScenarioWhenStubAddedWithExistingScenarioName() {
        StubMapping stub1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(stub1);
        StubMapping stub2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(stub2);
        MatcherAssert.assertThat((Object)this.scenarios.getAll().size(), (Matcher)Matchers.is((Object)1));
        Scenario scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getState(), (Matcher)Matchers.is((Object)"Started"));
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step_2", "step_3"}));
    }

    @Test
    public void removesPossibleStateFromScenarioWhenStubThatIsNotTheLastInTheScenarioIsDeleted() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        Scenario scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step_2", "step_3"}));
        this.scenarios.onStubMappingRemoved(mapping2);
        scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step_2"}));
    }

    @Test
    public void removesScenarioCompletelyWhenNoMoreMappingsReferToItDueToRemoval() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        Scenario scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step_2", "step_3"}));
        this.scenarios.onStubMappingRemoved(mapping1);
        this.scenarios.onStubMappingRemoved(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.getAll(), (Matcher)Matchers.empty());
    }

    @Test
    public void removesScenarioCompletelyWhenNoMoreMappingsReferToItDueToNameChange() {
        StubMapping oldMapping = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(oldMapping);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one"), (Matcher)Matchers.notNullValue());
        StubMapping newMapping = WireMock.get((String)"/scenarios/1").inScenario("two").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingUpdated(oldMapping, newMapping);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void modifiesScenarioStateWhenStubServed() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"Started"));
        this.scenarios.onStubServed(mapping1);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"step_2"));
        this.scenarios.onStubServed(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"step_3"));
    }

    @Test
    public void doesNotModifyScenarioStateWhenStubServedInNonMatchingState() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"Started"));
        this.scenarios.onStubServed(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"Started"));
    }

    @Test
    public void resetsAllScenarios() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        StubMapping mapping3 = WireMock.get((String)"/scenarios/2").inScenario("two").whenScenarioStateIs("Started").willSetStateTo("2_step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping3);
        this.scenarios.onStubServed(mapping1);
        this.scenarios.onStubServed(mapping3);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"step_2"));
        MatcherAssert.assertThat((Object)this.scenarios.getByName("two").getState(), (Matcher)Matchers.is((Object)"2_step_2"));
        this.scenarios.reset();
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"Started"));
        MatcherAssert.assertThat((Object)this.scenarios.getByName("two").getState(), (Matcher)Matchers.is((Object)"Started"));
    }

    @Test
    public void clearsScenarios() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        StubMapping mapping3 = WireMock.get((String)"/scenarios/2").inScenario("two").whenScenarioStateIs("Started").willSetStateTo("2_step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping3);
        MatcherAssert.assertThat((Object)this.scenarios.getAll().size(), (Matcher)Matchers.is((Object)2));
        this.scenarios.clear();
        MatcherAssert.assertThat((Object)this.scenarios.getAll().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void checksMappingIsInScenarioState() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step_2").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("step_2").willSetStateTo("step_3").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping2);
        MatcherAssert.assertThat((Object)this.scenarios.mappingMatchesScenarioState(mapping1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.scenarios.mappingMatchesScenarioState(mapping2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsOnlyStartedStateWhenNoNextStateSpecified() {
        StubMapping mapping = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping);
        Scenario scenario = this.scenarios.getByName("one");
        MatcherAssert.assertThat((Object)scenario.getState(), (Matcher)Matchers.is((Object)"Started"));
        MatcherAssert.assertThat((Object)scenario.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started"}));
    }

    @Test
    public void doesNotAddDuplicatePossibleStates() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step two").willReturn(WireMock.ok()).build();
        StubMapping mapping2 = WireMock.get((String)"/scenarios/2").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step two").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        this.scenarios.onStubMappingAdded(mapping1);
        Set possibleStates = this.scenarios.getByName("one").getPossibleStates();
        MatcherAssert.assertThat((Object)possibleStates.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)possibleStates, (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step two"}));
    }

    @Test
    public void supportsNewScenarioStateWhenRequiredStateIsNull() {
        StubMapping mapping = WireMock.get((String)"/scenarios/1").inScenario("one").willSetStateTo("step two").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping);
        this.scenarios.onStubServed(mapping);
        MatcherAssert.assertThat((Object)this.scenarios.getByName("one").getState(), (Matcher)Matchers.is((Object)"step two"));
    }

    @Test
    public void doesNotRemovePossibleStateWhenStubIsRemovedButOtherStubsHaveThatState() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("Started").willSetStateTo("step two").willReturn(WireMock.ok()).build();
        StubMapping mapping2 = WireMock.get((String)"/scenarios/2").inScenario("one").whenScenarioStateIs("step two").willSetStateTo("step two").willReturn(WireMock.ok()).build();
        StubMapping mapping3 = WireMock.get((String)"/scenarios/3").inScenario("one").whenScenarioStateIs("step two").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        this.scenarios.onStubMappingAdded(mapping2);
        this.scenarios.onStubMappingAdded(mapping3);
        this.scenarios.onStubMappingRemoved(mapping2);
        Set possibleStates = this.scenarios.getByName("one").getPossibleStates();
        MatcherAssert.assertThat((Object)possibleStates, (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "step two"}));
        MatcherAssert.assertThat((Object)possibleStates.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void returnsAllPossibleScenarioStates() {
        StubMapping mapping1 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("A").willSetStateTo("B").willReturn(WireMock.ok()).build();
        StubMapping mapping2 = WireMock.get((String)"/scenarios/1").inScenario("one").willSetStateTo("C").willReturn(WireMock.ok()).build();
        StubMapping mapping3 = WireMock.get((String)"/scenarios/1").inScenario("one").whenScenarioStateIs("D").willReturn(WireMock.ok()).build();
        this.scenarios.onStubMappingAdded(mapping1);
        this.scenarios.onStubMappingAdded(mapping2);
        this.scenarios.onStubMappingAdded(mapping3);
        Set possibleStates = this.scenarios.getByName("one").getPossibleStates();
        MatcherAssert.assertThat((Object)possibleStates, (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C", "D"}));
        MatcherAssert.assertThat((Object)possibleStates.size(), (Matcher)Matchers.is((Object)4));
    }
}

