/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.MockHttpResponder;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class StubRequestHandlerTest {
    private Mockery context;
    private StubServer stubServer;
    private ResponseRenderer responseRenderer;
    private MockHttpResponder httpResponder;
    private Admin admin;
    private RequestJournal requestJournal;
    private StubRequestHandler requestHandler;

    @Before
    public void init() {
        this.context = new Mockery();
        this.stubServer = (StubServer)this.context.mock(StubServer.class);
        this.responseRenderer = (ResponseRenderer)this.context.mock(ResponseRenderer.class);
        this.httpResponder = new MockHttpResponder();
        this.admin = (Admin)this.context.mock(Admin.class);
        this.requestJournal = (RequestJournal)this.context.mock(RequestJournal.class);
        this.requestHandler = new StubRequestHandler(this.stubServer, this.responseRenderer, this.admin, Collections.emptyMap(), this.requestJournal, Collections.emptyList(), false);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.allowing(StubRequestHandlerTest.this.requestJournal);
            }
        });
    }

    @Test
    public void returnsResponseIndicatedByMappings() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StubServer)this.allowing(StubRequestHandlerTest.this.stubServer)).serveStubFor((Request)this.with(2.any(Request.class)));
                this.will(2.returnValue((Object)ServeEvent.of((LoggedRequest)MockRequest.mockRequest().asLoggedRequest(), (ResponseDefinition)new ResponseDefinition(200, "Body content"))));
                Response response = Response.response().status(200).body("Body content").build();
                ((ResponseRenderer)this.allowing(StubRequestHandlerTest.this.responseRenderer)).render((ServeEvent)this.with(2.any(ServeEvent.class)));
                this.will(2.returnValue((Object)response));
            }
        });
        Request request = MockRequestBuilder.aRequest(this.context).withUrl("/the/required/resource").withMethod(RequestMethod.GET).build();
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)Matchers.is((Object)"Body content"));
    }

    @Test
    public void shouldNotifyListenersOnRequest() {
        final Request request = MockRequestBuilder.aRequest(this.context).build();
        final RequestListener listener = (RequestListener)this.context.mock(RequestListener.class);
        this.requestHandler.addRequestListener(listener);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StubServer)this.allowing(StubRequestHandlerTest.this.stubServer)).serveStubFor(request);
                this.will(3.returnValue((Object)ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)request), (ResponseDefinition)ResponseDefinition.notConfigured())));
                ((RequestListener)this.one(listener)).requestReceived((Request)this.with(3.equal((Object)request)), (Response)this.with(3.any(Response.class)));
                ((ResponseRenderer)this.allowing(StubRequestHandlerTest.this.responseRenderer)).render((ServeEvent)this.with(3.any(ServeEvent.class)));
                this.will(3.returnValue((Object)new Response.Builder().build()));
            }
        });
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
    }

    @Test
    public void shouldLogInfoOnRequest() {
        final Request request = MockRequestBuilder.aRequest(this.context).withUrl("/").withMethod(RequestMethod.GET).withClientIp("1.2.3.5").build();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StubServer)this.allowing(StubRequestHandlerTest.this.stubServer)).serveStubFor(request);
                this.will(4.returnValue((Object)ServeEvent.forUnmatchedRequest((LoggedRequest)LoggedRequest.createFrom((Request)request))));
                ((ResponseRenderer)this.allowing(StubRequestHandlerTest.this.responseRenderer)).render((ServeEvent)this.with(4.any(ServeEvent.class)));
                this.will(4.returnValue((Object)new Response.Builder().build()));
            }
        });
        TestNotifier notifier = TestNotifier.createAndSet();
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
        notifier.revert();
        MatcherAssert.assertThat((Object)notifier.getErrorMessages().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)notifier.getInfoMessages().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)notifier.getInfoMessages().get(0), (Matcher)CoreMatchers.containsString((String)"1.2.3.5 - GET /"));
    }
}

