/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;

public class MockRequestBuilder {
    private final Mockery context;
    private String url = "/";
    private RequestMethod method = RequestMethod.GET;
    private String clientIp = "x.x.x.x";
    private List<HttpHeader> individualHeaders = Lists.newArrayList();
    private Map<String, Cookie> cookies = Maps.newHashMap();
    private List<QueryParameter> queryParameters = Lists.newArrayList();
    private String body = "";
    private String bodyAsBase64 = "";
    private Collection<Request.Part> multiparts = Lists.newArrayList();
    private boolean browserProxyRequest = false;
    private String mockName;

    public MockRequestBuilder(Mockery context) {
        this.context = context;
    }

    public MockRequestBuilder(Mockery context, String mockName) {
        this.mockName = mockName;
        this.context = context;
    }

    public static MockRequestBuilder aRequest(Mockery context) {
        return new MockRequestBuilder(context);
    }

    public static MockRequestBuilder aRequest(Mockery context, String mockName) {
        return new MockRequestBuilder(context, mockName);
    }

    public MockRequestBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public MockRequestBuilder withQueryParameter(String key, String ... values) {
        this.queryParameters.add(new QueryParameter(key, Arrays.asList(values)));
        return this;
    }

    public MockRequestBuilder withMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    public MockRequestBuilder withClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public MockRequestBuilder withHeader(String key, String value) {
        this.individualHeaders.add(new HttpHeader(key, new String[]{value}));
        return this;
    }

    public MockRequestBuilder withCookie(String key, String value) {
        this.cookies.put(key, new Cookie(value));
        return this;
    }

    public MockRequestBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public MockRequestBuilder withBodyAsBase64(String bodyAsBase64) {
        this.bodyAsBase64 = bodyAsBase64;
        return this;
    }

    public MockRequestBuilder asBrowserProxyRequest() {
        this.browserProxyRequest = true;
        return this;
    }

    public MockRequestBuilder withMultiparts(Collection<Request.Part> parts) {
        this.multiparts = parts;
        return this;
    }

    public Request build() {
        final HttpHeaders headers = new HttpHeaders(this.individualHeaders);
        final Request request = this.mockName == null ? (Request)this.context.mock(Request.class) : (Request)this.context.mock(Request.class, this.mockName);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Request)this.allowing(request)).getUrl();
                this.will(1.returnValue((Object)MockRequestBuilder.this.url));
                ((Request)this.allowing(request)).getMethod();
                this.will(1.returnValue((Object)MockRequestBuilder.this.method));
                ((Request)this.allowing(request)).getClientIp();
                this.will(1.returnValue((Object)MockRequestBuilder.this.clientIp));
                for (HttpHeader header : headers.all()) {
                    ((Request)this.allowing(request)).containsHeader(header.key());
                    this.will(1.returnValue((Object)true));
                    ((Request)this.allowing(request)).getHeader(header.key());
                    this.will(1.returnValue((Object)header.firstValue()));
                }
                for (HttpHeader header : headers.all()) {
                    ((Request)this.allowing(request)).header(header.key());
                    this.will(1.returnValue((Object)header));
                    if (!header.key().equals("Content-Type") || !header.isPresent()) continue;
                    ((Request)this.allowing(request)).contentTypeHeader();
                    this.will(1.returnValue((Object)new ContentTypeHeader(header.firstValue())));
                }
                for (QueryParameter queryParameter : MockRequestBuilder.this.queryParameters) {
                    ((Request)this.allowing(request)).queryParameter(queryParameter.key());
                    this.will(1.returnValue((Object)queryParameter));
                }
                ((Request)this.allowing(request)).header((String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)HttpHeader.httpHeader((String)"key", (String[])new String[]{"value"})));
                ((Request)this.allowing(request)).getHeaders();
                this.will(1.returnValue((Object)headers));
                ((Request)this.allowing(request)).getAllHeaderKeys();
                this.will(1.returnValue((Object)Sets.newLinkedHashSet((Iterable)headers.keys())));
                ((Request)this.allowing(request)).containsHeader((String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)false));
                ((Request)this.allowing(request)).getCookies();
                this.will(1.returnValue((Object)MockRequestBuilder.this.cookies));
                ((Request)this.allowing(request)).getBody();
                this.will(1.returnValue((Object)MockRequestBuilder.this.body.getBytes()));
                ((Request)this.allowing(request)).getBodyAsString();
                this.will(1.returnValue((Object)MockRequestBuilder.this.body));
                ((Request)this.allowing(request)).getBodyAsBase64();
                this.will(1.returnValue((Object)MockRequestBuilder.this.bodyAsBase64));
                ((Request)this.allowing(request)).getAbsoluteUrl();
                this.will(1.returnValue((Object)("http://localhost:8080" + MockRequestBuilder.this.url)));
                ((Request)this.allowing(request)).isBrowserProxyRequest();
                this.will(1.returnValue((Object)MockRequestBuilder.this.browserProxyRequest));
                ((Request)this.allowing(request)).isMultipart();
                this.will(1.returnValue((Object)(MockRequestBuilder.this.multiparts != null && !MockRequestBuilder.this.multiparts.isEmpty() ? 1 : 0)));
                ((Request)this.allowing(request)).getParts();
                this.will(1.returnValue((Object)MockRequestBuilder.this.multiparts));
            }
        });
        return request;
    }
}

