/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class MultipartBody
extends AbstractContentBody {
    private final String name;
    private final byte[] body;

    MultipartBody(String name, byte[] body) {
        super(ContentType.APPLICATION_OCTET_STREAM);
        Args.notEmpty((CharSequence)name, (String)"Name was empty");
        Args.notNull((Object)body, (String)"Body was null");
        this.name = name;
        this.body = body;
    }

    MultipartBody(String name, String body, ContentType contentType) {
        super(contentType);
        Args.notEmpty((CharSequence)name, (String)"Name was empty");
        Args.notEmpty((CharSequence)body, (String)"Body was null");
        this.name = name;
        this.body = Strings.bytesFromString((String)body, (Charset)contentType.getCharset());
    }

    public static MultipartBody part(String name, byte[] body) {
        return new MultipartBody(name, body);
    }

    public static MultipartBody part(String name, String body, ContentType contentType) {
        return new MultipartBody(name, body, contentType);
    }

    public String getFilename() {
        return this.name;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.body);
    }

    public String getTransferEncoding() {
        return "7bit";
    }

    public long getContentLength() {
        return this.body.length;
    }
}

