/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import java.util.ArrayList;
import java.util.List;

public class TestNotifier
implements Notifier {
    private List<String> info;
    private List<String> error;
    private Notifier previousNotifier;
    private final ConsoleNotifier consoleNotifier = new ConsoleNotifier(true);

    public TestNotifier() {
        this.info = new ArrayList<String>();
        this.error = new ArrayList<String>();
    }

    public static TestNotifier createAndSet() {
        TestNotifier testNotifier = new TestNotifier();
        testNotifier.previousNotifier = LocalNotifier.notifier();
        LocalNotifier.set((Notifier)testNotifier);
        return testNotifier;
    }

    public void revert() {
        LocalNotifier.set((Notifier)this.previousNotifier);
    }

    public void info(String message) {
        this.info.add(message);
        this.consoleNotifier.info(message);
    }

    public void error(String message) {
        this.error.add(message);
        this.consoleNotifier.error(message);
    }

    public void error(String message, Throwable t) {
        this.error.add(message);
        this.consoleNotifier.error(message, t);
    }

    public List<String> getInfoMessages() {
        return this.info;
    }

    public List<String> getErrorMessages() {
        return this.error;
    }

    public void reset() {
        this.info.clear();
        this.error.clear();
    }
}

