/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.Diff;

public class WireMatchers {
    public static Matcher<String> equalToJson(final String expectedJson) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description desc) {
                desc.appendText("Expected:\n" + expectedJson);
            }

            public boolean matchesSafely(String actualJson) {
                try {
                    JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
        };
    }

    public static Matcher<String> equalToJson(final String expectedJson, final JSONCompareMode jsonCompareMode) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description desc) {
                desc.appendText("Expected:\n" + expectedJson);
            }

            public boolean matchesSafely(String actualJson) {
                try {
                    JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)jsonCompareMode);
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
        };
    }

    public static Matcher<String> equalToXml(final String expected) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String value) {
                Diff diff = DiffBuilder.compare((Object)Input.from((Object)expected)).withTest((Object)value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().build();
                return !diff.hasDifferences();
            }

            public void describeTo(Description description) {
                description.appendText("Expected:\n" + expected);
            }
        };
    }

    public static Matcher<String> matches(final String regex) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("Should match " + regex);
            }

            public boolean matchesSafely(String actual) {
                return actual.matches(regex);
            }
        };
    }

    public static Matcher<String> matchesMultiLine(final String regex) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("Should match " + regex);
            }

            public boolean matchesSafely(String actual) {
                return Pattern.compile(regex, 40).matcher(actual).matches();
            }
        };
    }

    public static <T> Matcher<Iterable<T>> hasExactly(final Matcher<T> ... items) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description desc) {
                desc.appendText("Collection must match exactly");
            }

            public boolean matchesSafely(Iterable<T> actual) {
                Iterator actualIter = actual.iterator();
                for (Matcher matcher : items) {
                    if (matcher.matches(actualIter.next())) continue;
                    return false;
                }
                return !actualIter.hasNext();
            }
        };
    }

    public static <T> Matcher<Iterable<T>> hasExactlyIgnoringOrder(final Matcher<T> ... items) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description desc) {
                desc.appendText("Collection elements must match, but don't have to be in the same order.");
            }

            public boolean matchesSafely(Iterable<T> actual) {
                if (Iterables.size(actual) != items.length) {
                    return false;
                }
                for (Matcher matcher : items) {
                    if (Iterables.find(actual, (Predicate)WireMatchers.isMatchFor(matcher), null) != null) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static <T> Predicate<T> isMatchFor(final Matcher<T> matcher) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return matcher.matches(input);
            }
        };
    }

    public static Matcher<TextFile> fileNamed(final String name) {
        return new TypeSafeMatcher<TextFile>(){

            public void describeTo(Description desc) {
                desc.appendText("a text file named " + name);
            }

            public boolean matchesSafely(TextFile textFile) {
                return textFile.name().endsWith(name);
            }
        };
    }

    public static Matcher<Date> isAfter(final String dateString) {
        return new TypeSafeMatcher<Date>(){

            public boolean matchesSafely(Date date) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date compareDate = df.parse(dateString);
                    return date.after(compareDate);
                }
                catch (ParseException pe) {
                    throw new RuntimeException(pe);
                }
            }

            public void describeTo(Description description) {
                description.appendText("A date after " + dateString);
            }
        };
    }

    public static Matcher<Date> isToday() {
        return new TypeSafeMatcher<Date>(){

            public boolean matchesSafely(Date date) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String today = df.format(new Date());
                return today.equals(df.format(date));
            }

            public void describeTo(Description description) {
                description.appendText("Today's date");
            }
        };
    }

    public static Matcher<HttpHeader> header(final String key, final String value) {
        return new TypeSafeMatcher<HttpHeader>(){

            public boolean matchesSafely(HttpHeader httpHeader) {
                return httpHeader.key().equals(key) && httpHeader.containsValue(value);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Header %s: %s", key, value));
            }
        };
    }

    public static Matcher<Path> hasFileContaining(final String ... contents) {
        return new TypeSafeDiagnosingMatcher<Path>(){

            protected boolean matchesSafely(Path path, Description mismatchDescription) {
                List<File> files = Arrays.asList(path.toFile().listFiles());
                boolean matched = Iterables.any(files, (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        final String fileContents = WireMatchers.fileContents(file);
                        return Iterables.all(Arrays.asList(contents), (Predicate)new Predicate<String>(){

                            public boolean apply(String input) {
                                return fileContents.contains(input);
                            }
                        });
                    }
                });
                if (files.size() == 0) {
                    mismatchDescription.appendText("there were no files in " + path);
                }
                if (!matched) {
                    String allFileContents = Joiner.on((String)"\n\n").join(Iterables.transform(files, (Function)new Function<File, String>(){

                        public String apply(File input) {
                            return WireMatchers.fileContents(input);
                        }
                    }));
                    mismatchDescription.appendText(allFileContents);
                }
                return matched;
            }

            public void describeTo(Description description) {
                description.appendText("a file containing all of: " + Joiner.on((String)", ").join((Object[])contents));
            }
        };
    }

    public static Matcher<String> equalsMultiLine(String expected) {
        String normalisedExpected = WireMatchers.normaliseLineBreaks(expected);
        return new IsEqual<String>(normalisedExpected){

            public boolean matches(Object actualValue) {
                return super.matches((Object)actualValue.toString());
            }
        };
    }

    private static String normaliseLineBreaks(String s) {
        return s.replace("\n", System.lineSeparator());
    }

    private static String fileContents(File input) {
        try {
            return Files.toString((File)input, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, String.class);
        }
    }

    public static Predicate<StubMapping> withUrl(final String url) {
        return new Predicate<StubMapping>(){

            public boolean apply(StubMapping input) {
                return url.equals(input.getRequest().getUrl());
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<StubMapping> stubMappingWithUrl(String url) {
        return WireMatchers.stubMappingWithUrl(WireMock.urlEqualTo((String)url));
    }

    public static TypeSafeDiagnosingMatcher<StubMapping> stubMappingWithUrl(final UrlPattern urlPattern) {
        return new TypeSafeDiagnosingMatcher<StubMapping>(){

            public void describeTo(Description description) {
                description.appendText("a stub mapping with a request URL matching " + urlPattern);
            }

            protected boolean matchesSafely(StubMapping item, Description mismatchDescription) {
                return urlPattern.match(item.getRequest().getUrl()).isExactMatch();
            }
        };
    }

    public static ServeEvent findServeEventWithUrl(List<ServeEvent> serveEvents, final String url) {
        return (ServeEvent)Iterables.find(serveEvents, (Predicate)new Predicate<ServeEvent>(){

            public boolean apply(ServeEvent input) {
                return url.equals(input.getRequest().getUrl());
            }
        });
    }

    public static StubMapping findMappingWithUrl(List<StubMapping> stubMappings, String url) {
        return (StubMapping)Iterables.find(stubMappings, WireMatchers.withUrl(url));
    }

    public static List<StubMapping> findMappingsWithUrl(List<StubMapping> stubMappings, String url) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(stubMappings, WireMatchers.withUrl(url)));
    }

    public static TypeSafeDiagnosingMatcher<StubMapping> isInAScenario() {
        return new TypeSafeDiagnosingMatcher<StubMapping>(){

            public void describeTo(Description description) {
                description.appendText("a stub mapping with a scenario name");
            }

            protected boolean matchesSafely(StubMapping item, Description mismatchDescription) {
                return item.getScenarioName() != null;
            }
        };
    }
}

