/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.GenericHttpUriRequest;
import com.github.tomakehurst.wiremock.http.MimeType;
import com.github.tomakehurst.wiremock.testsupport.MultipartBody;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class WireMockTestClient {
    private static final String LOCAL_WIREMOCK_ROOT = "http://%s:%d%s";
    private static final String LOCAL_WIREMOCK_NEW_RESPONSE_URL = "http://%s:%d/__admin/mappings/new";
    private static final String LOCAL_WIREMOCK_REMOVE_RESPONSE_URL = "http://%s:%d/__admin/mappings/remove";
    private static final String LOCAL_WIREMOCK_EDIT_RESPONSE_URL = "http://%s:%d/__admin/mappings/edit";
    private static final String LOCAL_WIREMOCK_RESET_URL = "http://%s:%d/__admin/reset";
    private static final String LOCAL_WIREMOCK_RESET_DEFAULT_MAPPINS_URL = "http://%s:%d/__admin/mappings/reset";
    private static final String LOCAL_WIREMOCK_SNAPSHOT_PATH = "/__admin/recordings/snapshot";
    private int port;
    private String address;

    public WireMockTestClient(int port, String address) {
        this.port = port;
        this.address = address;
    }

    public WireMockTestClient(int port) {
        this(port, "localhost");
    }

    public WireMockTestClient() {
        this(8080);
    }

    private String mockServiceUrlFor(String path) {
        return String.format(LOCAL_WIREMOCK_ROOT, this.address, this.port, path);
    }

    private String newMappingUrl() {
        return String.format(LOCAL_WIREMOCK_NEW_RESPONSE_URL, this.address, this.port);
    }

    private String editMappingUrl() {
        return String.format(LOCAL_WIREMOCK_EDIT_RESPONSE_URL, this.address, this.port);
    }

    private String resetDefaultMappingsUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_DEFAULT_MAPPINS_URL, this.address, this.port);
    }

    public WireMockResponse get(String url, TestHttpHeader ... headers) {
        String actualUrl = URI.create(url).isAbsolute() ? url : this.mockServiceUrlFor(url);
        HttpGet httpRequest = new HttpGet(actualUrl);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    public WireMockResponse getViaProxy(String url) {
        return this.getViaProxy(url, this.port);
    }

    public WireMockResponse getViaProxy(String url, int proxyPort) {
        return this.getViaProxy(url, proxyPort, "http");
    }

    public WireMockResponse getViaProxy(String url, int proxyPort, String scheme) {
        URI targetUri = URI.create(url);
        HttpHost proxy = new HttpHost(this.address, proxyPort, scheme);
        CloseableHttpClient httpClientUsingProxy = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().setSSLContext(WireMockTestClient.buildTrustWireMockDefaultCertificateSSLContext()).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setProxy(proxy).build();
        try {
            HttpHost target = new HttpHost(targetUri.getHost(), targetUri.getPort(), targetUri.getScheme());
            HttpGet req = new HttpGet(targetUri.getPath() + (Strings.isNullOrEmpty((String)targetUri.getQuery()) ? "" : "?" + targetUri.getQuery()));
            req.removeHeaders("Host");
            System.out.println("executing request to " + targetUri + "(" + target + ") via " + proxy);
            HttpResponse httpResponse = httpClientUsingProxy.execute(target, (HttpRequest)req);
            return new WireMockResponse(httpResponse);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public WireMockResponse put(String url, TestHttpHeader ... headers) {
        HttpPut httpRequest = new HttpPut(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    public WireMockResponse putWithBody(String url, String body, String contentType, TestHttpHeader ... headers) {
        HttpPut httpPut = new HttpPut(this.mockServiceUrlFor(url));
        return this.requestWithBody((HttpEntityEnclosingRequestBase)httpPut, body, contentType, headers);
    }

    public WireMockResponse patchWithBody(String url, String body, String contentType, TestHttpHeader ... headers) {
        HttpPatch httpPatch = new HttpPatch(this.mockServiceUrlFor(url));
        return this.requestWithBody((HttpEntityEnclosingRequestBase)httpPatch, body, contentType, headers);
    }

    private WireMockResponse requestWithBody(HttpEntityEnclosingRequestBase request, String body, String contentType, TestHttpHeader ... headers) {
        request.setEntity((HttpEntity)new StringEntity(body, ContentType.create((String)contentType, (String)"utf-8")));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)request, headers);
    }

    public WireMockResponse postWithBody(String url, String body, String bodyMimeType, String bodyEncoding) {
        return this.post(url, (HttpEntity)new StringEntity(body, ContentType.create((String)bodyMimeType, (String)bodyEncoding)), new TestHttpHeader[0]);
    }

    public WireMockResponse postWithMultiparts(String url, Collection<MultipartBody> parts, TestHttpHeader ... headers) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (parts != null) {
            for (MultipartBody part : parts) {
                builder.addPart(part.getFilename(), (ContentBody)part);
            }
        }
        return this.post(url, builder.build(), headers);
    }

    public WireMockResponse postWithChunkedBody(String url, byte[] body) {
        return this.post(url, (HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(body), -1L), new TestHttpHeader[0]);
    }

    public WireMockResponse post(String url, HttpEntity entity, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity(entity);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse postJson(String url, String body, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse postXml(String url, String body, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_XML));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse patchWithBody(String url, String body, String bodyMimeType, String bodyEncoding) {
        return this.patch(url, (HttpEntity)new StringEntity(body, ContentType.create((String)bodyMimeType, (String)bodyEncoding)));
    }

    public WireMockResponse patch(String url, HttpEntity entity) {
        HttpPatch httpPatch = new HttpPatch(this.mockServiceUrlFor(url));
        httpPatch.setEntity(entity);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPatch, new TestHttpHeader[0]);
    }

    public WireMockResponse delete(String url) {
        HttpDelete httpDelete = new HttpDelete(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpDelete, new TestHttpHeader[0]);
    }

    public WireMockResponse options(String url, TestHttpHeader ... headers) {
        HttpOptions httpOptions = new HttpOptions(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpOptions, headers);
    }

    public void addResponse(String responseSpecJson) {
        this.addResponse(responseSpecJson, "utf-8");
    }

    public void addResponse(String responseSpecJson, String charset) {
        int status = this.postJsonAndReturnStatus(this.newMappingUrl(), responseSpecJson, charset);
        if (status != 201) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public void editMapping(String mappingSpecJson) {
        int status = this.postJsonAndReturnStatus(this.editMappingUrl(), mappingSpecJson);
        if (status != 204) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public void resetDefaultMappings() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetDefaultMappingsUrl());
        if (status != 200) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public String snapshot(String snapshotSpecJson) {
        WireMockResponse response = this.postJson(LOCAL_WIREMOCK_SNAPSHOT_PATH, snapshotSpecJson, new TestHttpHeader[0]);
        if (response.statusCode() != 200) {
            throw new RuntimeException("Returned status code was " + response.statusCode());
        }
        return response.content();
    }

    private int postJsonAndReturnStatus(String url, String json) {
        return this.postJsonAndReturnStatus(url, json, "utf-8");
    }

    private int postJsonAndReturnStatus(String url, String json, String charset) {
        HttpPost post = new HttpPost(url);
        try {
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, ContentType.create((String)MimeType.JSON.toString(), (String)charset)));
            }
            HttpResponse httpResponse = WireMockTestClient.httpClient().execute((HttpUriRequest)post);
            return httpResponse.getStatusLine().getStatusCode();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int postEmptyBodyAndReturnStatus(String url) {
        return this.postJsonAndReturnStatus(url, null);
    }

    private WireMockResponse executeMethodAndConvertExceptions(HttpUriRequest httpRequest, TestHttpHeader ... headers) {
        try {
            for (TestHttpHeader header : headers) {
                httpRequest.addHeader(header.getName(), header.getValue());
            }
            HttpResponse httpResponse = WireMockTestClient.httpClient().execute(httpRequest);
            return new WireMockResponse(httpResponse);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public WireMockResponse getWithPreemptiveCredentials(String url, int port, String username, String password) {
        HttpHost target = new HttpHost("localhost", port);
        HttpClient httpClient = WireMockTestClient.httpClientWithPreemptiveAuth(target, username, password);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        try {
            HttpGet httpget = new HttpGet(url);
            HttpResponse response = httpClient.execute(target, (HttpRequest)httpget, (HttpContext)localContext);
            return new WireMockResponse(response);
        }
        catch (IOException e) {
            return (WireMockResponse)Exceptions.throwUnchecked((Throwable)e, WireMockResponse.class);
        }
    }

    public WireMockResponse request(String methodName, String url, TestHttpHeader ... headers) {
        GenericHttpUriRequest httpRequest = new GenericHttpUriRequest(methodName, this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    private static HttpClient httpClient() {
        return HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().build();
    }

    private static HttpClient httpClientWithPreemptiveAuth(HttpHost target, String username, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(target), (Credentials)new UsernamePasswordCredentials(username, password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }

    private static SSLContext buildTrustWireMockDefaultCertificateSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) {
                    return chain[0].getSubjectDN().getName().startsWith("CN=Tom Akehurst") || chain[0].getSubjectDN().getName().equals("CN=WireMock Local Self Signed Root Certificate") || chain.length == 2 && chain[1].getSubjectDN().getName().equals("CN=WireMock Local Self Signed Root Certificate");
                }
            }).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked((Throwable)e, SSLContext.class);
        }
    }
}

