/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Mockery;
import org.junit.Before;
import org.junit.Test;

public class InMemoryRequestJournalTest {
    private ServeEvent serveEvent1;
    private ServeEvent serveEvent2;
    private ServeEvent serveEvent3;

    @Before
    public void createTestRequests() {
        Mockery context = new Mockery();
        this.serveEvent1 = ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(context, "log1").withUrl("/logging1").build()), null);
        this.serveEvent2 = ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(context, "log2").withUrl("/logging2").build()), null);
        this.serveEvent3 = ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(context, "log3").withUrl("/logging3").build()), null);
    }

    @Test
    public void returnsAllLoggedRequestsWhenNoJournalSizeLimit() {
        InMemoryRequestJournal journal = new InMemoryRequestJournal(Optional.absent());
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent2);
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void resettingTheJournalClearsAllEntries() throws Exception {
        Mockery context = new Mockery();
        LoggedRequest loggedRequest = LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(context).withUrl("/for/logging").build());
        InMemoryRequestJournal journal = new InMemoryRequestJournal(Optional.of((Object)1));
        journal.requestReceived(ServeEvent.of((LoggedRequest)loggedRequest, null));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)1));
        journal.reset();
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void discardsOldRequestsWhenJournalSizeIsLimited() throws Exception {
        InMemoryRequestJournal journal = new InMemoryRequestJournal(Optional.of((Object)2));
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent2);
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
        journal.requestReceived(this.serveEvent3);
        this.assertOnlyLastTwoRequestsLeft((RequestJournal)journal);
    }

    private void assertOnlyLastTwoRequestsLeft(RequestJournal journal) {
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging3")).build()), (Matcher)Matchers.is((Object)1));
    }
}

