/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.common.Dates;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.skyscreamer.jsonassert.JSONAssert;

@RunWith(value=JMock.class)
public class LoggedRequestTest {
    public static final String REQUEST_BODY = "some text \u5f62\u58f0\u5b57\u5f62\u8072\u5b57";
    public static final String REQUEST_BODY_AS_BASE64 = "c29tZSB0ZXh0IOW9ouWjsOWtl+W9ouiBsuWtlw==";
    private Mockery context;
    static final String DATE = "2012-06-07T16:39:41Z";
    static final String JSON_EXAMPLE = "{\n      \"url\" : \"/my/url\",\n      \"absoluteUrl\" : \"http://mydomain.com/my/url\",\n      \"method\" : \"GET\",\n      \"clientIp\" : \"25.10.18.11\",\n      \"headers\" : {\n        \"Accept-Language\" : \"en-us,en;q=0.5\"\n      },\n      \"cookies\" : {\n        \"first_cookie\"   : \"yum\",\n        \"monster_cookie\" : \"COOKIIIEESS\"\n      },\n      \"browserProxyRequest\" : true,\n      \"loggedDate\" : %d,\n      \"bodyAsBase64\" : \"c29tZSB0ZXh0IOW9ouWjsOWtl+W9ouiBsuWtlw==\",\n      \"body\" : \"some text \u5f62\u58f0\u5b57\u5f62\u8072\u5b57\",\n      \"loggedDateString\" : \"2012-06-07T16:39:41Z\",\n    }";
    static final String JSON_PARAMS_EXAMPLE = "{\n  \"url\" : \"/sample/path?test-param-1=value1&test-param-2=value2\",\n  \"absoluteUrl\" : \"http://ex.ample/sample/path?test-param-1=value1&test-param-2=value2\",\n  \"method\" : \"GET\",\n  \"clientIp\" : \"0.0.0.0\",\n  \"browserProxyRequest\" : true,\n  \"loggedDate\" : 0,\n  \"loggedDateString\" : \"1970-01-01T00:00:00Z\",\n  \"queryParams\" : {\n    \"test-param-1\" : {\n      \"key\" : \"test-param-1\",\n      \"values\" : [ \"value-1\" ]\n    },\n    \"test-param-2\" : {\n      \"key\" : \"test-param-2\",\n      \"values\" : [ \"value-2\" ]\n    }\n  }\n}";

    @Before
    public void init() {
        this.context = new Mockery();
        System.out.println(TimeZone.getDefault());
    }

    @Test
    public void headerMatchingIsCaseInsensitive() {
        LoggedRequest loggedRequest = LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest(this.context).withUrl("/for/logging").withMethod(RequestMethod.POST).withClientIp("14.07.17.89").withBody(REQUEST_BODY).withBodyAsBase64(REQUEST_BODY_AS_BASE64).withHeader("Content-Type", "text/plain").withHeader("ACCEPT", "application/json").build());
        Assert.assertTrue((boolean)loggedRequest.containsHeader("content-type"));
        Assert.assertNotNull((Object)loggedRequest.getHeader("content-type"));
        Assert.assertTrue((boolean)loggedRequest.containsHeader("CONTENT-TYPE"));
        Assert.assertNotNull((Object)loggedRequest.getHeader("CONTENT-TYPE"));
        Assert.assertTrue((boolean)loggedRequest.containsHeader("Accept"));
        Assert.assertNotNull((Object)loggedRequest.getHeader("Accept"));
    }

    @Test
    public void jsonRepresentation() throws Exception {
        HttpHeaders headers = new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Accept-Language", (String[])new String[]{"en-us,en;q=0.5"})});
        ImmutableMap cookies = ImmutableMap.of((Object)"first_cookie", (Object)new Cookie("yum"), (Object)"monster_cookie", (Object)new Cookie("COOKIIIEESS"));
        Date loggedDate = Dates.parse((String)DATE);
        LoggedRequest loggedRequest = new LoggedRequest("/my/url", "http://mydomain.com/my/url", RequestMethod.GET, "25.10.18.11", headers, (Map)cookies, true, loggedDate, REQUEST_BODY_AS_BASE64, null, null);
        String expectedJson = String.format(JSON_EXAMPLE, loggedDate.getTime());
        JSONAssert.assertEquals((String)expectedJson, (String)Json.write((Object)loggedRequest), (boolean)false);
    }

    @Test
    public void bodyEncodedAsUTF8() throws Exception {
        LoggedRequest loggedRequest = new LoggedRequest("/my/url", "http://mydomain.com/my/url", RequestMethod.GET, null, null, null, true, null, REQUEST_BODY_AS_BASE64, null, null);
        Assert.assertThat((Object)loggedRequest.getBodyAsString(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)REQUEST_BODY)));
    }

    @Test
    public void queryParametersAreSerialized() {
        LoggedRequest req = new LoggedRequest("/sample/path?test-param-1=value-1&test-param-2=value-2", "http://ex.ample/sample/path?test-param-1=value-1&test-param-2=value-2", RequestMethod.GET, "0.0.0.0", null, null, true, new Date(0L), null, null, null);
        Map reqMap = Json.objectToMap((Object)req);
        Assert.assertTrue((boolean)reqMap.containsKey("queryParams"));
        Assert.assertEquals((Object)"value-1", ((List)((Map)((Map)reqMap.get("queryParams")).get("test-param-1")).get("values")).get(0));
        Assert.assertEquals((Object)"value-2", ((List)((Map)((Map)reqMap.get("queryParams")).get("test-param-2")).get("values")).get(0));
    }

    @Test
    public void queryParametersAreDeserialized() throws IOException {
        LoggedRequest req = (LoggedRequest)new ObjectMapper().readValue(JSON_PARAMS_EXAMPLE, LoggedRequest.class);
        Assert.assertEquals((Object)"test-param-1", (Object)req.queryParameter("test-param-1").key());
        Assert.assertEquals((Object)"value-1", (Object)req.queryParameter("test-param-1").firstValue());
        Assert.assertEquals((Object)"test-param-2", (Object)req.queryParameter("test-param-2").key());
        Assert.assertEquals((Object)"value-2", (Object)req.queryParameter("test-param-2").firstValue());
    }
}

