/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LoggedResponseTest {
    private static String ISO_8859_1_RESPONSE_BODY = "k\u00f6ttf\u00e4rss\u00e5s";
    private static String UTF8_RESPONSE_BODY = "Foo \u00a9 bar \ud834\udf06 baz \u2603 qux";

    @Test
    public void returnsEmptyStringForBodyWhenNotConfigured() {
        LoggedResponse loggedResponse = LoggedResponse.from((Response)Response.notConfigured());
        Assert.assertEquals((Object)loggedResponse.getBodyAsString(), (Object)"");
    }

    @Test
    public void returnsEncodedStringForBodyWhenContentTypeHeaderGiven() {
        LoggedResponse loggedResponse = LoggedResponse.from((Response)Response.response().body(ISO_8859_1_RESPONSE_BODY).headers(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Type", (String[])new String[]{"text/plain; charset=iso-8859-1"})})).build());
        Assert.assertThat((Object)ISO_8859_1_RESPONSE_BODY, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)loggedResponse.getBodyAsString())));
    }

    @Test
    public void returnsUtf8StringForBodyWhenContentTypeHeaderAbsent() {
        LoggedResponse loggedResponse = LoggedResponse.from((Response)Response.response().body(UTF8_RESPONSE_BODY).build());
        Assert.assertThat((Object)UTF8_RESPONSE_BODY, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)loggedResponse.getBodyAsString())));
    }
}

