/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.NearMissCalculator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;

public class NearMissCalculatorTest {
    private Mockery context;
    NearMissCalculator nearMissCalculator;
    StubMappings stubMappings;
    RequestJournal requestJournal;
    Scenarios scenarios;

    @Before
    public void init() {
        this.context = new Mockery();
        this.stubMappings = (StubMappings)this.context.mock(StubMappings.class);
        this.requestJournal = (RequestJournal)this.context.mock(RequestJournal.class);
        this.scenarios = new Scenarios();
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal, this.scenarios);
    }

    @Test
    public void returnsNearest3MissesForSingleRequest() {
        this.givenStubMappings(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/righ")).willReturn(WireMock.aResponse()), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/totally-wrong1")).willReturn(WireMock.aResponse()), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/totally-wrong222")).willReturn(WireMock.aResponse()), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/almost-right")).willReturn(WireMock.aResponse()), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/rig")).willReturn(WireMock.aResponse()), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/totally-wrong33333")).willReturn(WireMock.aResponse()));
        List nearest = this.nearMissCalculator.findNearestTo(MockRequest.mockRequest().url("/right").asLoggedRequest());
        MatcherAssert.assertThat((Object)nearest.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(0)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/righ"));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(1)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/rig"));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(2)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/almost-right"));
    }

    @Test
    public void returns0NearMissesForSingleRequestWhenNoStubsPresent() {
        this.givenStubMappings(new MappingBuilder[0]);
        List nearest = this.nearMissCalculator.findNearestTo(MockRequest.mockRequest().url("/right").asLoggedRequest());
        MatcherAssert.assertThat((Object)nearest.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void returns3NearestMissesForTheGivenRequestPattern() {
        this.givenRequests(MockRequest.mockRequest().method(RequestMethod.DELETE).url("/rig"), MockRequest.mockRequest().method(RequestMethod.DELETE).url("/righ"), MockRequest.mockRequest().method(RequestMethod.DELETE).url("/almost-right"), MockRequest.mockRequest().method(RequestMethod.POST).url("/almost-right"));
        List nearest = this.nearMissCalculator.findNearestTo(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.DELETE, (UrlPattern)WireMock.urlEqualTo((String)"/right")).build());
        MatcherAssert.assertThat((Object)nearest.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/righ"));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/rig"));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(2)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/almost-right"));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(2)).getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.DELETE));
    }

    @Test
    public void returns1NearestMissForTheGivenRequestPatternWhenOnlyOneRequestLogged() {
        this.givenRequests(MockRequest.mockRequest().method(RequestMethod.DELETE).url("/righ"));
        List nearest = this.nearMissCalculator.findNearestTo(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.DELETE, (UrlPattern)WireMock.urlEqualTo((String)"/right")).build());
        MatcherAssert.assertThat((Object)nearest.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((NearMiss)nearest.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/righ"));
    }

    @Test
    public void returns0NearMissesForSingleRequestPatternWhenNoRequestsLogged() {
        this.givenRequests(new Request[0]);
        List nearest = this.nearMissCalculator.findNearestTo(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.DELETE, (UrlPattern)WireMock.urlEqualTo((String)"/right")).build());
        MatcherAssert.assertThat((Object)nearest.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void stubMappingsWithIdenticalMethodAndUrlWillRankHigherDespiteOtherParametersBeingAbsent() {
        this.givenStubMappings(WireMock.post((String)"/the-correct-path").withName("Correct").withHeader("Accept", WireMock.equalTo((String)"text/plain")).withHeader("X-My-Header", WireMock.matching((String)"[0-9]*")).withQueryParam("search", WireMock.containing((String)"somethings")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"[1, 2, 3]")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..*")).willReturn(WireMock.ok()), WireMock.post((String)"/another-path").withName("Another 1").willReturn(WireMock.ok()), WireMock.get((String)"/yet-another-path").withName("Yet another").willReturn(WireMock.ok()));
        List nearestForCorrectMethodAndUrl = this.nearMissCalculator.findNearestTo(MockRequest.mockRequest().method(RequestMethod.POST).url("/the-correct-path").asLoggedRequest());
        MatcherAssert.assertThat((Object)((NearMiss)nearestForCorrectMethodAndUrl.get(0)).getStubMapping().getName(), (Matcher)Matchers.is((Object)"Correct"));
        List nearestForIncorrectMethodAndCorrectUrl = this.nearMissCalculator.findNearestTo(MockRequest.mockRequest().method(RequestMethod.POST).url("/the-incorrect-path").asLoggedRequest());
        MatcherAssert.assertThat((Object)((NearMiss)nearestForIncorrectMethodAndCorrectUrl.get(0)).getStubMapping().getName(), (Matcher)Matchers.is((Object)"Correct"));
        List nearestForIncorrectMethodAndUrl = this.nearMissCalculator.findNearestTo(MockRequest.mockRequest().method(RequestMethod.PUT).url("/the-incorrect-path").asLoggedRequest());
        MatcherAssert.assertThat((Object)((NearMiss)nearestForIncorrectMethodAndUrl.get(0)).getStubMapping().getName(), (Matcher)Matchers.is((Object)"Correct"));
    }

    private void givenStubMappings(MappingBuilder ... mappingBuilders) {
        ImmutableList mappings = FluentIterable.from((Object[])mappingBuilders).transform((Function)new Function<MappingBuilder, StubMapping>(){

            public StubMapping apply(MappingBuilder input) {
                return input.build();
            }
        }).toList();
        this.context.checking((ExpectationBuilder)new Expectations((List)mappings){
            final /* synthetic */ List val$mappings;
            {
                this.val$mappings = list;
                ((StubMappings)this.allowing(NearMissCalculatorTest.this.stubMappings)).getAll();
                this.will(2.returnValue((Object)this.val$mappings));
            }
        });
    }

    private void givenRequests(Request ... requests) {
        ImmutableList serveEvents = FluentIterable.from((Object[])requests).transform((Function)new Function<Request, ServeEvent>(){

            public ServeEvent apply(Request request) {
                return ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)request), (ResponseDefinition)new ResponseDefinition());
            }
        }).toList();
        this.context.checking((ExpectationBuilder)new Expectations((List)serveEvents){
            final /* synthetic */ List val$serveEvents;
            {
                this.val$serveEvents = list;
                ((RequestJournal)this.allowing(NearMissCalculatorTest.this.requestJournal)).getAllServeEvents();
                this.will(4.returnValue((Object)this.val$serveEvents));
            }
        });
    }
}

