/*
 * Decompiled with CFR 0.152.
 */
package ignored;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MassiveNearMissTest {
    @Rule
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort(), false);
    WireMockTestClient client;

    @Before
    public void setup() {
        this.client = new WireMockTestClient(this.wm.port());
    }

    @Test
    public void timeToCalculateBigNearMissDiffXml() {
        int stubs = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wm.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)("/things/.*/" + i))).withRequestBody((ContentPattern)WireMock.equalToXml((String)MassiveNearMissTest.requestXml(i))).willReturn(WireMock.ok((String)("i: " + i))));
        }
        int drop = 2;
        int reps = 10;
        ArrayList<Long> times = new ArrayList<Long>(10);
        long sum = 0L;
        for (int i = 0; i < 10; ++i) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.client.postXml("/things/blah123/500", "<?xml version=\"1.0\"?><things id=\"" + i + "\"/>", new TestHttpHeader[0]);
            stopwatch.stop();
            long time = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            times.add(time);
            if (i <= 2) continue;
            sum += time;
        }
        System.out.printf("Times:\n%s\n", Joiner.on((String)"\n").join(times));
        long mean = sum / 8L;
        System.out.printf("Mean: %dms\n", mean);
    }

    private static String requestXml(int i) {
        return String.format("<?xml version=\"1.0\"?>\n\n<things id=\"%d\">\n    <stuff id=\"1\"/>\n    <fluff id=\"2\"/>\n\n    <inside>\n        <deep-inside level=\"3\">\n            <one/>\n            <two/>\n            <three/>\n            <four/>\n            <one/>\n            <text subject=\"JWT\">\n                JSON Web Token (JWT) is a compact, URL-safe means of representing claims to be transferred between two parties. The claims in a JWT are encoded as a JSON object that is used as the payload of a JSON Web Signature (JWS) structure or as the plaintext of a JSON Web Encryption (JWE) structure, enabling the claims to be digitally signed or integrity protected with a Message Authentication Code (MAC) and/or encrypted.\n            </text>\n        </deep-inside>\n    </inside>\n\n</things>", i);
    }

    @Test
    public void timeToCalculateBigNearMissDiffJson() {
        int stubs = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wm.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)("/things/.*/" + i))).withRequestBody((ContentPattern)WireMock.equalToJson((String)this.requestJson(i))).willReturn(WireMock.ok((String)("i: " + i))));
        }
        int drop = 2;
        int reps = 30;
        ArrayList<Long> times = new ArrayList<Long>(30);
        long sum = 0L;
        for (int i = 0; i < 30; ++i) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.client.postJson("/things/blah123/500", "{ \"wrong\": [1,2,3]}", new TestHttpHeader[0]);
            stopwatch.stop();
            long time = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            times.add(time);
            if (i <= 2) continue;
            sum += time;
        }
        System.out.printf("Times:\n%s\n", Joiner.on((String)"\n").join(times));
        long mean = sum / 28L;
        System.out.printf("Mean: %dms\n", mean);
    }

    private String requestJson(int i) {
        return "{\n  \"children\": [\n    {\n      \"id\": \"9010946\",\n      \"age\": 1,\n      \"isRegistered\": false\n    },\n    {\n      \"id\": \"9405762\",\n      \"age\": 1,\n      \"isRegistered\": true\n    },\n    {\n      \"id\": \"9166586\",\n      \"age\": 1,\n      \"isRegistered\": false\n    },\n    {\n      \"id\": \"7537984\",\n      \"age\": 1,\n      \"isRegistered\": true\n    }\n  ],\n  \"category\": \"060\",\n  \"id\": \"" + i + "\",\n" + "  \"isRegistered\": true,\n" + "  \"date\": \"20200312\"\n" + "}";
    }
}

