/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathFileSource
implements FileSource {
    private final String path;
    private URI pathUri;
    private ZipFile zipFile;
    private File rootDirectory;

    public ClasspathFileSource(String path) {
        block5: {
            this.path = path;
            try {
                URL resource = ((ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)Resources.class.getClassLoader())).getResource(path);
                if (resource == null) {
                    this.rootDirectory = new File(path);
                    this.pathUri = this.rootDirectory.toURI();
                    return;
                }
                this.pathUri = resource.toURI();
                if (Arrays.asList("jar", "war", "ear", "zip").contains(this.pathUri.getScheme())) {
                    String jarFileUri = this.pathUri.getSchemeSpecificPart().split("!")[0];
                    File file = new File(URI.create(jarFileUri));
                    this.zipFile = new ZipFile(file);
                    break block5;
                }
                if (this.pathUri.getScheme().equals("file")) {
                    this.rootDirectory = new File(this.pathUri);
                    break block5;
                }
                throw new RuntimeException("ClasspathFileSource can't handle paths of type " + this.pathUri.getScheme());
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }

    private boolean isFileSystem() {
        return this.rootDirectory != null;
    }

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        if (this.isFileSystem()) {
            return new BinaryFile(new File(this.rootDirectory, name).toURI());
        }
        return new BinaryFile(this.getZipEntryUri(name));
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        if (this.isFileSystem()) {
            return new TextFile(new File(this.rootDirectory, name).toURI());
        }
        return new TextFile(this.getZipEntryUri(name));
    }

    private URI getZipEntryUri(final String name) {
        ZipEntry zipEntry = (ZipEntry)Iterators.find((Iterator)Iterators.forEnumeration(this.zipFile.entries()), (Predicate)new Predicate<ZipEntry>(){

            public boolean apply(ZipEntry input) {
                return input.getName().equals(ClasspathFileSource.this.path + "/" + name);
            }
        });
        return this.getUriFor(zipEntry);
    }

    @Override
    public void createIfNecessary() {
        throw new UnsupportedOperationException("Classpath file sources are read-only");
    }

    @Override
    public FileSource child(String subDirectoryName) {
        return new ClasspathFileSource(this.path + "/" + subDirectoryName);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URI getUri() {
        return this.pathUri;
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        if (this.isFileSystem()) {
            this.assertExistsAndIsDirectory();
            ArrayList fileList = Lists.newArrayList();
            this.recursivelyAddFilesToList(this.rootDirectory, fileList);
            return this.toTextFileList(fileList);
        }
        return FluentIterable.from(ClasspathFileSource.toIterable(this.zipFile.entries())).filter((Predicate)new Predicate<ZipEntry>(){

            public boolean apply(ZipEntry jarEntry) {
                return !jarEntry.isDirectory() && jarEntry.getName().startsWith(ClasspathFileSource.this.path);
            }
        }).transform((Function)new Function<ZipEntry, TextFile>(){

            public TextFile apply(ZipEntry jarEntry) {
                return new TextFile(ClasspathFileSource.this.getUriFor(jarEntry));
            }
        }).toList();
    }

    private URI getUriFor(ZipEntry jarEntry) {
        try {
            return Resources.getResource((String)jarEntry.getName()).toURI();
        }
        catch (URISyntaxException e) {
            return Exceptions.throwUnchecked(e, URI.class);
        }
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return Lists.newArrayList((Iterable)Iterables.transform(fileList, (Function)new Function<File, TextFile>(){

            public TextFile apply(File input) {
                return new TextFile(input.toURI());
            }
        }));
    }

    @Override
    public void writeTextFile(String name, String contents) {
        throw new UnsupportedOperationException("Classpath file sources are read-only");
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
        throw new UnsupportedOperationException("Classpath file sources are read-only");
    }

    @Override
    public boolean exists() {
        return this.isFileSystem() && this.rootDirectory.exists() || !this.isFileSystem();
    }

    @Override
    public void deleteFile(String name) {
        throw new UnsupportedOperationException("Classpath file sources are read-only");
    }

    private static <T> Iterable<T> toIterable(final Enumeration<T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.forEnumeration((Enumeration)e);
            }
        };
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }
}

