/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;

class FileUpload {
    private final FileItemFactory fileItemFactory;
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private String headerEncoding;

    FileUpload(FileItemFactory fileItemFactory) {
        this.fileItemFactory = fileItemFactory;
    }

    protected FileItemIterator getItemIterator(RequestContext ctx) throws FileUploadException, IOException {
        try {
            return new FileItemIteratorImpl(ctx);
        }
        catch (FileUploadBase.FileUploadIOException e) {
            throw (FileUploadException)e.getCause();
        }
    }

    protected FileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public List<FileItem> parseRequest(RequestContext ctx) throws FileUploadException {
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        boolean successful = false;
        try {
            FileItemIterator iter = this.getItemIterator(ctx);
            FileItemFactory fac = this.getFileItemFactory();
            if (fac == null) {
                throw new NullPointerException("No FileItemFactory has been set.");
            }
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fileName = ((FileItemIteratorImpl.FileItemStreamImpl)item).name;
                FileItem fileItem = fac.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), fileName);
                items.add(fileItem);
                try {
                    Streams.copy((InputStream)item.openStream(), (OutputStream)fileItem.getOutputStream(), (boolean)true);
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    throw (FileUploadException)e.getCause();
                }
                catch (IOException e) {
                    throw new FileUploadBase.IOFileUploadException(String.format("Processing of %s request failed. %s", "multipart/form-data", e.getMessage()), e);
                }
                FileItemHeaders fih = item.getHeaders();
                fileItem.setHeaders(fih);
            }
            successful = true;
            ArrayList<FileItem> arrayList = items;
            return arrayList;
        }
        catch (FileUploadBase.FileUploadIOException e) {
            throw (FileUploadException)e.getCause();
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!successful) {
                for (FileItem fileItem : items) {
                    try {
                        fileItem.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected String getFileName(FileItemHeaders headers) {
        return this.getFileName(headers.getHeader("Content-disposition"));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || cdl.startsWith("attachment"))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(pContentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    protected String getFieldName(FileItemHeaders headers) {
        return this.getFieldName(headers.getHeader("Content-disposition"));
    }

    private String getFieldName(String pContentDisposition) {
        String fieldName = null;
        if (pContentDisposition != null && pContentDisposition.toLowerCase(Locale.ENGLISH).startsWith("form-data")) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(pContentDisposition, ';');
            fieldName = (String)params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected FileItemHeaders getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        FileItemHeadersImpl headers = this.newFileItemHeaders();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            StringBuilder header = new StringBuilder(headerPart.substring(start, end));
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header.append(" ").append(headerPart.substring(nonWs, end));
                start = end + 2;
            }
            this.parseHeaderLine(headers, header.toString());
        }
        return headers;
    }

    protected FileItemHeadersImpl newFileItemHeaders() {
        return new FileItemHeadersImpl();
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(FileItemHeadersImpl headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        headers.addHeader(headerName, headerValue);
    }

    private class FileItemIteratorImpl
    implements FileItemIterator {
        private final MultipartStream multi;
        private final byte[] boundary;
        private FileItemStreamImpl currentItem;
        private String currentFieldName;
        private boolean skipPreamble;
        private boolean itemValid;
        private boolean eof;

        FileItemIteratorImpl(RequestContext ctx) throws FileUploadException, IOException {
            InputStream input;
            long requestSize;
            if (ctx == null) {
                throw new NullPointerException("ctx parameter");
            }
            String contentType = ctx.getContentType();
            if (null == contentType || !contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/")) {
                throw new FileUploadBase.InvalidContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", "multipart/form-data", "multipart/mixed", contentType));
            }
            int contentLengthInt = ctx.getContentLength();
            long l = requestSize = UploadContext.class.isAssignableFrom(ctx.getClass()) ? ((UploadContext)ctx).contentLength() : (long)contentLengthInt;
            if (FileUpload.this.sizeMax >= 0L) {
                if (requestSize != -1L && requestSize > FileUpload.this.sizeMax) {
                    throw new FileUploadBase.SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", requestSize, FileUpload.this.sizeMax), requestSize, FileUpload.this.sizeMax);
                }
                input = new LimitedInputStream(ctx.getInputStream(), FileUpload.this.sizeMax){

                    protected void raiseError(long pSizeMax, long pCount) throws IOException {
                        FileUploadBase.SizeLimitExceededException ex = new FileUploadBase.SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", pCount, pSizeMax), pCount, pSizeMax);
                        throw new FileUploadBase.FileUploadIOException((FileUploadException)ex);
                    }
                };
            } else {
                input = ctx.getInputStream();
            }
            String charEncoding = FileUpload.this.headerEncoding;
            if (charEncoding == null) {
                charEncoding = ctx.getCharacterEncoding();
            }
            this.boundary = FileUpload.this.getBoundary(contentType);
            if (this.boundary == null) {
                IOUtils.closeQuietly((InputStream)input);
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            try {
                this.multi = new MultipartStream(input, this.boundary, 4096, null);
            }
            catch (IllegalArgumentException iae) {
                IOUtils.closeQuietly((InputStream)input);
                throw new FileUploadBase.InvalidContentTypeException(String.format("The boundary specified in the %s header is too long", "Content-type"), (Throwable)iae);
            }
            this.multi.setHeaderEncoding(charEncoding);
            this.skipPreamble = true;
            this.findNextItem();
        }

        private boolean findNextItem() throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.currentItem != null) {
                this.currentItem.close();
                this.currentItem = null;
            }
            while (true) {
                boolean nextPart;
                if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                    if (this.currentFieldName == null) {
                        this.eof = true;
                        return false;
                    }
                    this.multi.setBoundary(this.boundary);
                    this.currentFieldName = null;
                    continue;
                }
                FileItemHeaders headers = FileUpload.this.getParsedHeaders(this.multi.readHeaders());
                if (this.currentFieldName == null) {
                    String fieldName = FileUpload.this.getFieldName(headers);
                    if (fieldName != null) {
                        String subContentType = headers.getHeader("Content-type");
                        if (subContentType != null && subContentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/mixed")) {
                            this.currentFieldName = fieldName;
                            byte[] subBoundary = FileUpload.this.getBoundary(subContentType);
                            this.multi.setBoundary(subBoundary);
                            this.skipPreamble = true;
                            continue;
                        }
                        String fileName = FileUpload.this.getFileName(headers);
                        this.currentItem = new FileItemStreamImpl(fileName, fieldName, headers.getHeader("Content-type"), fileName == null, this.getContentLength(headers));
                        this.currentItem.setHeaders(headers);
                        this.itemValid = true;
                        return true;
                    }
                } else {
                    String fileName = FileUpload.this.getFileName(headers);
                    if (fileName != null) {
                        this.currentItem = new FileItemStreamImpl(fileName, this.currentFieldName, headers.getHeader("Content-type"), false, this.getContentLength(headers));
                        this.currentItem.setHeaders(headers);
                        this.itemValid = true;
                        return true;
                    }
                }
                this.multi.discardBodyData();
            }
        }

        private long getContentLength(FileItemHeaders pHeaders) {
            try {
                return Long.parseLong(pHeaders.getHeader("Content-length"));
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public boolean hasNext() throws FileUploadException, IOException {
            if (this.eof) {
                return false;
            }
            if (this.itemValid) {
                return true;
            }
            try {
                return this.findNextItem();
            }
            catch (FileUploadBase.FileUploadIOException e) {
                throw (FileUploadException)e.getCause();
            }
        }

        public FileItemStream next() throws FileUploadException, IOException {
            if (this.eof || !this.itemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.itemValid = false;
            return this.currentItem;
        }

        class FileItemStreamImpl
        implements FileItemStream {
            private final String contentType;
            private final String fieldName;
            private final String name;
            private final boolean formField;
            private final InputStream stream;
            private boolean opened;
            private FileItemHeaders headers;

            FileItemStreamImpl(String pName, String pFieldName, String pContentType, boolean pFormField, long pContentLength) throws IOException {
                this.name = pName;
                this.fieldName = pFieldName;
                this.contentType = pContentType;
                this.formField = pFormField;
                if (FileUpload.this.fileSizeMax != -1L && pContentLength != -1L && pContentLength > FileUpload.this.fileSizeMax) {
                    FileUploadBase.FileSizeLimitExceededException e = new FileUploadBase.FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.fieldName, FileUpload.this.fileSizeMax), pContentLength, FileUpload.this.fileSizeMax);
                    e.setFileName(pName);
                    e.setFieldName(pFieldName);
                    throw new FileUploadBase.FileUploadIOException((FileUploadException)e);
                }
                final PipedInputStream itemStream = new PipedInputStream();
                try (PipedOutputStream out = new PipedOutputStream(itemStream);){
                    FileItemIteratorImpl.this.multi.readBodyData((OutputStream)out);
                }
                PipedInputStream istream = itemStream;
                if (FileUpload.this.fileSizeMax != -1L) {
                    istream = new LimitedInputStream(istream, FileUpload.this.fileSizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            itemStream.close();
                            FileUploadBase.FileSizeLimitExceededException e = new FileUploadBase.FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", FileItemStreamImpl.this.fieldName, pSizeMax), pCount, pSizeMax);
                            e.setFieldName(FileItemStreamImpl.this.fieldName);
                            e.setFileName(FileItemStreamImpl.this.name);
                            throw new FileUploadBase.FileUploadIOException((FileUploadException)e);
                        }
                    };
                }
                this.stream = istream;
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getName() {
                return Streams.checkFileName((String)this.name);
            }

            public boolean isFormField() {
                return this.formField;
            }

            public InputStream openStream() throws IOException {
                if (this.opened) {
                    throw new IllegalStateException("The stream was already opened.");
                }
                if (this.stream instanceof Closeable && ((Closeable)this.stream).isClosed()) {
                    throw new FileItemStream.ItemSkippedException();
                }
                return this.stream;
            }

            void close() throws IOException {
                this.stream.close();
            }

            public FileItemHeaders getHeaders() {
                return this.headers;
            }

            public void setHeaders(FileItemHeaders pHeaders) {
                this.headers = pHeaders;
            }
        }
    }
}

