/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.InMemoryRecorderStateStore;
import com.github.tomakehurst.wiremock.store.InMemoryRequestJournalStore;
import com.github.tomakehurst.wiremock.store.InMemoryScenariosStore;
import com.github.tomakehurst.wiremock.store.InMemorySettingsStore;
import com.github.tomakehurst.wiremock.store.InMemoryStubMappingStore;
import com.github.tomakehurst.wiremock.store.RecorderStateStore;
import com.github.tomakehurst.wiremock.store.RequestJournalStore;
import com.github.tomakehurst.wiremock.store.ScenariosStore;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.store.StubMappingStore;
import com.github.tomakehurst.wiremock.store.files.FileSourceBlobStore;

public class DefaultStores
implements Stores {
    private final FileSource fileRoot;
    private final StubMappingStore stubMappingStore;
    private final RequestJournalStore requestJournalStore;
    private final SettingsStore settingsStore;
    private final ScenariosStore scenariosStore;

    public DefaultStores(FileSource fileRoot) {
        this.fileRoot = fileRoot;
        this.stubMappingStore = new InMemoryStubMappingStore();
        this.requestJournalStore = new InMemoryRequestJournalStore();
        this.settingsStore = new InMemorySettingsStore();
        this.scenariosStore = new InMemoryScenariosStore();
    }

    @Override
    public StubMappingStore getStubStore() {
        return this.stubMappingStore;
    }

    @Override
    public RequestJournalStore getRequestJournalStore() {
        return this.requestJournalStore;
    }

    @Override
    public SettingsStore getSettingsStore() {
        return this.settingsStore;
    }

    @Override
    public ScenariosStore getScenariosStore() {
        return this.scenariosStore;
    }

    @Override
    public RecorderStateStore getRecorderStateStore() {
        return new InMemoryRecorderStateStore();
    }

    @Override
    public BlobStore getBlobStore(String name) {
        return new FileSourceBlobStore(this.fileRoot.child(name));
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

