/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSourceFactory;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionLoader;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.ThreadPoolFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.ConsoleNotifyingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.DoNothingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty.QueuedThreadPoolFactory;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.BasicAuthenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.store.DefaultStores;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class CommandLineOptions
implements Options {
    private static final String HELP = "help";
    private static final String RECORD_MAPPINGS = "record-mappings";
    private static final String MATCH_HEADERS = "match-headers";
    private static final String PROXY_ALL = "proxy-all";
    private static final String PRESERVE_HOST_HEADER = "preserve-host-header";
    private static final String PROXY_VIA = "proxy-via";
    private static final String TIMEOUT = "timeout";
    private static final String PORT = "port";
    private static final String DISABLE_HTTP = "disable-http";
    private static final String BIND_ADDRESS = "bind-address";
    private static final String HTTPS_PORT = "https-port";
    private static final String HTTPS_KEYSTORE = "https-keystore";
    private static final String HTTPS_KEYSTORE_PASSWORD = "keystore-password";
    private static final String HTTPS_KEYSTORE_TYPE = "keystore-type";
    private static final String HTTPS_KEY_MANAGER_PASSWORD = "key-manager-password";
    private static final String HTTPS_TRUSTSTORE = "https-truststore";
    private static final String HTTPS_TRUSTSTORE_PASSWORD = "truststore-password";
    private static final String HTTPS_TRUSTSTORE_TYPE = "truststore-type";
    private static final String REQUIRE_CLIENT_CERT = "https-require-client-cert";
    private static final String VERBOSE = "verbose";
    private static final String ENABLE_BROWSER_PROXYING = "enable-browser-proxying";
    private static final String DISABLE_BANNER = "disable-banner";
    private static final String DISABLE_REQUEST_JOURNAL = "no-request-journal";
    private static final String EXTENSIONS = "extensions";
    private static final String MAX_ENTRIES_REQUEST_JOURNAL = "max-request-journal-entries";
    private static final String JETTY_ACCEPTOR_THREAD_COUNT = "jetty-acceptor-threads";
    private static final String PRINT_ALL_NETWORK_TRAFFIC = "print-all-network-traffic";
    private static final String JETTY_ACCEPT_QUEUE_SIZE = "jetty-accept-queue-size";
    @Deprecated
    private static final String JETTY_HEADER_BUFFER_SIZE = "jetty-header-buffer-size";
    private static final String JETTY_HEADER_REQUEST_SIZE = "jetty-header-request-size";
    private static final String JETTY_HEADER_RESPONSE_SIZE = "jetty-header-response-size";
    private static final String JETTY_STOP_TIMEOUT = "jetty-stop-timeout";
    private static final String JETTY_IDLE_TIMEOUT = "jetty-idle-timeout";
    private static final String ROOT_DIR = "root-dir";
    private static final String CONTAINER_THREADS = "container-threads";
    private static final String GLOBAL_RESPONSE_TEMPLATING = "global-response-templating";
    private static final String LOCAL_RESPONSE_TEMPLATING = "local-response-templating";
    private static final String ADMIN_API_BASIC_AUTH = "admin-api-basic-auth";
    private static final String ADMIN_API_REQUIRE_HTTPS = "admin-api-require-https";
    private static final String ASYNCHRONOUS_RESPONSE_ENABLED = "async-response-enabled";
    private static final String ASYNCHRONOUS_RESPONSE_THREADS = "async-response-threads";
    private static final String USE_CHUNKED_ENCODING = "use-chunked-encoding";
    private static final String MAX_TEMPLATE_CACHE_ENTRIES = "max-template-cache-entries";
    private static final String PERMITTED_SYSTEM_KEYS = "permitted-system-keys";
    private static final String DISABLE_GZIP = "disable-gzip";
    private static final String DISABLE_REQUEST_LOGGING = "disable-request-logging";
    private static final String ENABLE_STUB_CORS = "enable-stub-cors";
    private static final String TRUST_ALL_PROXY_TARGETS = "trust-all-proxy-targets";
    private static final String TRUST_PROXY_TARGET = "trust-proxy-target";
    private static final String HTTPS_CA_KEYSTORE = "ca-keystore";
    private static final String HTTPS_CA_KEYSTORE_PASSWORD = "ca-keystore-password";
    private static final String HTTPS_CA_KEYSTORE_TYPE = "ca-keystore-type";
    private static final String DISABLE_OPTIMIZE_XML_FACTORIES_LOADING = "disable-optimize-xml-factories-loading";
    private static final String DISABLE_STRICT_HTTP_HEADERS = "disable-strict-http-headers";
    private static final String LOAD_RESOURCES_FROM_CLASSPATH = "load-resources-from-classpath";
    private static final String LOGGED_RESPONSE_BODY_SIZE_LIMIT = "logged-response-body-size-limit";
    private static final String ALLOW_PROXY_TARGETS = "allow-proxy-targets";
    private static final String DENY_PROXY_TARGETS = "deny-proxy-targets";
    private static final String PROXY_TIMEOUT = "proxy-timeout";
    private static final String PROXY_PASS_THROUGH = "proxy-pass-through";
    private final OptionSet optionSet;
    private final Stores stores;
    private final FileSource fileSource;
    private final MappingsSource mappingsSource;
    private final Map<String, Extension> extensions;
    private String helpText;
    private Integer actualHttpPort;
    private Integer actualHttpsPort;

    public CommandLineOptions(String ... args) {
        OptionParser optionParser = new OptionParser();
        optionParser.accepts(PORT, "The port number for the server to listen on (default: 8080). 0 for dynamic port selection.").withRequiredArg();
        optionParser.accepts(DISABLE_HTTP, "Disable the default HTTP listener.");
        optionParser.accepts(HTTPS_PORT, "If this option is present WireMock will enable HTTPS on the specified port").withRequiredArg();
        optionParser.accepts(BIND_ADDRESS, "The IP to listen connections").withRequiredArg();
        optionParser.accepts(CONTAINER_THREADS, "The number of container threads").withRequiredArg();
        optionParser.accepts(TIMEOUT, "The default global timeout.");
        optionParser.accepts(DISABLE_OPTIMIZE_XML_FACTORIES_LOADING, "Whether to disable optimize XML factories loading or not.");
        optionParser.accepts(DISABLE_STRICT_HTTP_HEADERS, "Whether to disable strict HTTP header handling of Jetty or not.");
        optionParser.accepts(REQUIRE_CLIENT_CERT, "Make the server require a trusted client certificate to enable a connection");
        optionParser.accepts(HTTPS_TRUSTSTORE_TYPE, "The HTTPS trust store type").withRequiredArg().defaultsTo((Object)"JKS", (Object[])new String[0]);
        optionParser.accepts(HTTPS_TRUSTSTORE_PASSWORD, "Password for the trust store").withRequiredArg().defaultsTo((Object)"password", (Object[])new String[0]);
        optionParser.accepts(HTTPS_TRUSTSTORE, "Path to an alternative truststore for HTTPS client certificates. Must have a password of \"password\".").requiredIf(REQUIRE_CLIENT_CERT, new String[0]).requiredIf(HTTPS_TRUSTSTORE_PASSWORD, new String[0]).withRequiredArg();
        optionParser.accepts(HTTPS_KEYSTORE_TYPE, "The HTTPS keystore type.").withRequiredArg().defaultsTo((Object)"JKS", (Object[])new String[0]);
        optionParser.accepts(HTTPS_KEYSTORE_PASSWORD, "Password for the alternative keystore.").withRequiredArg().defaultsTo((Object)"password", (Object[])new String[0]);
        optionParser.accepts(HTTPS_KEY_MANAGER_PASSWORD, "Key manager password for use with the alternative keystore.").withRequiredArg().defaultsTo((Object)"password", (Object[])new String[0]);
        optionParser.accepts(HTTPS_KEYSTORE, "Path to an alternative keystore for HTTPS. Password is assumed to be \"password\" if not specified.").requiredIf(HTTPS_KEYSTORE_PASSWORD, new String[0]).withRequiredArg().defaultsTo((Object)Resources.getResource((String)"keystore").toString(), (Object[])new String[0]);
        optionParser.accepts(PROXY_ALL, "Will create a proxy mapping for /* to the specified URL").withRequiredArg();
        optionParser.accepts(PRESERVE_HOST_HEADER, "Will transfer the original host header from the client to the proxied service");
        optionParser.accepts(PROXY_VIA, "Specifies a proxy server to use when routing proxy mapped requests").withRequiredArg();
        optionParser.accepts(RECORD_MAPPINGS, "Enable recording of all (non-admin) requests as mapping files");
        optionParser.accepts(MATCH_HEADERS, "Enable request header matching when recording through a proxy").withRequiredArg();
        optionParser.accepts(ROOT_DIR, "Specifies path for storing recordings (parent for mappings and __files folders)").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        optionParser.accepts(VERBOSE, "Enable verbose logging to stdout");
        optionParser.accepts(ENABLE_BROWSER_PROXYING, "Allow wiremock to be set as a browser's proxy server");
        optionParser.accepts(DISABLE_REQUEST_JOURNAL, "Disable the request journal (to avoid heap growth when running wiremock for long periods without reset)");
        optionParser.accepts(DISABLE_BANNER, "Disable print banner logo");
        optionParser.accepts(EXTENSIONS, "Matching and/or response transformer extension class names, comma separated.").withRequiredArg();
        optionParser.accepts(MAX_ENTRIES_REQUEST_JOURNAL, "Set maximum number of entries in request journal (if enabled) to discard old entries if the log becomes too large. Default: no discard").withRequiredArg();
        optionParser.accepts(JETTY_ACCEPTOR_THREAD_COUNT, "Number of Jetty acceptor threads").withRequiredArg();
        optionParser.accepts(JETTY_ACCEPT_QUEUE_SIZE, "The size of Jetty's accept queue size").withRequiredArg();
        optionParser.accepts(JETTY_HEADER_BUFFER_SIZE, "Deprecated. The size of Jetty's buffer for request headers").withRequiredArg();
        optionParser.accepts(JETTY_HEADER_REQUEST_SIZE, "The size of Jetty's buffer for request headers").withRequiredArg();
        optionParser.accepts(JETTY_HEADER_RESPONSE_SIZE, "The size of Jetty's buffer for response headers").withRequiredArg();
        optionParser.accepts(JETTY_STOP_TIMEOUT, "Timeout in milliseconds for Jetty to stop").withRequiredArg();
        optionParser.accepts(JETTY_IDLE_TIMEOUT, "Idle timeout in milliseconds for Jetty connections").withRequiredArg();
        optionParser.accepts(PRINT_ALL_NETWORK_TRAFFIC, "Print all raw incoming and outgoing network traffic to console");
        optionParser.accepts(GLOBAL_RESPONSE_TEMPLATING, "Preprocess all responses with Handlebars templates");
        optionParser.accepts(LOCAL_RESPONSE_TEMPLATING, "Preprocess selected responses with Handlebars templates");
        optionParser.accepts(ADMIN_API_BASIC_AUTH, "Require HTTP Basic authentication for admin API calls with the supplied credentials in username:password format").withRequiredArg();
        optionParser.accepts(ADMIN_API_REQUIRE_HTTPS, "Require HTTPS to be used to access the admin API");
        optionParser.accepts(ASYNCHRONOUS_RESPONSE_ENABLED, "Enable asynchronous response").withRequiredArg().defaultsTo((Object)"false", (Object[])new String[0]);
        optionParser.accepts(ASYNCHRONOUS_RESPONSE_THREADS, "Number of asynchronous response threads").withRequiredArg().defaultsTo((Object)"10", (Object[])new String[0]);
        optionParser.accepts(USE_CHUNKED_ENCODING, "Whether to use Transfer-Encoding: chunked in responses. Can be set to always, never or body_file.").withRequiredArg().defaultsTo((Object)"always", (Object[])new String[0]);
        optionParser.accepts(MAX_TEMPLATE_CACHE_ENTRIES, "The maximum number of response template fragments that can be cached. Only has any effect when templating is enabled. Defaults to no limit.").withOptionalArg();
        optionParser.accepts(PERMITTED_SYSTEM_KEYS, "A list of case-insensitive regular expressions for names of permitted system properties and environment vars. Only has any effect when templating is enabled. Defaults to no limit.").withOptionalArg().ofType(String.class).withValuesSeparatedBy(",");
        optionParser.accepts(DISABLE_GZIP, "Disable gzipping of request and response bodies");
        optionParser.accepts(DISABLE_REQUEST_LOGGING, "Disable logging of stub requests and responses to the notifier. Useful when performance testing.");
        optionParser.accepts(ENABLE_STUB_CORS, "Enable automatic sending of CORS headers with stub responses.");
        optionParser.accepts(TRUST_ALL_PROXY_TARGETS, "Trust all certificates presented by origins when browser proxying").availableIf(ENABLE_BROWSER_PROXYING, new String[0]);
        optionParser.accepts(TRUST_PROXY_TARGET, "Trust any certificate presented by this origin when browser proxying").availableIf(ENABLE_BROWSER_PROXYING, new String[0]).availableUnless(TRUST_ALL_PROXY_TARGETS, new String[0]).withRequiredArg();
        optionParser.accepts(HTTPS_CA_KEYSTORE, "Path to an alternative keystore containing a Certificate Authority private key & certificate for generating certificates when proxying HTTPS. Password is assumed to be \"password\" if not specified.").availableIf(ENABLE_BROWSER_PROXYING, new String[0]).withRequiredArg().defaultsTo((Object)BrowserProxySettings.DEFAULT_CA_KEYSTORE_PATH, (Object[])new String[0]);
        optionParser.accepts(HTTPS_CA_KEYSTORE_PASSWORD, "Password for the alternative CA keystore.").availableIf(HTTPS_CA_KEYSTORE, new String[0]).withRequiredArg().defaultsTo((Object)"password", (Object[])new String[0]);
        optionParser.accepts(HTTPS_CA_KEYSTORE_TYPE, "Type of the alternative CA keystore (jks or pkcs12).").availableIf(HTTPS_CA_KEYSTORE, new String[0]).withRequiredArg().defaultsTo((Object)"jks", (Object[])new String[0]);
        optionParser.accepts(LOAD_RESOURCES_FROM_CLASSPATH, "Specifies path on the classpath for storing recordings (parent for mappings and __files folders)").withRequiredArg();
        optionParser.accepts(LOGGED_RESPONSE_BODY_SIZE_LIMIT, "Maximum size for response bodies stored in the request journal beyond which truncation will be applied").withRequiredArg();
        optionParser.accepts(ALLOW_PROXY_TARGETS, "Comma separated list of IP addresses, IP ranges (hyphenated) and domain name wildcards that can be proxied to/recorded from. Is evaluated before the list of denied addresses.").withRequiredArg();
        optionParser.accepts(DENY_PROXY_TARGETS, "Comma separated list of IP addresses, IP ranges (hyphenated) and domain name wildcards that cannot be proxied to/recorded from. Is evaluated after the list of allowed addresses.").withRequiredArg();
        optionParser.accepts(PROXY_TIMEOUT, "Timeout in milliseconds for requests to proxy").withRequiredArg();
        optionParser.accepts(PROXY_PASS_THROUGH, "Flag to control browser proxy pass through").withRequiredArg();
        optionParser.accepts(HELP, "Print this message").forHelp();
        this.optionSet = optionParser.parse(args);
        this.validate();
        this.captureHelpTextIfRequested(optionParser);
        this.fileSource = this.optionSet.has(LOAD_RESOURCES_FROM_CLASSPATH) ? new ClasspathFileSource((String)this.optionSet.valueOf(LOAD_RESOURCES_FROM_CLASSPATH)) : new SingleRootFileSource((String)this.optionSet.valueOf(ROOT_DIR));
        this.stores = new DefaultStores(this.fileSource);
        if (this.optionSet.has(PROXY_PASS_THROUGH)) {
            GlobalSettings newSettings = this.stores.getSettingsStore().get().copy().proxyPassThrough(Boolean.parseBoolean((String)this.optionSet.valueOf(PROXY_PASS_THROUGH))).build();
            this.stores.getSettingsStore().set(newSettings);
        }
        this.mappingsSource = new JsonFileMappingsSource(this.fileSource.child("mappings"));
        this.extensions = this.buildExtensions();
        this.actualHttpPort = null;
    }

    private Map<String, Extension> buildExtensions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.optionSet.has(EXTENSIONS)) {
            String classNames = (String)this.optionSet.valueOf(EXTENSIONS);
            builder.putAll(ExtensionLoader.load(classNames.split(",")));
        }
        if (this.optionSet.has(GLOBAL_RESPONSE_TEMPLATING)) {
            this.contributeResponseTemplateTransformer((ImmutableMap.Builder<String, Extension>)builder, true);
        } else if (this.optionSet.has(LOCAL_RESPONSE_TEMPLATING)) {
            this.contributeResponseTemplateTransformer((ImmutableMap.Builder<String, Extension>)builder, false);
        }
        return builder.build();
    }

    private void contributeResponseTemplateTransformer(ImmutableMap.Builder<String, Extension> builder, boolean global) {
        ResponseTemplateTransformer transformer = ResponseTemplateTransformer.builder().global(global).maxCacheEntries(this.getMaxTemplateCacheEntries()).permittedSystemKeys(this.getPermittedSystemKeys()).build();
        builder.put((Object)transformer.getName(), (Object)transformer);
    }

    private void validate() {
        if (this.optionSet.has(PORT) && this.optionSet.has(DISABLE_HTTP)) {
            throw new IllegalArgumentException("The HTTP listener can't have a port set and be disabled at the same time");
        }
        if (!this.optionSet.has(HTTPS_PORT) && this.optionSet.has(DISABLE_HTTP)) {
            throw new IllegalArgumentException("HTTPS must be enabled if HTTP is not.");
        }
        if (this.optionSet.has(RECORD_MAPPINGS) && this.optionSet.has(DISABLE_REQUEST_JOURNAL)) {
            throw new IllegalArgumentException("Request journal must be enabled to record stubs");
        }
    }

    private void captureHelpTextIfRequested(OptionParser optionParser) {
        if (this.optionSet.has(HELP)) {
            StringWriter out = new StringWriter();
            try {
                optionParser.printHelpOn((Writer)out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.helpText = out.toString();
        }
    }

    public boolean verboseLoggingEnabled() {
        return this.optionSet.has(VERBOSE);
    }

    public boolean recordMappingsEnabled() {
        return this.optionSet.has(RECORD_MAPPINGS);
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        if (this.optionSet.hasArgument(MATCH_HEADERS)) {
            String headerSpec = (String)this.optionSet.valueOf(MATCH_HEADERS);
            UnmodifiableIterator headerKeys = Iterators.forArray((Object[])headerSpec.split(","));
            return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)headerKeys, CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS));
        }
        return Collections.emptyList();
    }

    @Override
    public HttpServerFactory httpServerFactory() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = loader.loadClass("com.github.tomakehurst.wiremock.jetty.JettyHttpServerFactory");
            return (HttpServerFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return (HttpServerFactory)Exceptions.throwUnchecked(e, null);
        }
    }

    @Override
    public ThreadPoolFactory threadPoolFactory() {
        return new QueuedThreadPoolFactory();
    }

    private boolean specifiesPortNumber() {
        return this.optionSet.has(PORT);
    }

    @Override
    public int portNumber() {
        if (this.specifiesPortNumber()) {
            return Integer.parseInt((String)this.optionSet.valueOf(PORT));
        }
        return 8080;
    }

    @Override
    public boolean getHttpDisabled() {
        return this.optionSet.has(DISABLE_HTTP);
    }

    public void setActualHttpPort(int port) {
        this.actualHttpPort = port;
    }

    public void setActualHttpsPort(int port) {
        this.actualHttpsPort = port;
    }

    @Override
    public String bindAddress() {
        if (this.optionSet.has(BIND_ADDRESS)) {
            return (String)this.optionSet.valueOf(BIND_ADDRESS);
        }
        return "0.0.0.0";
    }

    @Override
    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().port(this.httpsPortNumber()).keyStorePath((String)this.optionSet.valueOf(HTTPS_KEYSTORE)).keyStorePassword((String)this.optionSet.valueOf(HTTPS_KEYSTORE_PASSWORD)).keyStoreType((String)this.optionSet.valueOf(HTTPS_KEYSTORE_TYPE)).keyManagerPassword((String)this.optionSet.valueOf(HTTPS_KEY_MANAGER_PASSWORD)).trustStorePath((String)this.optionSet.valueOf(HTTPS_TRUSTSTORE)).trustStorePassword((String)this.optionSet.valueOf(HTTPS_TRUSTSTORE_PASSWORD)).trustStoreType((String)this.optionSet.valueOf(HTTPS_TRUSTSTORE_TYPE)).needClientAuth(this.optionSet.has(REQUIRE_CLIENT_CERT)).build();
    }

    @Override
    public JettySettings jettySettings() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        if (this.optionSet.hasArgument(JETTY_ACCEPTOR_THREAD_COUNT)) {
            builder = builder.withAcceptors(Integer.parseInt((String)this.optionSet.valueOf(JETTY_ACCEPTOR_THREAD_COUNT)));
        }
        if (this.optionSet.hasArgument(JETTY_ACCEPT_QUEUE_SIZE)) {
            builder = builder.withAcceptQueueSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_ACCEPT_QUEUE_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_HEADER_BUFFER_SIZE)) {
            builder = builder.withRequestHeaderSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_HEADER_BUFFER_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_HEADER_REQUEST_SIZE)) {
            builder = builder.withRequestHeaderSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_HEADER_REQUEST_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_HEADER_RESPONSE_SIZE)) {
            builder = builder.withResponseHeaderSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_HEADER_RESPONSE_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_STOP_TIMEOUT)) {
            builder = builder.withStopTimeout(Long.parseLong((String)this.optionSet.valueOf(JETTY_STOP_TIMEOUT)));
        }
        if (this.optionSet.hasArgument(JETTY_IDLE_TIMEOUT)) {
            builder = builder.withIdleTimeout(Long.parseLong((String)this.optionSet.valueOf(JETTY_IDLE_TIMEOUT)));
        }
        return builder.build();
    }

    private int httpsPortNumber() {
        return this.optionSet.has(HTTPS_PORT) ? Integer.parseInt((String)this.optionSet.valueOf(HTTPS_PORT)) : -1;
    }

    public boolean help() {
        return this.optionSet.has(HELP);
    }

    public String helpText() {
        return this.helpText;
    }

    public boolean specifiesProxyUrl() {
        return this.optionSet.has(PROXY_ALL);
    }

    public String proxyUrl() {
        return (String)this.optionSet.valueOf(PROXY_ALL);
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.optionSet.has(PRESERVE_HOST_HEADER);
    }

    @Override
    public String proxyHostHeader() {
        return this.optionSet.hasArgument(PROXY_ALL) ? URI.create((String)this.optionSet.valueOf(PROXY_ALL)).getAuthority() : null;
    }

    @Override
    public <T extends Extension> Map<String, T> extensionsOfType(Class<T> extensionType) {
        return Maps.filterEntries(this.extensions, ExtensionLoader.valueAssignableFrom(extensionType));
    }

    @Override
    public WiremockNetworkTrafficListener networkTrafficListener() {
        if (this.optionSet.has(PRINT_ALL_NETWORK_TRAFFIC)) {
            return new ConsoleNotifyingWiremockNetworkTrafficListener();
        }
        return new DoNothingWiremockNetworkTrafficListener();
    }

    @Override
    public Authenticator getAdminAuthenticator() {
        if (this.optionSet.has(ADMIN_API_BASIC_AUTH)) {
            String[] parts = ((String)this.optionSet.valueOf(ADMIN_API_BASIC_AUTH)).split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Admin API credentials must be in the format username:password");
            }
            return new BasicAuthenticator(parts[0], parts[1]);
        }
        return new NoAuthenticator();
    }

    @Override
    public boolean getHttpsRequiredForAdminApi() {
        return this.optionSet.has(ADMIN_API_REQUIRE_HTTPS);
    }

    @Override
    public NotMatchedRenderer getNotMatchedRenderer() {
        return new PlainTextStubNotMatchedRenderer();
    }

    @Override
    @Deprecated
    public boolean browserProxyingEnabled() {
        return this.browserProxySettings().enabled();
    }

    @Override
    public ProxySettings proxyVia() {
        if (this.optionSet.has(PROXY_VIA)) {
            String proxyVia = (String)this.optionSet.valueOf(PROXY_VIA);
            return ProxySettings.fromString(proxyVia);
        }
        return ProxySettings.NO_PROXY;
    }

    @Override
    public Stores getStores() {
        return this.stores;
    }

    @Override
    public FileSource filesRoot() {
        return this.fileSource;
    }

    @Override
    public MappingsLoader mappingsLoader() {
        return this.mappingsSource;
    }

    @Override
    public MappingsSaver mappingsSaver() {
        return this.mappingsSource;
    }

    @Override
    public Notifier notifier() {
        return new ConsoleNotifier(this.verboseLoggingEnabled());
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.optionSet.has(DISABLE_REQUEST_JOURNAL);
    }

    public boolean bannerDisabled() {
        return this.optionSet.has(DISABLE_BANNER);
    }

    private boolean specifiesMaxRequestJournalEntries() {
        return this.optionSet.has(MAX_ENTRIES_REQUEST_JOURNAL);
    }

    @Override
    public Optional<Integer> maxRequestJournalEntries() {
        if (this.specifiesMaxRequestJournalEntries()) {
            return Optional.of((Object)Integer.parseInt((String)this.optionSet.valueOf(MAX_ENTRIES_REQUEST_JOURNAL)));
        }
        return Optional.absent();
    }

    @Override
    public int containerThreads() {
        if (this.optionSet.has(CONTAINER_THREADS)) {
            return Integer.parseInt((String)this.optionSet.valueOf(CONTAINER_THREADS));
        }
        return 25;
    }

    public String toString() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.actualHttpPort != null) {
            builder.put((Object)PORT, (Object)this.actualHttpPort);
        }
        if (this.actualHttpsPort != null) {
            builder.put((Object)HTTPS_PORT, (Object)this.actualHttpsPort);
        }
        if (this.httpsSettings().enabled()) {
            builder.put((Object)HTTPS_KEYSTORE, (Object)this.nullToString(this.httpsSettings().keyStorePath()));
        }
        if (this.proxyVia() != ProxySettings.NO_PROXY) {
            builder.put((Object)PROXY_VIA, (Object)this.proxyVia());
        }
        if (this.proxyUrl() != null) {
            builder.put((Object)PROXY_ALL, (Object)this.nullToString(this.proxyUrl())).put((Object)PRESERVE_HOST_HEADER, (Object)this.shouldPreserveHostHeader());
        }
        BrowserProxySettings browserProxySettings = this.browserProxySettings();
        builder.put((Object)ENABLE_BROWSER_PROXYING, (Object)browserProxySettings.enabled());
        if (browserProxySettings.enabled()) {
            KeyStoreSettings keyStoreSettings = browserProxySettings.caKeyStore();
            builder.put((Object)TRUST_ALL_PROXY_TARGETS, (Object)browserProxySettings.trustAllProxyTargets());
            List<String> trustedProxyTargets = browserProxySettings.trustedProxyTargets();
            if (!trustedProxyTargets.isEmpty()) {
                builder.put((Object)TRUST_PROXY_TARGET, (Object)Joiner.on((String)", ").join(trustedProxyTargets));
            }
            builder.put((Object)HTTPS_CA_KEYSTORE, (Object)keyStoreSettings.path());
            builder.put((Object)HTTPS_CA_KEYSTORE_TYPE, (Object)keyStoreSettings.type());
        }
        builder.put((Object)DISABLE_BANNER, (Object)this.bannerDisabled());
        if (this.recordMappingsEnabled()) {
            builder.put((Object)RECORD_MAPPINGS, (Object)this.recordMappingsEnabled()).put((Object)MATCH_HEADERS, this.matchingHeaders());
        }
        builder.put((Object)DISABLE_REQUEST_JOURNAL, (Object)this.requestJournalDisabled()).put((Object)VERBOSE, (Object)this.verboseLoggingEnabled());
        if (this.jettySettings().getAcceptQueueSize().isPresent()) {
            builder.put((Object)JETTY_ACCEPT_QUEUE_SIZE, this.jettySettings().getAcceptQueueSize().get());
        }
        if (this.jettySettings().getAcceptors().isPresent()) {
            builder.put((Object)JETTY_ACCEPTOR_THREAD_COUNT, this.jettySettings().getAcceptors().get());
        }
        if (this.jettySettings().getRequestHeaderSize().isPresent()) {
            builder.put((Object)JETTY_HEADER_BUFFER_SIZE, this.jettySettings().getRequestHeaderSize().get());
        }
        if (!(this.getAdminAuthenticator() instanceof NoAuthenticator)) {
            builder.put((Object)ADMIN_API_BASIC_AUTH, (Object)"enabled");
        }
        if (this.getHttpsRequiredForAdminApi()) {
            builder.put((Object)ADMIN_API_REQUIRE_HTTPS, (Object)"true");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : builder.build().entrySet()) {
            int paddingLength = 29 - ((String)param.getKey()).length();
            sb.append((String)param.getKey()).append(":").append(Strings.repeat((String)" ", (int)paddingLength)).append(this.nullToString(param.getValue())).append("\n");
        }
        return sb.toString();
    }

    private String nullToString(Object value) {
        if (value == null) {
            return "(null)";
        }
        return value.toString();
    }

    @Override
    public AsynchronousResponseSettings getAsynchronousResponseSettings() {
        return new AsynchronousResponseSettings(this.isAsynchronousResponseEnabled(), this.getAsynchronousResponseThreads());
    }

    @Override
    public Options.ChunkedEncodingPolicy getChunkedEncodingPolicy() {
        return this.optionSet.has(USE_CHUNKED_ENCODING) ? Options.ChunkedEncodingPolicy.valueOf(this.optionSet.valueOf(USE_CHUNKED_ENCODING).toString().toUpperCase()) : Options.ChunkedEncodingPolicy.ALWAYS;
    }

    @Override
    public boolean getGzipDisabled() {
        return this.optionSet.has(DISABLE_GZIP);
    }

    @Override
    public boolean getStubRequestLoggingDisabled() {
        return this.optionSet.has(DISABLE_REQUEST_LOGGING);
    }

    @Override
    public boolean getStubCorsEnabled() {
        return this.optionSet.has(ENABLE_STUB_CORS);
    }

    @Override
    public long timeout() {
        return this.optionSet.has(TIMEOUT) ? Long.parseLong((String)this.optionSet.valueOf(TIMEOUT)) : 300000L;
    }

    @Override
    public boolean getDisableOptimizeXmlFactoriesLoading() {
        return this.optionSet.has(DISABLE_OPTIMIZE_XML_FACTORIES_LOADING);
    }

    @Override
    public boolean getDisableStrictHttpHeaders() {
        return this.optionSet.has(DISABLE_STRICT_HTTP_HEADERS);
    }

    @Override
    public DataTruncationSettings getDataTruncationSettings() {
        return this.optionSet.has(LOGGED_RESPONSE_BODY_SIZE_LIMIT) ? new DataTruncationSettings(new Limit(Integer.parseInt((String)this.optionSet.valueOf(LOGGED_RESPONSE_BODY_SIZE_LIMIT)))) : DataTruncationSettings.DEFAULTS;
    }

    @Override
    public NetworkAddressRules getProxyTargetRules() {
        NetworkAddressRules.Builder builder = NetworkAddressRules.builder();
        if (this.optionSet.has(ALLOW_PROXY_TARGETS)) {
            Arrays.stream(((String)this.optionSet.valueOf(ALLOW_PROXY_TARGETS)).split(",")).forEach(builder::allow);
        }
        if (this.optionSet.has(DENY_PROXY_TARGETS)) {
            Arrays.stream(((String)this.optionSet.valueOf(DENY_PROXY_TARGETS)).split(",")).forEach(builder::deny);
        }
        return builder.build();
    }

    @Override
    public BrowserProxySettings browserProxySettings() {
        KeyStoreSettings keyStoreSettings = new KeyStoreSettings(KeyStoreSourceFactory.getAppropriateForJreVersion((String)this.optionSet.valueOf(HTTPS_CA_KEYSTORE), (String)this.optionSet.valueOf(HTTPS_CA_KEYSTORE_TYPE), ((String)this.optionSet.valueOf(HTTPS_CA_KEYSTORE_PASSWORD)).toCharArray()));
        return new BrowserProxySettings.Builder().enabled(this.optionSet.has(ENABLE_BROWSER_PROXYING)).trustAllProxyTargets(this.optionSet.has(TRUST_ALL_PROXY_TARGETS)).trustedProxyTargets(this.optionSet.valuesOf(TRUST_PROXY_TARGET)).caKeyStoreSettings(keyStoreSettings).build();
    }

    @Override
    public int proxyTimeout() {
        return this.optionSet.has(PROXY_TIMEOUT) ? Integer.valueOf((String)this.optionSet.valueOf(PROXY_TIMEOUT)) : 300000;
    }

    private Long getMaxTemplateCacheEntries() {
        return this.optionSet.has(MAX_TEMPLATE_CACHE_ENTRIES) ? Long.valueOf(this.optionSet.valueOf(MAX_TEMPLATE_CACHE_ENTRIES).toString()) : null;
    }

    @VisibleForTesting
    public Set<String> getPermittedSystemKeys() {
        return this.optionSet.has(PERMITTED_SYSTEM_KEYS) ? ImmutableSet.copyOf((Collection)this.optionSet.valuesOf(PERMITTED_SYSTEM_KEYS)) : Collections.emptySet();
    }

    private boolean isAsynchronousResponseEnabled() {
        return this.optionSet.has(ASYNCHRONOUS_RESPONSE_ENABLED) ? Boolean.valueOf((String)this.optionSet.valueOf(ASYNCHRONOUS_RESPONSE_ENABLED)) : false;
    }

    private int getAsynchronousResponseThreads() {
        return Integer.valueOf((String)this.optionSet.valueOf(ASYNCHRONOUS_RESPONSE_THREADS));
    }
}

