/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.matching.ExactMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.IncludesMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import java.io.IOException;

public class MultiValuePatternDeserializer
extends JsonDeserializer<MultiValuePattern> {
    public MultiValuePattern deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        if (rootNode.has("hasExactly")) {
            return (MultiValuePattern)mapper.treeToValue((TreeNode)rootNode, ExactMatchMultiValuePattern.class);
        }
        if (rootNode.has("includes")) {
            return (MultiValuePattern)mapper.treeToValue((TreeNode)rootNode, IncludesMatchMultiValuePattern.class);
        }
        return (MultiValuePattern)mapper.treeToValue((TreeNode)rootNode, SingleMatchMultiValuePattern.class);
    }
}

