/**
 * Logback: the reliable, generic, fast and flexible logging framework. Copyright (C) 1999-2015, QOS.ch. All rights
 * reserved.
 *
 * This program and the accompanying materials are dual-licensed under either the terms of the Eclipse Public License
 * v1.0 as published by the Eclipse Foundation
 *
 * or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1 as published by the Free Software Foundation.
 */
package org.apache.juli.logging.ch.qos.logback.core.joran.action;

import org.apache.juli.logging.ch.qos.logback.core.joran.util.PropertySetter;
import org.apache.juli.logging.ch.qos.logback.core.util.AggregationType;

/**
 * Lump together several fields for use by {@link org.apache.juli.logging.ch.qos.logback.core.model.processor.ImplicitModelHandler ImplicitModelHandler}.
 *
 * @author Ceki
 */
public class ImplicitModelDataForComplexProperty extends ImplicitModelData {

    private Object nestedComplexProperty;

    public ImplicitModelDataForComplexProperty(PropertySetter parentBean, AggregationType aggregationType,
            String propertyName) {
        super(parentBean, aggregationType, propertyName);
    }

    public Object getNestedComplexProperty() {
        return nestedComplexProperty;
    }

    public void setNestedComplexProperty(Object nestedComplexProperty) {
        this.nestedComplexProperty = nestedComplexProperty;
    }

}
