package org.apache.juli.logging.ch.qos.logback.core.model.processor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.joran.action.ActionUtil;
import org.apache.juli.logging.ch.qos.logback.core.joran.action.ActionUtil.Scope;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.ModelConstants;
import org.apache.juli.logging.ch.qos.logback.core.model.PropertyModel;
import org.apache.juli.logging.ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import org.apache.juli.logging.ch.qos.logback.core.util.Loader;

public class PropertyModelHandler extends ModelHandlerBase {

    public PropertyModelHandler(Context context) {
        super(context);
    }

    static public ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new PropertyModelHandler(context);
    }

    @Override
    protected Class<PropertyModel> getSupportedModelClass() {
        return PropertyModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) {

        PropertyModel propertyModel = (PropertyModel) model;
        PropertyModelHandlerHelper propertyModelHandlerHelper = new PropertyModelHandlerHelper(this);
        propertyModelHandlerHelper.setContext(context);
        propertyModelHandlerHelper.handlePropertyModel(mic, propertyModel);
    }

}
