/*
 * Copyright 2013-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.juli.logging.net.logstash.logback.decorate.cbor;

import org.apache.juli.logging.net.logstash.logback.decorate.JsonFactoryDecorator;

import org.apache.juli.logging.com.fasterxml.jackson.core.JsonFactory;
import org.apache.juli.logging.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.juli.logging.com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import org.apache.juli.logging.com.fasterxml.jackson.dataformat.cbor.CBORGenerator;

/**
 * A {@link JsonFactoryDecorator} that will switch the output
 * to binary CBOR output instead of JSON text.
 *
 * <p>See also {@link CborFeatureJsonGeneratorDecorator} for configuring {@link CBORGenerator} features.</p>
 */
public class CborJsonFactoryDecorator implements JsonFactoryDecorator {

    @Override
    public JsonFactory decorate(JsonFactory factory) {
        CBORFactory cborFactory = new CBORFactory();
        ObjectMapper mapper = new ObjectMapper(cborFactory);
        cborFactory.setCodec(mapper);
        return cborFactory;
    }
}
