/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.ch.qos.logback.classic.html;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.juli.logging.ch.qos.logback.classic.PatternLayout;
import org.apache.juli.logging.ch.qos.logback.classic.html.DefaultCssBuilder;
import org.apache.juli.logging.ch.qos.logback.classic.html.DefaultThrowableRenderer;
import org.apache.juli.logging.ch.qos.logback.classic.pattern.MDCConverter;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.core.CoreConstants;
import org.apache.juli.logging.ch.qos.logback.core.helpers.Transform;
import org.apache.juli.logging.ch.qos.logback.core.html.HTMLLayoutBase;
import org.apache.juli.logging.ch.qos.logback.core.html.IThrowableRenderer;
import org.apache.juli.logging.ch.qos.logback.core.pattern.Converter;
import org.apache.juli.logging.ch.qos.logback.core.pattern.DynamicConverter;

public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    @Override
    public void start() {
        int errorCount = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    @Override
    protected Map<String, Supplier<DynamicConverter>> getDefaultConverterSupplierMap() {
        return PatternLayout.DEFAULT_CONVERTER_SUPPLIER_MAP;
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        StringBuilder buf = new StringBuilder();
        this.startNewTableIfLimitReached(buf);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        buf.append(CoreConstants.LINE_SEPARATOR);
        buf.append("<tr class=\"");
        buf.append(level);
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            this.appendEventToBuffer(buf, c, event);
        }
        buf.append("</tr>");
        buf.append(CoreConstants.LINE_SEPARATOR);
        if (event.getThrowableProxy() != null) {
            this.throwableRenderer.render(buf, event);
        }
        return buf.toString();
    }

    private void appendEventToBuffer(StringBuilder buf, Converter<ILoggingEvent> c, ILoggingEvent event) {
        buf.append("<td class=\"");
        buf.append(this.computeConverterName(c));
        buf.append("\">");
        buf.append(Transform.escapeTags(c.convert(event)));
        buf.append("</td>");
        buf.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer<ILoggingEvent> getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> throwableRenderer) {
        this.throwableRenderer = throwableRenderer;
    }

    @Override
    protected String computeConverterName(Converter<ILoggingEvent> c) {
        if (c instanceof MDCConverter) {
            MDCConverter mc = (MDCConverter)c;
            String key = mc.getFirstOption();
            if (key != null) {
                return key;
            }
            return "MDC";
        }
        return super.computeConverterName(c);
    }
}

