/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.ch.qos.logback.classic.model.processor;

import java.io.InputStream;
import java.net.URL;
import org.apache.juli.logging.ch.qos.logback.classic.joran.PropertiesConfigurator;
import org.apache.juli.logging.ch.qos.logback.classic.model.PropertiesConfiguratorModel;
import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.JoranException;
import org.apache.juli.logging.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.ResourceModel;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerException;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ResourceHandlerBase;
import org.apache.juli.logging.ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import org.apache.juli.logging.ch.qos.logback.core.util.OptionHelper;

public class PropertiesConfiguratorModelHandler
extends ResourceHandlerBase {
    boolean inError = false;
    static final boolean CREATE_CWL_IF_NOT_ALREADY_CREATED = true;

    public PropertiesConfiguratorModelHandler(Context context) {
        super(context);
    }

    public static PropertiesConfiguratorModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        return new PropertiesConfiguratorModelHandler(context);
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.detachedHandle(mic, model);
    }

    public void detachedHandle(ContextAwarePropertyContainer capc, Model model) throws ModelHandlerException {
        PropertiesConfiguratorModel propertyConfiguratorModel = (PropertiesConfiguratorModel)model;
        this.optional = OptionHelper.toBoolean(propertyConfiguratorModel.getOptional(), false);
        if (!this.checkAttributes(propertyConfiguratorModel)) {
            this.inError = true;
            return;
        }
        InputStream in = this.getInputStream(capc, propertyConfiguratorModel);
        if (in == null) {
            this.inError = true;
            return;
        }
        this.addInfo("Reading configuration from [" + this.getAttribureInUse() + "]");
        PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator();
        propertiesConfigurator.setContext(capc.getContext());
        try {
            propertiesConfigurator.doConfigure(in);
        }
        catch (JoranException e) {
            this.addError("Could not configure from " + this.getAttribureInUse());
            throw new ModelHandlerException(e);
        }
    }

    protected InputStream getInputStream(ContextAwarePropertyContainer capc, ResourceModel resourceModel) {
        URL inputURL = this.getInputURL(capc, resourceModel);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL, true);
        return this.openURL(inputURL);
    }
}

