/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.ch.qos.logback.core.model.processor;

import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.model.AppenderRefModel;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.DependencyDefinition;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerBase;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerException;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.PhaseIndicator;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ProcessingPhase;

@PhaseIndicator(phase=ProcessingPhase.DEPENDENCY_ANALYSIS)
public class AppenderRefDependencyAnalyser
extends ModelHandlerBase {
    public AppenderRefDependencyAnalyser(Context context) {
        super(context);
    }

    protected Class<AppenderRefModel> getSupportedModelClass() {
        return AppenderRefModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        Model depender;
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        String ref = mic.subst(appenderRefModel.getRef());
        if (mic.isModelStackEmpty()) {
            depender = appenderRefModel;
        } else {
            Model parentModel = mic.peekModel();
            depender = parentModel;
        }
        DependencyDefinition dd = new DependencyDefinition(depender, ref);
        mic.addDependencyDefinition(dd);
    }
}

