/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback;

import java.util.Collections;
import java.util.List;
import org.apache.juli.logging.ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.core.spi.ContextAware;
import org.apache.juli.logging.com.fasterxml.jackson.databind.JsonNode;
import org.apache.juli.logging.net.logstash.logback.composite.ContextJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.FieldNamesAware;
import org.apache.juli.logging.net.logstash.logback.composite.GlobalCustomFieldsJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProviders;
import org.apache.juli.logging.net.logstash.logback.composite.LogstashVersionJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.ArgumentsJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.CallerDataJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.KeyValuePairsJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LogLevelJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LogLevelValueJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LoggerNameJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LoggingEventCompositeJsonFormatter;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LoggingEventFormattedTimestampJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LoggingEventJsonProviders;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LoggingEventThreadNameJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.MdcJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.MessageJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.StackTraceJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.TagsJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.mdc.MdcEntryWriter;
import org.apache.juli.logging.net.logstash.logback.fieldnames.LogstashFieldNames;

public class LogstashFormatter
extends LoggingEventCompositeJsonFormatter {
    protected LogstashFieldNames fieldNames;
    private final LoggingEventFormattedTimestampJsonProvider timestampProvider = new LoggingEventFormattedTimestampJsonProvider();
    private final LogstashVersionJsonProvider<ILoggingEvent> versionProvider = new LogstashVersionJsonProvider();
    private final MessageJsonProvider messageProvider = new MessageJsonProvider();
    private final LoggerNameJsonProvider loggerNameProvider = new LoggerNameJsonProvider();
    private final LoggingEventThreadNameJsonProvider threadNameProvider = new LoggingEventThreadNameJsonProvider();
    private final LogLevelJsonProvider logLevelProvider = new LogLevelJsonProvider();
    private final LogLevelValueJsonProvider logLevelValueProvider = new LogLevelValueJsonProvider();
    private CallerDataJsonProvider callerDataProvider;
    private final StackTraceJsonProvider stackTraceProvider = new StackTraceJsonProvider();
    private ContextJsonProvider<ILoggingEvent> contextProvider = new ContextJsonProvider();
    private MdcJsonProvider mdcProvider = new MdcJsonProvider();
    private KeyValuePairsJsonProvider keyValuePairsProvider = new KeyValuePairsJsonProvider();
    private GlobalCustomFieldsJsonProvider<ILoggingEvent> globalCustomFieldsProvider;
    private TagsJsonProvider tagsProvider = new TagsJsonProvider();
    private final LogstashMarkersJsonProvider logstashMarkersProvider = new LogstashMarkersJsonProvider();
    private ArgumentsJsonProvider argumentsProvider = new ArgumentsJsonProvider();

    public LogstashFormatter(ContextAware declaredOrigin) {
        this(declaredOrigin, false);
    }

    public LogstashFormatter(ContextAware declaredOrigin, boolean includeCallerData) {
        this(declaredOrigin, includeCallerData, null);
    }

    public LogstashFormatter(ContextAware declaredOrigin, boolean includeCallerData, JsonNode customFields) {
        super(declaredOrigin);
        this.fieldNames = new LogstashFieldNames();
        this.setIncludeCallerData(includeCallerData);
        this.setCustomFields(customFields);
        this.getProviders().addTimestamp(this.timestampProvider);
        this.getProviders().addVersion(this.versionProvider);
        this.getProviders().addMessage(this.messageProvider);
        this.getProviders().addLoggerName(this.loggerNameProvider);
        this.getProviders().addThreadName(this.threadNameProvider);
        this.getProviders().addLogLevel(this.logLevelProvider);
        this.getProviders().addLogLevelValue(this.logLevelValueProvider);
        this.getProviders().addCallerData(this.callerDataProvider);
        this.getProviders().addStackTrace(this.stackTraceProvider);
        this.getProviders().addContext(this.contextProvider);
        this.getProviders().addMdc(this.mdcProvider);
        this.getProviders().addKeyValuePairs(this.keyValuePairsProvider);
        this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
        this.getProviders().addTags(this.tagsProvider);
        this.getProviders().addLogstashMarkers(this.logstashMarkersProvider);
        this.getProviders().addArguments(this.argumentsProvider);
    }

    @Override
    public void start() {
        this.configureProviderFieldNames();
        super.start();
    }

    protected void configureProviderFieldNames() {
        for (JsonProvider provider : this.getProviders().getProviders()) {
            if (!(provider instanceof FieldNamesAware)) continue;
            ((FieldNamesAware)((Object)provider)).setFieldNames(this.fieldNames);
        }
    }

    public boolean isIncludeCallerData() {
        return this.callerDataProvider != null;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        if (this.isIncludeCallerData() != includeCallerData) {
            this.getProviders().removeProvider(this.callerDataProvider);
            if (includeCallerData) {
                this.callerDataProvider = new CallerDataJsonProvider();
                this.getProviders().addCallerData(this.callerDataProvider);
            } else {
                this.callerDataProvider = null;
            }
        }
    }

    public String getCustomFieldsAsString() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFields();
    }

    public void setCustomFieldsFromString(String customFields) {
        if (customFields == null || customFields.length() == 0) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFields(customFields);
        }
    }

    public void setCustomFields(JsonNode customFields) {
        if (customFields == null) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFieldsNode(customFields);
        }
    }

    public JsonNode getCustomFields() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFieldsNode();
    }

    public int getShortenedLoggerNameLength() {
        return this.loggerNameProvider.getShortenedLoggerNameLength();
    }

    public void setShortenedLoggerNameLength(int length) {
        this.loggerNameProvider.setShortenedLoggerNameLength(length);
    }

    public boolean isIncludeMdc() {
        return this.mdcProvider != null;
    }

    public void setIncludeMdc(boolean includeMdc) {
        if (this.isIncludeMdc() != includeMdc) {
            if (includeMdc) {
                this.mdcProvider = new MdcJsonProvider();
                this.addProvider(this.mdcProvider);
            } else {
                this.getProviders().removeProvider(this.mdcProvider);
                this.mdcProvider = null;
            }
        }
    }

    public boolean isIncludeKeyValuePairs() {
        return this.keyValuePairsProvider != null;
    }

    public void setIncludeKeyValuePairs(boolean includeKeyValuePairs) {
        if (this.isIncludeKeyValuePairs() != includeKeyValuePairs) {
            if (includeKeyValuePairs) {
                this.keyValuePairsProvider = new KeyValuePairsJsonProvider();
                this.addProvider(this.keyValuePairsProvider);
            } else {
                this.getProviders().removeProvider(this.keyValuePairsProvider);
                this.keyValuePairsProvider = null;
            }
        }
    }

    public boolean isIncludeTags() {
        return this.tagsProvider != null;
    }

    public void setIncludeTags(boolean includeTags) {
        if (this.isIncludeTags() != includeTags) {
            if (includeTags) {
                this.tagsProvider = new TagsJsonProvider();
                this.addProvider(this.tagsProvider);
            } else {
                this.getProviders().removeProvider(this.tagsProvider);
                this.tagsProvider = null;
            }
        }
    }

    public boolean isIncludeStructuredArguments() {
        return this.argumentsProvider.isIncludeStructuredArguments();
    }

    public void setIncludeStructuredArguments(boolean includeStructuredArguments) {
        this.argumentsProvider.setIncludeStructuredArguments(includeStructuredArguments);
    }

    public boolean isIncludeNonStructuredArguments() {
        return this.argumentsProvider.isIncludeNonStructuredArguments();
    }

    public void setIncludeNonStructuredArguments(boolean includeNonStructuredArguments) {
        this.argumentsProvider.setIncludeNonStructuredArguments(includeNonStructuredArguments);
    }

    public String getNonStructuredArgumentsFieldPrefix() {
        return this.argumentsProvider.getNonStructuredArgumentsFieldPrefix();
    }

    public void setNonStructuredArgumentsFieldPrefix(String nonStructuredArgumentsFieldPrefix) {
        this.argumentsProvider.setNonStructuredArgumentsFieldPrefix(nonStructuredArgumentsFieldPrefix);
    }

    public List<String> getIncludeMdcKeyNames() {
        return this.isIncludeMdc() ? this.mdcProvider.getIncludeMdcKeyNames() : Collections.emptyList();
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addIncludeMdcKeyName(includedMdcKeyName);
        }
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.setIncludeMdcKeyNames(includeMdcKeyNames);
        }
    }

    public List<String> getExcludeMdcKeyNames() {
        return this.isIncludeMdc() ? this.mdcProvider.getExcludeMdcKeyNames() : Collections.emptyList();
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addExcludeMdcKeyName(excludedMdcKeyName);
        }
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.setExcludeMdcKeyNames(excludeMdcKeyNames);
        }
    }

    public void addMdcKeyFieldName(String mdcKeyFieldName) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addMdcKeyFieldName(mdcKeyFieldName);
        }
    }

    public List<MdcEntryWriter> getMdcEntryWriters() {
        return this.isIncludeMdc() ? this.mdcProvider.getMdcEntryWriters() : Collections.emptyList();
    }

    public void addMdcEntryWriter(MdcEntryWriter mdcEntryWriter) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addMdcEntryWriter(mdcEntryWriter);
        }
    }

    public List<String> getIncludeKeyValueKeyNames() {
        return this.isIncludeKeyValuePairs() ? this.keyValuePairsProvider.getIncludeKeyNames() : Collections.emptyList();
    }

    public void addIncludeKeyValueKeyName(String includedKeyValueKeyName) {
        if (this.isIncludeKeyValuePairs()) {
            this.keyValuePairsProvider.addIncludeKeyName(includedKeyValueKeyName);
        }
    }

    public void setIncludeKeyValueKeyNames(List<String> includeKeyValueKeyNames) {
        if (this.isIncludeKeyValuePairs()) {
            this.keyValuePairsProvider.setIncludeKeyNames(includeKeyValueKeyNames);
        }
    }

    public List<String> getExcludeKeyValueKeyNames() {
        return this.isIncludeKeyValuePairs() ? this.keyValuePairsProvider.getExcludeKeyNames() : Collections.emptyList();
    }

    public void addExcludeKeyValueKeyName(String excludedKeyValueKeyName) {
        if (this.isIncludeKeyValuePairs()) {
            this.keyValuePairsProvider.addExcludeKeyName(excludedKeyValueKeyName);
        }
    }

    public void setExcludeKeyValueKeyNames(List<String> excludeKeyValueKeyNames) {
        if (this.isIncludeKeyValuePairs()) {
            this.keyValuePairsProvider.setExcludeKeyNames(excludeKeyValueKeyNames);
        }
    }

    public void addKeyValueKeyFieldName(String keyValueKeyFieldName) {
        if (this.isIncludeKeyValuePairs()) {
            this.keyValuePairsProvider.addKeyFieldName(keyValueKeyFieldName);
        }
    }

    public boolean isIncludeContext() {
        return this.contextProvider != null;
    }

    public void setIncludeContext(boolean includeContext) {
        if (this.isIncludeContext() != includeContext) {
            this.getProviders().removeProvider(this.contextProvider);
            if (includeContext) {
                this.contextProvider = new ContextJsonProvider();
                this.getProviders().addContext(this.contextProvider);
            } else {
                this.contextProvider = null;
            }
        }
    }

    public ThrowableHandlingConverter getThrowableConverter() {
        return this.stackTraceProvider.getThrowableConverter();
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.stackTraceProvider.setThrowableConverter(throwableConverter);
    }

    public String getVersion() {
        return this.versionProvider.getVersion();
    }

    public void setVersion(String version) {
        this.versionProvider.setVersion(version);
    }

    public boolean isWriteVersionAsInteger() {
        return this.versionProvider.isWriteAsInteger();
    }

    public void setWriteVersionAsInteger(boolean writeVersionAsInteger) {
        this.versionProvider.setWriteAsInteger(writeVersionAsInteger);
    }

    public String getMessageSplitRegex() {
        return this.messageProvider.getMessageSplitRegex();
    }

    public void setMessageSplitRegex(String messageSplitRegex) {
        this.messageProvider.setMessageSplitRegex(messageSplitRegex);
    }

    public void addProvider(JsonProvider<ILoggingEvent> provider) {
        if (provider instanceof ArgumentsJsonProvider) {
            this.getProviders().removeProvider(this.argumentsProvider);
            this.argumentsProvider = (ArgumentsJsonProvider)provider;
        } else if (provider instanceof MdcJsonProvider) {
            this.getProviders().removeProvider(this.mdcProvider);
            this.mdcProvider = (MdcJsonProvider)provider;
        } else if (provider instanceof KeyValuePairsJsonProvider) {
            this.getProviders().removeProvider(this.keyValuePairsProvider);
            this.keyValuePairsProvider = (KeyValuePairsJsonProvider)provider;
        }
        this.getProviders().addProvider(provider);
    }

    public LoggingEventJsonProviders getProviders() {
        return (LoggingEventJsonProviders)super.getProviders();
    }

    public LogstashFieldNames getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getTimeZone() {
        return this.timestampProvider.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.timestampProvider.setTimeZone(timeZoneId);
    }

    public String getTimestampPattern() {
        return this.timestampProvider.getPattern();
    }

    public void setTimestampPattern(String pattern) {
        this.timestampProvider.setPattern(pattern);
    }

    @Override
    public void setProviders(JsonProviders<ILoggingEvent> jsonProviders) {
        if (super.getProviders() != null && !super.getProviders().getProviders().isEmpty()) {
            this.addError("Unable to set providers when using predefined composites.");
        } else {
            super.setProviders(jsonProviders);
        }
    }
}

