/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.appender;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.juli.logging.ch.qos.logback.core.Layout;
import org.apache.juli.logging.ch.qos.logback.core.net.SyslogAppenderBase;
import org.apache.juli.logging.ch.qos.logback.core.net.SyslogOutputStream;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.net.logstash.logback.appender.listener.AppenderListener;

public class AbstractLogstashUdpSocketAppender<Event extends DeferredProcessingAware>
extends SyslogAppenderBase<Event> {
    private Layout<Event> layout;
    private final List<AppenderListener<Event>> listeners = new ArrayList<AppenderListener<Event>>();
    private SyslogOutputStream syslogOutputStream;

    public AbstractLogstashUdpSocketAppender() {
        this.setFacility("NEWS");
    }

    @Override
    public void start() {
        if (this.layout == null) {
            this.addError("No layout was configured. Use <layout> to specify the fully qualified class name of the layout to use");
            return;
        }
        super.start();
        if (this.isStarted()) {
            this.getLayout().start();
            this.fireAppenderStarted();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.getLayout().stop();
        this.fireAppenderStopped();
    }

    @Override
    public Layout<Event> buildLayout() {
        this.layout.setContext(this.getContext());
        return this.layout;
    }

    @Override
    protected void append(Event eventObject) {
        if (!this.isStarted()) {
            return;
        }
        long startTime = System.nanoTime();
        try {
            String msg = this.getLayout().doLayout(eventObject);
            if (msg == null) {
                return;
            }
            if (msg.length() > this.getMaxMessageSize()) {
                msg = msg.substring(0, this.getMaxMessageSize());
            }
            this.syslogOutputStream.write(msg.getBytes(this.getCharset()));
            this.syslogOutputStream.flush();
            this.postProcess(eventObject, this.syslogOutputStream);
            this.fireEventAppended(eventObject, System.nanoTime() - startTime);
        }
        catch (IOException ioe) {
            this.addError("Failed to send diagram to " + this.getSyslogHost(), ioe);
            this.fireEventAppendFailed(eventObject, ioe);
        }
    }

    protected void fireAppenderStarted() {
        for (AppenderListener<Event> listener : this.listeners) {
            listener.appenderStarted(this);
        }
    }

    protected void fireAppenderStopped() {
        for (AppenderListener<Event> listener : this.listeners) {
            listener.appenderStopped(this);
        }
    }

    protected void fireEventAppended(Event event, long durationInNanos) {
        for (AppenderListener<Event> listener : this.listeners) {
            listener.eventAppended(this, event, durationInNanos);
        }
    }

    protected void fireEventAppendFailed(Event event, Throwable reason) {
        for (AppenderListener<Event> listener : this.listeners) {
            listener.eventAppendFailed(this, event, reason);
        }
    }

    @Override
    public int getSeverityForEvent(Object eventObject) {
        return 0;
    }

    public String getHost() {
        return this.getSyslogHost();
    }

    public void setHost(String host) {
        this.setSyslogHost(host);
    }

    @Override
    public Layout<Event> getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(Layout<Event> layout) {
        this.layout = Objects.requireNonNull(layout, "layout must not be null");
    }

    public void addListener(AppenderListener<Event> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AppenderListener<Event> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SyslogOutputStream createOutputStream() throws UnknownHostException, SocketException {
        this.syslogOutputStream = new SyslogOutputStream(this.getHost(), this.getPort());
        return this.syslogOutputStream;
    }
}

