/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite;

import java.io.IOException;
import java.util.Objects;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonFactory;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonFactoryAware;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProviders;

public abstract class AbstractNestedJsonProvider<Event extends DeferredProcessingAware>
extends AbstractFieldJsonProvider<Event>
implements JsonFactoryAware {
    public static final String FIELD_NESTED = "nested";
    private JsonProviders<Event> jsonProviders = new JsonProviders();

    public AbstractNestedJsonProvider() {
        this.setFieldName(FIELD_NESTED);
    }

    @Override
    public void start() {
        this.getProviders().start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.getProviders().stop();
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        generator.writeFieldName(this.getFieldName());
        generator.writeStartObject();
        this.jsonProviders.writeTo(generator, event);
        generator.writeEndObject();
    }

    public JsonProviders<Event> getProviders() {
        return this.jsonProviders;
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.jsonProviders = Objects.requireNonNull(jsonProviders);
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        this.getProviders().setJsonFactory(Objects.requireNonNull(jsonFactory));
    }

    @Override
    public void prepareForDeferredProcessing(Event event) {
        super.prepareForDeferredProcessing(event);
        this.getProviders().prepareForDeferredProcessing(event);
    }
}

