/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite;

import java.io.IOException;
import java.util.Objects;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonFactory;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonFactoryAware;
import org.apache.juli.logging.net.logstash.logback.pattern.AbstractJsonPatternParser;
import org.apache.juli.logging.net.logstash.logback.pattern.NodeWriter;

public abstract class AbstractPatternJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements JsonFactoryAware {
    private NodeWriter<Event> nodeWriter;
    private String pattern;
    private JsonFactory jsonFactory;
    private boolean omitEmptyFields;

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        if (this.nodeWriter != null) {
            this.nodeWriter.write(generator, event);
        }
    }

    protected abstract AbstractJsonPatternParser<Event> createParser(JsonFactory var1);

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = Objects.requireNonNull(jsonFactory);
    }

    @Override
    public void start() {
        if (this.jsonFactory == null) {
            throw new IllegalStateException("JsonFactory has not been set");
        }
        try {
            this.nodeWriter = this.initializeNodeWriter();
        }
        catch (AbstractJsonPatternParser.JsonPatternException e) {
            this.nodeWriter = null;
            this.addError("Invalid [pattern]: " + e.getMessage(), e);
        }
        super.start();
    }

    private NodeWriter<Event> initializeNodeWriter() throws AbstractJsonPatternParser.JsonPatternException {
        AbstractJsonPatternParser<Event> parser = this.createParser(this.jsonFactory);
        parser.setOmitEmptyFields(this.omitEmptyFields);
        return parser.parse(this.pattern);
    }

    public boolean isOmitEmptyFields() {
        return this.omitEmptyFields;
    }

    public void setOmitEmptyFields(boolean omitEmptyFields) {
        this.omitEmptyFields = omitEmptyFields;
    }
}

