/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite;

import java.io.IOException;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.FieldNamesAware;
import org.apache.juli.logging.net.logstash.logback.composite.JsonWritingUtils;
import org.apache.juli.logging.net.logstash.logback.fieldnames.LogstashCommonFieldNames;

public class LogstashVersionJsonProvider<Event extends DeferredProcessingAware>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<LogstashCommonFieldNames> {
    public static final String FIELD_VERSION = "@version";
    public static final String DEFAULT_VERSION = "1";
    private String version;
    private long versionAsInteger;
    private boolean writeAsInteger;

    public LogstashVersionJsonProvider() {
        this.setFieldName(FIELD_VERSION);
        this.setVersion(DEFAULT_VERSION);
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        if (this.writeAsInteger) {
            JsonWritingUtils.writeNumberField(generator, this.getFieldName(), this.versionAsInteger);
        } else {
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.version);
        }
    }

    @Override
    public void setFieldNames(LogstashCommonFieldNames fieldNames) {
        this.setFieldName(fieldNames.getVersion());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        if (this.writeAsInteger) {
            this.versionAsInteger = Integer.parseInt(version);
        }
    }

    public boolean isWriteAsInteger() {
        return this.writeAsInteger;
    }

    public void setWriteAsInteger(boolean writeAsInteger) {
        this.writeAsInteger = writeAsInteger;
        if (writeAsInteger) {
            this.versionAsInteger = Integer.parseInt(this.version);
        }
    }
}

