/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.FieldNamesAware;
import org.apache.juli.logging.net.logstash.logback.fieldnames.LogstashFieldNames;
import org.apache.juli.logging.org.slf4j.event.KeyValuePair;

public class KeyValuePairsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    private List<String> includeKeyNames = new ArrayList<String>();
    private List<String> excludeKeyNames = new ArrayList<String>();
    private final Map<String, String> keyFieldNames = new HashMap<String, String>();

    @Override
    public void start() {
        if (!this.includeKeyNames.isEmpty() && !this.excludeKeyNames.isEmpty()) {
            this.addError("Both includeKeyNames and excludeKeyNames are not empty.  Only one is allowed to be not empty.");
        }
        super.start();
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        List<KeyValuePair> keyValuePairs = event.getKeyValuePairs();
        if (keyValuePairs == null || keyValuePairs.isEmpty()) {
            return;
        }
        String fieldName = this.getFieldName();
        if (fieldName != null) {
            generator.writeObjectFieldStart(this.getFieldName());
        }
        for (KeyValuePair keyValuePair : keyValuePairs) {
            if (keyValuePair.key == null || keyValuePair.value == null || !this.includeKeyNames.isEmpty() && !this.includeKeyNames.contains(keyValuePair.key) || !this.excludeKeyNames.isEmpty() && this.excludeKeyNames.contains(keyValuePair.key)) continue;
            String key = this.keyFieldNames.get(keyValuePair.key);
            if (key == null) {
                key = keyValuePair.key;
            }
            generator.writeFieldName(key);
            generator.writeObject(keyValuePair.value);
        }
        if (fieldName != null) {
            generator.writeEndObject();
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getKeyValuePair());
    }

    public List<String> getIncludeKeyNames() {
        return Collections.unmodifiableList(this.includeKeyNames);
    }

    public void addIncludeKeyName(String includedKeyName) {
        this.includeKeyNames.add(includedKeyName);
    }

    public void setIncludeKeyNames(List<String> includeKeyNames) {
        this.includeKeyNames = new ArrayList<String>(includeKeyNames);
    }

    public List<String> getExcludeKeyNames() {
        return Collections.unmodifiableList(this.excludeKeyNames);
    }

    public void addExcludeKeyName(String excludedKeyName) {
        this.excludeKeyNames.add(excludedKeyName);
    }

    public void setExcludeKeyNames(List<String> excludeKeyNames) {
        this.excludeKeyNames = new ArrayList<String>(excludeKeyNames);
    }

    public Map<String, String> getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public void addKeyFieldName(String keyFieldName) {
        String[] split = keyFieldName.split("=");
        if (split.length != 2) {
            throw new IllegalArgumentException("keyFieldName (" + keyFieldName + ") must be in the form keyName=fieldName");
        }
        this.keyFieldNames.put(split[0], split[1]);
    }
}

