/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.pattern;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juli.logging.ch.qos.logback.classic.pattern.ClassicConverter;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.classic.spi.LoggerContextVO;

public class EnhancedPropertyConverter
extends ClassicConverter {
    private static final Pattern PATTERN = Pattern.compile("(.+?):-(.*)");
    private String propertyName;
    private String defaultValue = "";

    @Override
    public void start() {
        String optStr = this.getFirstOption();
        if (optStr != null) {
            this.propertyName = optStr;
            super.start();
        }
        if (this.propertyName == null) {
            throw new IllegalStateException("Property name is not specified");
        }
        Matcher matcher = PATTERN.matcher(this.propertyName);
        if (matcher.matches()) {
            this.propertyName = matcher.group(1);
            this.defaultValue = matcher.group(2);
        }
    }

    @Override
    public String convert(ILoggingEvent event) {
        LoggerContextVO lcvo = event.getLoggerContextVO();
        Map<String, String> map = lcvo.getPropertyMap();
        String val = map.get(this.propertyName);
        if (val == null) {
            val = System.getProperty(this.propertyName);
        }
        if (val == null) {
            val = this.defaultValue;
        }
        return val;
    }
}

