/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import org.apache.juli.logging.com.fasterxml.jackson.databind.JsonNode;
import org.apache.juli.logging.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.juli.logging.com.fasterxml.jackson.databind.node.ObjectNode;

public class SimpleObjectJsonGeneratorDelegate
extends JsonGeneratorDelegate {
    public SimpleObjectJsonGeneratorDelegate(JsonGenerator delegate) {
        super(delegate, false);
    }

    @Override
    public void writeObject(Object value) throws IOException {
        if (value == null) {
            this.writeNull();
            return;
        }
        if (value instanceof String) {
            this.writeString((String)value);
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (n instanceof Integer) {
                this.writeNumber(n.intValue());
                return;
            }
            if (n instanceof Long) {
                this.writeNumber(n.longValue());
                return;
            }
            if (n instanceof Double) {
                this.writeNumber(n.doubleValue());
                return;
            }
            if (n instanceof Float) {
                this.writeNumber(n.floatValue());
                return;
            }
            if (n instanceof Short) {
                this.writeNumber(n.shortValue());
                return;
            }
            if (n instanceof Byte) {
                this.writeNumber(n.byteValue());
                return;
            }
            if (n instanceof BigInteger) {
                this.writeNumber((BigInteger)n);
                return;
            }
            if (n instanceof BigDecimal) {
                this.writeNumber((BigDecimal)n);
                return;
            }
            if (n instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)n).get());
                return;
            }
            if (n instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)n).get());
                return;
            }
        }
        if (value instanceof byte[]) {
            this.writeBinary((byte[])value);
            return;
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
            return;
        }
        if (value instanceof AtomicBoolean) {
            this.writeBoolean(((AtomicBoolean)value).get());
            return;
        }
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)value;
            switch (node.getNodeType()) {
                case NULL: {
                    this.writeNull();
                    return;
                }
                case STRING: {
                    this.writeString(node.asText());
                    return;
                }
                case BOOLEAN: {
                    this.writeBoolean(node.asBoolean());
                    return;
                }
                case BINARY: {
                    this.writeBinary(node.binaryValue());
                    return;
                }
                case NUMBER: {
                    if (node.isInt()) {
                        this.writeNumber(node.intValue());
                        return;
                    }
                    if (node.isLong()) {
                        this.writeNumber(node.longValue());
                        return;
                    }
                    if (node.isShort()) {
                        this.writeNumber(node.shortValue());
                        return;
                    }
                    if (node.isDouble()) {
                        this.writeNumber(node.doubleValue());
                        return;
                    }
                    if (node.isFloat()) {
                        this.writeNumber(node.floatValue());
                        return;
                    }
                    if (node.isBigDecimal()) {
                        this.writeNumber(node.decimalValue());
                        return;
                    }
                    if (node.isBigInteger()) {
                        this.writeNumber(node.bigIntegerValue());
                        return;
                    }
                }
                case OBJECT: {
                    this.writeStartObject(node);
                    Iterator<Map.Entry<String, JsonNode>> entries = ((ObjectNode)node).fields();
                    while (entries.hasNext()) {
                        Map.Entry<String, JsonNode> entry = entries.next();
                        this.writeObjectField(entry.getKey(), entry.getValue());
                    }
                    this.writeEndObject();
                    return;
                }
                case ARRAY: {
                    ArrayNode arrayNode = (ArrayNode)node;
                    int size = arrayNode.size();
                    this.writeStartArray(arrayNode, size);
                    Iterator<JsonNode> elements = arrayNode.elements();
                    while (elements.hasNext()) {
                        this.writeObject(elements.next());
                    }
                    this.writeEndArray();
                    return;
                }
            }
        }
        this.delegate.writeObject(value);
    }
}

