/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.juli.logging.ch.qos.logback.core.CoreConstants;

public class StringUtils {
    private StringUtils() {
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StringUtils.delimitedListToStringArray(str, ",");
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        if (str == null || str.isEmpty()) {
            return CoreConstants.EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(str.substring(i, i + 1));
            }
        } else {
            int nextPos;
            int pos = 0;
            int searchPos = 0;
            boolean escaping = false;
            while ((nextPos = str.indexOf(delimiter, searchPos)) != -1) {
                if (nextPos > 0 && str.charAt(nextPos - 1) == '\\') {
                    searchPos = nextPos + delimiter.length();
                    escaping = true;
                    continue;
                }
                StringUtils.addToResult(result, str.substring(pos, nextPos), escaping, delimiter);
                escaping = false;
                searchPos = pos = nextPos + delimiter.length();
            }
            if (pos <= str.length()) {
                StringUtils.addToResult(result, str.substring(pos), escaping, delimiter);
            }
        }
        return result.toArray(CoreConstants.EMPTY_STRING_ARRAY);
    }

    private static void addToResult(Collection<String> result, String str, boolean unescape, String delimiter) {
        if (unescape) {
            str = str.replace("\\" + delimiter, delimiter);
        }
        if (!StringUtils.isBlank(str = StringUtils.trim(str))) {
            result.add(str);
        }
    }
}

