/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.anim8.AnimationWriter;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.LZWEncoder;
import com.github.tommyettinger.anim8.OtherMath;
import com.github.tommyettinger.anim8.PaletteReducer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class AnimatedGif
implements AnimationWriter,
Dithered {
    protected Dithered.DitherAlgorithm ditherAlgorithm = Dithered.DitherAlgorithm.NEUE;
    protected int width;
    protected int height;
    protected int x = 0;
    protected int y = 0;
    protected boolean flipY = true;
    protected int transIndex = -1;
    protected int repeat = 0;
    protected int delay = 16;
    protected boolean started = false;
    protected OutputStream out;
    protected Pixmap image;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int seq = 0;
    private boolean clearPalette;
    public boolean fastAnalysis = true;
    public PaletteReducer palette;
    protected float ditherStrength = 1.0f;

    @Override
    public void write(FileHandle file, Array<Pixmap> frames) {
        this.write(file, frames, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileHandle file, Array<Pixmap> frames, int fps) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, fps);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps) {
        if (frames == null || frames.isEmpty()) {
            return;
        }
        boolean bl = this.clearPalette = this.palette == null;
        if (this.clearPalette) {
            if (this.fastAnalysis && frames.size > 1) {
                this.palette = new PaletteReducer();
                this.palette.analyzeFast((Pixmap)frames.first(), 150.0, 256);
            } else {
                this.palette = new PaletteReducer((Pixmap)frames.first());
            }
        }
        if (!this.start(output)) {
            return;
        }
        this.setFrameRate(fps);
        for (int i = 0; i < frames.size; ++i) {
            this.addFrame((Pixmap)frames.get(i));
        }
        this.finish();
        if (this.clearPalette) {
            this.palette = null;
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    @Override
    public PaletteReducer getPalette() {
        return this.palette;
    }

    @Override
    public void setPalette(PaletteReducer palette) {
        this.palette = palette;
    }

    public void setDelay(int ms) {
        this.delay = ms;
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    @Override
    public Dithered.DitherAlgorithm getDitherAlgorithm() {
        return this.ditherAlgorithm;
    }

    @Override
    public void setDitherAlgorithm(Dithered.DitherAlgorithm ditherAlgorithm) {
        if (ditherAlgorithm != null) {
            this.ditherAlgorithm = ditherAlgorithm;
        }
    }

    public boolean addFrame(Pixmap im) {
        if (im == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            ++this.seq;
            this.image = im;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException e) {
            ok = false;
        }
        return ok;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.transIndex = -1;
        this.out = null;
        this.image = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.sizeSet = false;
        this.firstFrame = true;
        this.seq = 0;
        return ok;
    }

    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            this.delay = (int)(1000.0f / fps);
        }
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean start(OutputStream os) {
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
            Gdx.app.error("anim8", e.getMessage());
        }
        this.started = ok;
        return this.started;
    }

    protected void analyzePixels() {
        int nPix = this.width * this.height;
        this.indexedPixels = new byte[nPix];
        this.palette.setDitherStrength(this.ditherStrength);
        if (this.seq > 1 && this.clearPalette) {
            if (this.fastAnalysis) {
                this.palette.analyzeFast(this.image, 150.0, 256);
            } else {
                this.palette.analyze(this.image, 150.0, 256);
            }
        }
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        this.colorTab = new byte[768];
        int bi = 0;
        for (int i = 0; i < 256; ++i) {
            int pa = paletteArray[i];
            this.colorTab[bi++] = (byte)(pa >>> 24);
            this.colorTab[bi++] = (byte)(pa >>> 16);
            this.colorTab[bi++] = (byte)(pa >>> 8);
            this.usedEntry[i] = false;
        }
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        boolean hasTransparent = paletteArray[0] == 0;
        switch (this.ditherAlgorithm) {
            case NONE: {
                int color;
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, flipped + flipDir * y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            this.indexedPixels[i] = paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F];
                            this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case PATTERN: {
                int used;
                int color;
                float errorMul = this.palette.ditherStrength * this.palette.populationBias;
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, flipped + flipDir * y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            int er = 0;
                            int eg = 0;
                            int eb = 0;
                            int cr = color >>> 24;
                            int cg = color >>> 16 & 0xFF;
                            int cb = color >>> 8 & 0xFF;
                            for (int c = 0; c < 16; ++c) {
                                int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                                int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                                int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                                int usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                                this.palette.candidates[c] = used = paletteArray[usedIndex];
                                this.palette.candidates[c | 0x10] = PaletteReducer.shrink(used);
                                er += cr - (used >>> 24);
                                eg += cg - (used >>> 16 & 0xFF);
                                eb += cb - (used >>> 8 & 0xFF);
                            }
                            PaletteReducer.sort16(this.palette.candidates);
                            this.indexedPixels[i] = (byte)this.palette.reverseMap.get(this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]], 1);
                            this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case CHAOTIC_NOISE: {
                int used;
                int color;
                double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
                long s = -4521708957497675121L * (long)this.seq;
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, flipped + flipDir * y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            int rr = color >>> 24;
                            int gg = color >>> 16 & 0xFF;
                            int bb = color >>> 8 & 0xFF;
                            used = paletteArray[paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                            double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                            adj *= adj * adj;
                            long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                            s = (s ^ (long)color) * -3372029247567499371L + -7935046062780286179L;
                            rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                            gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                            bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                            this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                            this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case GRADIENT_NOISE: {
                int used;
                int color;
                float strength = this.palette.ditherStrength * this.palette.populationBias * 3.0f;
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, flipped + flipDir * y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            color |= color >>> 5 & 0x7070700 | 0xFE;
                            int rr = color >>> 24;
                            int gg = color >>> 16 & 0xFF;
                            int bb = color >>> 8 & 0xFF;
                            used = paletteArray[paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                            float pos = (float)px * 0.06711056f + (float)y * 0.00583715f;
                            pos -= (float)((int)pos);
                            pos *= 52.982918f;
                            pos -= (float)((int)pos);
                            float adj = (pos - 0.5f) * strength;
                            rr = Math.min(Math.max((int)((float)rr + adj * (float)(rr - (used >>> 24))), 0), 255);
                            gg = Math.min(Math.max((int)((float)gg + adj * (float)(gg - (used >>> 16 & 0xFF))), 0), 255);
                            bb = Math.min(Math.max((int)((float)bb + adj * (float)(bb - (used >>> 8 & 0xFF))), 0), 255);
                            this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                            this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case DIFFUSION: {
                float[] nextErrorBlue;
                float[] curErrorBlue;
                float[] nextErrorGreen;
                float[] curErrorGreen;
                float[] nextErrorRed;
                float[] curErrorRed;
                int used;
                int color;
                int w = this.width;
                float w1 = this.palette.ditherStrength * 4.0f;
                float w3 = w1 * 3.0f;
                float w5 = w1 * 5.0f;
                float w7 = w1 * 7.0f;
                if (this.palette.curErrorRedFloats == null) {
                    this.palette.curErrorRedFloats = new FloatArray(w);
                    curErrorRed = this.palette.curErrorRedFloats.items;
                    this.palette.nextErrorRedFloats = new FloatArray(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.items;
                    this.palette.curErrorGreenFloats = new FloatArray(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.items;
                    this.palette.nextErrorGreenFloats = new FloatArray(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                    this.palette.curErrorBlueFloats = new FloatArray(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.items;
                    this.palette.nextErrorBlueFloats = new FloatArray(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.items;
                } else {
                    curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = flipped + flipDir * y;
                    int ny = y + 1;
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            byte paletteIndex;
                            float er = curErrorRed[px];
                            float eg = curErrorGreen[px];
                            float eb = curErrorBlue[px];
                            int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                            int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                            int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                            this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                            this.usedEntry[paletteIndex & 0xFF] = true;
                            used = paletteArray[paletteIndex & 0xFF];
                            float rdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 24) - (used >>> 24)));
                            float gdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                            float bdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                            if (px < w - 1) {
                                int n = px + 1;
                                curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                                int n2 = px + 1;
                                curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                                int n3 = px + 1;
                                curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                            }
                            if (ny < this.height) {
                                if (px > 0) {
                                    int n = px - 1;
                                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                                    int n4 = px - 1;
                                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                                    int n5 = px - 1;
                                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                                }
                                if (px < w - 1) {
                                    int n = px + 1;
                                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                                    int n6 = px + 1;
                                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                                    int n7 = px + 1;
                                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                                }
                                int n = px;
                                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                                int n8 = px;
                                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                                int n9 = px;
                                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                            }
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case BLUE_NOISE: {
                int color;
                float strength = 48.0f * this.palette.ditherStrength / this.palette.populationBias;
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, flipped + flipDir * y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007f;
                            int rr = MathUtils.clamp((int)((int)((adj *= strength + (float)(px + y << 3 & 0x18) - 12.0f) + (float)(color >>> 24))), (int)0, (int)255);
                            int gg = MathUtils.clamp((int)((int)(adj + (float)(color >>> 16 & 0xFF))), (int)0, (int)255);
                            int bb = MathUtils.clamp((int)((int)(adj + (float)(color >>> 8 & 0xFF))), (int)0, (int)255);
                            this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                            this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            case SCATTER: {
                float[] nextErrorBlue;
                float[] curErrorBlue;
                float[] nextErrorGreen;
                float[] curErrorGreen;
                float[] nextErrorRed;
                float[] curErrorRed;
                int used;
                int color;
                int w = this.width;
                float w1 = this.palette.ditherStrength * 3.5f;
                float w3 = w1 * 3.0f;
                float w5 = w1 * 5.0f;
                float w7 = w1 * 7.0f;
                if (this.palette.curErrorRedFloats == null) {
                    this.palette.curErrorRedFloats = new FloatArray(w);
                    curErrorRed = this.palette.curErrorRedFloats.items;
                    this.palette.nextErrorRedFloats = new FloatArray(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.items;
                    this.palette.curErrorGreenFloats = new FloatArray(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.items;
                    this.palette.nextErrorGreenFloats = new FloatArray(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                    this.palette.curErrorBlueFloats = new FloatArray(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.items;
                    this.palette.nextErrorBlueFloats = new FloatArray(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.items;
                } else {
                    curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = flipped + flipDir * y;
                    int ny = y + 1;
                    int px = 0;
                    while (px < this.width & i < nPix) {
                        color = this.image.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                        } else {
                            byte paletteIndex;
                            float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                            float er = curErrorRed[px] * tbn;
                            float eg = curErrorGreen[px] * tbn;
                            float eb = curErrorBlue[px] * tbn;
                            int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                            int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                            int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                            this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                            this.usedEntry[paletteIndex & 0xFF] = true;
                            used = paletteArray[paletteIndex & 0xFF];
                            float rdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 24) - (used >>> 24)));
                            float gdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                            float bdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                            if (px < w - 1) {
                                int n = px + 1;
                                curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                                int n10 = px + 1;
                                curErrorGreen[n10] = curErrorGreen[n10] + gdiff * w7;
                                int n11 = px + 1;
                                curErrorBlue[n11] = curErrorBlue[n11] + bdiff * w7;
                            }
                            if (ny < this.height) {
                                if (px > 0) {
                                    int n = px - 1;
                                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                                    int n12 = px - 1;
                                    nextErrorGreen[n12] = nextErrorGreen[n12] + gdiff * w3;
                                    int n13 = px - 1;
                                    nextErrorBlue[n13] = nextErrorBlue[n13] + bdiff * w3;
                                }
                                if (px < w - 1) {
                                    int n = px + 1;
                                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                                    int n14 = px + 1;
                                    nextErrorGreen[n14] = nextErrorGreen[n14] + gdiff * w1;
                                    int n15 = px + 1;
                                    nextErrorBlue[n15] = nextErrorBlue[n15] + bdiff * w1;
                                }
                                int n = px;
                                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                                int n16 = px;
                                nextErrorGreen[n16] = nextErrorGreen[n16] + gdiff * w5;
                                int n17 = px;
                                nextErrorBlue[n17] = nextErrorBlue[n17] + bdiff * w5;
                            }
                            ++i;
                        }
                        ++px;
                    }
                }
                break;
            }
            default: {
                float[] nextErrorBlue;
                float[] curErrorBlue;
                float[] nextErrorGreen;
                float[] curErrorGreen;
                float[] nextErrorRed;
                float[] curErrorRed;
                int used;
                int color;
                int w = this.width;
                float w1 = this.palette.ditherStrength * 7.0f;
                float w3 = w1 * 3.0f;
                float w5 = w1 * 5.0f;
                float w7 = w1 * 7.0f;
                float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
                float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
                if (this.palette.curErrorRedFloats == null) {
                    this.palette.curErrorRedFloats = new FloatArray(w);
                    curErrorRed = this.palette.curErrorRedFloats.items;
                    this.palette.nextErrorRedFloats = new FloatArray(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.items;
                    this.palette.curErrorGreenFloats = new FloatArray(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.items;
                    this.palette.nextErrorGreenFloats = new FloatArray(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                    this.palette.curErrorBlueFloats = new FloatArray(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.items;
                    this.palette.nextErrorBlueFloats = new FloatArray(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.items;
                } else {
                    curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                    nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                    curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                    nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                    curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                    nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                int i = 0;
                for (int y = 0; y < this.height && i < nPix; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = flipped + flipDir * y;
                    int ny = y + 1;
                    for (int px = 0; px < this.width && i < nPix; ++px) {
                        byte paletteIndex;
                        color = this.image.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            this.indexedPixels[i++] = 0;
                            continue;
                        }
                        float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                        adj = Math.min(Math.max(adj * strength, -limit), limit);
                        float er = adj + curErrorRed[px];
                        float eg = adj + curErrorGreen[px];
                        float eb = adj + curErrorBlue[px];
                        int rr = MathUtils.clamp((int)((int)((float)(color >>> 24) + er + 0.5f)), (int)0, (int)255);
                        int gg = MathUtils.clamp((int)((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f)), (int)0, (int)255);
                        int bb = MathUtils.clamp((int)((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f)), (int)0, (int)255);
                        this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        this.usedEntry[paletteIndex & 0xFF] = true;
                        used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 24) - (used >>> 24)));
                        float gdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                        float bdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n18 = px + 1;
                            curErrorGreen[n18] = curErrorGreen[n18] + gdiff * w7;
                            int n19 = px + 1;
                            curErrorBlue[n19] = curErrorBlue[n19] + bdiff * w7;
                        }
                        if (ny < this.height) {
                            if (px > 0) {
                                int n = px - 1;
                                nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                                int n20 = px - 1;
                                nextErrorGreen[n20] = nextErrorGreen[n20] + gdiff * w3;
                                int n21 = px - 1;
                                nextErrorBlue[n21] = nextErrorBlue[n21] + bdiff * w3;
                            }
                            if (px < w - 1) {
                                int n = px + 1;
                                nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                                int n22 = px + 1;
                                nextErrorGreen[n22] = nextErrorGreen[n22] + gdiff * w1;
                                int n23 = px + 1;
                                nextErrorBlue[n23] = nextErrorBlue[n23] + bdiff * w1;
                            }
                            int n = px;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                            int n24 = px;
                            nextErrorGreen[n24] = nextErrorGreen[n24] + gdiff * w5;
                            int n25 = px;
                            nextErrorBlue[n25] = nextErrorBlue[n25] + bdiff * w5;
                        }
                        ++i;
                    }
                }
            }
        }
        this.colorDepth = 8;
        this.palSize = 7;
        if (hasTransparent) {
            this.transIndex = 0;
        }
    }

    protected void getImagePixels() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        if (w != this.width || h != this.height) {
            Pixmap temp = new Pixmap(this.width, this.height, Pixmap.Format.RGBA8888);
            temp.drawPixmap(this.image, 0, 0);
            this.image = temp;
        }
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transIndex == -1) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(Math.round((float)this.delay / 10.0f));
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(this.x);
        this.writeShort(this.y);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >>> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }
}

