/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.NumberUtils;

public final class OtherMath {
    private OtherMath() {
    }

    public static float barronSpline(float x, float shape, float turning) {
        float d = turning - x;
        int f = NumberUtils.floatToRawIntBits((float)d) >> 31;
        int n = f | 1;
        return (turning * (float)n - (float)f) * (x + (float)f) / (Float.MIN_NORMAL - (float)f + (x + shape * d) * (float)n) - (float)f;
    }

    public static byte centralize(byte v) {
        return (byte)(OtherMath.barronSpline((float)(v & 0xFF) * 0.003921569f, 0.5f, 0.5f) * 255.999f);
    }

    public static double probit(double d) {
        if (d <= 0.0 || d >= 1.0) {
            return Math.copySign(38.5, d - 0.5);
        }
        if (d < 0.02425) {
            double q = Math.sqrt(-2.0 * Math.log(d));
            return (((((-0.007784894002430293 * q + -0.3223964580411365) * q + -2.400758277161838) * q + -2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        if (0.97575 < d) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - d));
            return -(((((-0.007784894002430293 * q + -0.3223964580411365) * q + -2.400758277161838) * q + -2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        double q = d - 0.5;
        double r = q * q;
        return (((((-39.69683028665376 * r + 220.9460984245205) * r + -275.9285104469687) * r + 138.357751867269) * r + -30.66479806614716) * r + 2.506628277459239) * q / (((((-54.47609879822406 * r + 161.5858368580409) * r + -155.6989798598866) * r + 66.80131188771972) * r + -13.28068155288572) * r + 1.0);
    }

    public static float cbrt(float x) {
        int ix = NumberUtils.floatToRawIntBits((float)x);
        int sign = ix & Integer.MIN_VALUE;
        ix &= Integer.MAX_VALUE;
        float x0 = x;
        ix = (ix >>> 2) + (ix >>> 4);
        ix += ix >>> 4;
        ix = ix + (ix >>> 8) + 709965728 | sign;
        x = NumberUtils.intBitsToFloat((int)ix);
        x = 0.33333334f * (2.0f * x + x0 / (x * x));
        x = 0.33333334f * (2.0f * x + x0 / (x * x));
        return x;
    }

    public static float cbrtShape(float x) {
        int i = NumberUtils.floatToRawIntBits((float)x);
        return NumberUtils.intBitsToFloat((int)(((i & Integer.MAX_VALUE) - 1065353216) / 3 + 1065353216 | i & Integer.MIN_VALUE));
    }

    public static class BiasGain
    extends Interpolation {
        public final float shape;
        public final float turning;

        public BiasGain(float shape, float turning) {
            this.shape = shape;
            this.turning = turning;
        }

        public float apply(float a) {
            return OtherMath.barronSpline(a, this.shape, this.turning);
        }
    }
}

