/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.anim8.AnimationWriter;
import com.github.tommyettinger.anim8.ChunkBuffer;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.OtherMath;
import com.github.tommyettinger.anim8.PaletteReducer;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNG8
implements AnimationWriter,
Dithered,
Disposable {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int PLTE = 1347179589;
    private static final int TRNS = 1951551059;
    private static final int acTL = 1633899596;
    private static final int fcTL = 1717785676;
    private static final int fdAT = 1717846356;
    private static final byte COLOR_INDEXED = 3;
    private static final byte COMPRESSION_DEFLATE = 0;
    private static final byte INTERLACE_NONE = 0;
    private static final byte FILTER_NONE = 0;
    private final ChunkBuffer buffer;
    private final Deflater deflater;
    private ByteArray curLineBytes;
    private ByteArray prevLineBytes;
    private boolean flipY = true;
    private int lastLineLen;
    public PaletteReducer palette;
    protected Dithered.DitherAlgorithm ditherAlgorithm = Dithered.DitherAlgorithm.NEUE;
    protected float ditherStrength = 1.0f;

    @Override
    public PaletteReducer getPalette() {
        return this.palette;
    }

    @Override
    public void setPalette(PaletteReducer palette) {
        this.palette = palette;
    }

    @Override
    public Dithered.DitherAlgorithm getDitherAlgorithm() {
        return this.ditherAlgorithm;
    }

    @Override
    public void setDitherAlgorithm(Dithered.DitherAlgorithm ditherAlgorithm) {
        if (ditherAlgorithm != null) {
            this.ditherAlgorithm = ditherAlgorithm;
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    public PNG8() {
        this(16384);
    }

    public PNG8(int initialBufferSize) {
        this.buffer = new ChunkBuffer(initialBufferSize);
        this.deflater = new Deflater();
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void setCompression(int level) {
        this.deflater.setLevel(level);
    }

    public void write(FileHandle file, Pixmap pixmap) {
        this.write(file, pixmap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette, boolean dither) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette, dither);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette, boolean dither, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette, dither, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void write(OutputStream output, Pixmap pixmap) {
        this.writePrecisely(output, pixmap, true);
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette) {
        if (computePalette) {
            this.writePrecisely(output, pixmap, true);
        } else {
            this.write(output, pixmap, false, true);
        }
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette, boolean dither) {
        this.write(output, pixmap, computePalette, dither, 400);
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette, boolean dither, int threshold) {
        boolean clearPalette;
        boolean bl = clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new PaletteReducer(pixmap, (double)threshold);
        } else if (computePalette) {
            this.palette.analyze(pixmap, (double)threshold);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            switch (this.ditherAlgorithm) {
                case NONE: {
                    this.writeSolid(output, pixmap);
                    break;
                }
                case GRADIENT_NOISE: {
                    this.writeGradientDithered(output, pixmap);
                    break;
                }
                case PATTERN: {
                    this.writePatternDithered(output, pixmap);
                    break;
                }
                case CHAOTIC_NOISE: {
                    this.writeChaoticNoiseDithered(output, pixmap);
                    break;
                }
                case DIFFUSION: {
                    this.writeDiffusionDithered(output, pixmap);
                    break;
                }
                case BLUE_NOISE: {
                    this.writeBlueNoiseDithered(output, pixmap);
                    break;
                }
                case SCATTER: {
                    this.writeScatterDithered(output, pixmap);
                    break;
                }
                default: {
                    this.writeNeueDithered(output, pixmap);
                    break;
                }
            }
        } else {
            this.writeSolid(output, pixmap);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }

    public void writePrecisely(FileHandle file, Pixmap pixmap, boolean ditherFallback) {
        this.writePrecisely(file, pixmap, ditherFallback, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrecisely(FileHandle file, Pixmap pixmap, boolean ditherFallback, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.writePrecisely(output, pixmap, ditherFallback, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrecisely(FileHandle file, Pixmap pixmap, int[] exactPalette, boolean ditherFallback, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.writePrecisely(output, pixmap, exactPalette, ditherFallback, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, boolean ditherFallback) {
        this.writePrecisely(output, pixmap, ditherFallback, 400);
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, boolean ditherFallback, int threshold) {
        this.writePrecisely(output, pixmap, null, ditherFallback, threshold);
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, int[] exactPalette, boolean ditherFallback, int threshold) {
        int[] paletteArray;
        int color;
        IntIntMap colorToIndex = new IntIntMap(256);
        colorToIndex.put(0, 0);
        int hasTransparent = 0;
        int w = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (exactPalette == null) {
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    if ((color & 0xFE) != 254 && !colorToIndex.containsKey(color)) {
                        if (hasTransparent == 0 && colorToIndex.size >= 256) {
                            this.write(output, pixmap, true, ditherFallback, threshold);
                            return;
                        }
                        hasTransparent = 1;
                        continue;
                    }
                    if (colorToIndex.containsKey(color)) continue;
                    colorToIndex.put(color, colorToIndex.size & 0xFF);
                    if (colorToIndex.size == 257 && hasTransparent == 0) {
                        colorToIndex.remove(0, 0);
                    }
                    if (colorToIndex.size <= 256) continue;
                    this.write(output, pixmap, true, ditherFallback, threshold);
                    return;
                }
            }
            paletteArray = new int[colorToIndex.size];
            for (IntIntMap.Entry ent : colorToIndex) {
                paletteArray[ent.value] = ent.key;
            }
        } else {
            hasTransparent = exactPalette[0] == 0 ? 1 : 0;
            paletteArray = exactPalette;
            for (int i = hasTransparent; i < paletteArray.length; ++i) {
                colorToIndex.put(paletteArray[i], i);
            }
        }
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            if (hasTransparent == 1) {
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = pixmap.getWidth();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(lineLen);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(lineLen);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(lineLen);
                prevLine = this.prevLineBytes.ensureCapacity(lineLen);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = lineLen;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    curLine[px] = (byte)colorToIndex.get(color, 0);
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, lineLen);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePreciseSection(FileHandle file, Pixmap pixmap, int[] exactPalette, int startX, int startY, int width, int height) {
        OutputStream output = file.write(false);
        try {
            this.writePreciseSection(output, pixmap, exactPalette, startX, startY, width, height);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void writePreciseSection(OutputStream output, Pixmap pixmap, int[] exactPalette, int startX, int startY, int width, int height) {
        int[] paletteArray;
        int color;
        IntIntMap colorToIndex = new IntIntMap(256);
        colorToIndex.put(0, 0);
        int hasTransparent = 0;
        int w = startX + width;
        int h = startY + height;
        if (exactPalette == null) {
            for (int y = startY; y < h; ++y) {
                int py = this.flipY ? pixmap.getHeight() - y - 1 : y;
                for (int px = startX; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    if ((color & 0xFE) != 254 && !colorToIndex.containsKey(color)) {
                        if (hasTransparent == 0 && colorToIndex.size >= 256) {
                            throw new IllegalArgumentException("Too many colors to write precisely!");
                        }
                        hasTransparent = 1;
                        continue;
                    }
                    if (colorToIndex.containsKey(color)) continue;
                    colorToIndex.put(color, colorToIndex.size & 0xFF);
                    if (colorToIndex.size == 257 && hasTransparent == 0) {
                        colorToIndex.remove(0, 0);
                    }
                    if (colorToIndex.size <= 256) continue;
                    throw new IllegalArgumentException("Too many colors to write precisely!");
                }
            }
            paletteArray = new int[colorToIndex.size];
            for (IntIntMap.Entry ent : colorToIndex) {
                paletteArray[ent.value] = ent.key;
            }
        } else {
            hasTransparent = exactPalette[0] == 0 ? 1 : 0;
            paletteArray = exactPalette;
            for (int i = hasTransparent; i < paletteArray.length; ++i) {
                colorToIndex.put(paletteArray[i], i);
            }
        }
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            if (hasTransparent == 1) {
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = width;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(lineLen);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(lineLen);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(lineLen);
                prevLine = this.prevLineBytes.ensureCapacity(lineLen);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = lineLen;
            for (int y = startY; y < h; ++y) {
                int py = this.flipY ? pixmap.getHeight() - y - 1 : y;
                for (int px = startX; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    curLine[px - startX] = (byte)colorToIndex.get(color, 0);
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, lineLen);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeSolid(OutputStream output, Pixmap pixmap) {
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = pixmap.getWidth();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(lineLen);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(lineLen);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(lineLen);
                prevLine = this.prevLineBytes.ensureCapacity(lineLen);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = lineLen;
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, lineLen);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeGradientDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            float strength = this.palette.ditherStrength * this.palette.populationBias * 3.0f;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float pos = (float)px * 0.06711056f + (float)py * 0.00583715f;
                    pos -= (float)((int)pos);
                    pos *= 52.982918f;
                    pos -= (float)((int)pos);
                    float adj = (pos - 0.5f) * strength;
                    rr = Math.min(Math.max((int)((float)rr + adj * (float)(rr - (used >>> 24))), 0), 255);
                    gg = Math.min(Math.max((int)((float)gg + adj * (float)(gg - (used >>> 16 & 0xFF))), 0), 255);
                    bb = Math.min(Math.max((int)((float)bb + adj * (float)(bb - (used >>> 8 & 0xFF))), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeBlueNoiseDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            float strength = 48.0f * this.palette.ditherStrength / this.palette.populationBias;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.007f;
                    int rr = MathUtils.clamp((int)((int)((adj *= strength + (float)(px + py << 3 & 0x18) - 12.0f) + (float)(color >>> 24))), (int)0, (int)255);
                    int gg = MathUtils.clamp((int)((int)(adj + (float)(color >>> 16 & 0xFF))), (int)0, (int)255);
                    int bb = MathUtils.clamp((int)((int)(adj + (float)(color >>> 8 & 0xFF))), (int)0, (int)255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeChaoticNoiseDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
            long s = -4521708957497675121L;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                    adj *= adj * adj;
                    long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                    s = (s ^ (long)color) * -3372029247567499371L + -7935046062780286179L;
                    rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                    gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                    bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeDiffusionDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 4.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 24) - (used >>> 24)));
                    float gdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                    float bdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writePatternDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            float errorMul = this.palette.ditherStrength * this.palette.populationBias;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int er = 0;
                    int eg = 0;
                    int eb = 0;
                    int cr = color >>> 24;
                    int cg = color >>> 16 & 0xFF;
                    int cb = color >>> 8 & 0xFF;
                    for (int i = 0; i < 16; ++i) {
                        int used;
                        int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                        int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                        int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                        int usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                        this.palette.candidates[i] = used = paletteArray[usedIndex];
                        this.palette.candidates[i | 0x10] = PaletteReducer.shrink(used);
                        er += cr - (used >>> 24);
                        eg += cg - (used >>> 16 & 0xFF);
                        eb += cb - (used >>> 8 & 0xFF);
                    }
                    PaletteReducer.sort16(this.palette.candidates);
                    curLine[px] = (byte)this.palette.reverseMap.get(this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]], 1);
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeScatterDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 3.5f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                    float er = curErrorRed[px] * tbn;
                    float eg = curErrorGreen[px] * tbn;
                    float eb = curErrorBlue[px] * tbn;
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 24) - (used >>> 24)));
                    float gdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                    float bdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeNeueDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] prevLine;
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 7.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
                this.prevLineBytes = new ByteArray(w);
                prevLine = this.prevLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
                prevLine = this.prevLineBytes.ensureCapacity(w);
                int n = this.lastLineLen;
                for (int i = 0; i < n; ++i) {
                    prevLine[i] = 0;
                }
            }
            this.lastLineLen = w;
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                    adj = Math.min(Math.max(adj * strength, -limit), limit);
                    float er = adj + curErrorRed[px];
                    float eg = adj + curErrorGreen[px];
                    float eb = adj + curErrorBlue[px];
                    int rr = MathUtils.clamp((int)((int)((float)(color >>> 24) + er + 0.5f)), (int)0, (int)255);
                    int gg = MathUtils.clamp((int)((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f)), (int)0, (int)255);
                    int bb = MathUtils.clamp((int)((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f)), (int)0, (int)255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 24) - (used >>> 24)));
                    float gdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                    float bdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                byte[] temp = curLine;
                curLine = prevLine;
                prevLine = temp;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    @Override
    public void write(FileHandle file, Array<Pixmap> frames) {
        this.write(file, frames, 30, true);
    }

    @Override
    public void write(FileHandle file, Array<Pixmap> frames, int fps) {
        this.write(file, frames, fps, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Array<Pixmap> frames, int fps, boolean dither) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, fps, dither);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void write(OutputStream output, Array<Pixmap> frames, int fps, boolean dither) {
        boolean clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new PaletteReducer(frames);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            this.write(output, frames, fps);
        } else {
            this.writeSolid(output, frames, fps);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }

    private void writeSolid(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(width);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                    prevLine = this.prevLineBytes.ensureCapacity(width);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = width;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps) {
        switch (this.ditherAlgorithm) {
            case NONE: {
                this.writeSolid(output, frames, fps);
                break;
            }
            case GRADIENT_NOISE: {
                this.writeGradientDithered(output, frames, fps);
                break;
            }
            case PATTERN: {
                this.writePatternDithered(output, frames, fps);
                break;
            }
            case CHAOTIC_NOISE: {
                this.writeChaoticNoiseDithered(output, frames, fps);
                break;
            }
            case DIFFUSION: {
                this.writeDiffusionDithered(output, frames, fps);
                break;
            }
            case SCATTER: {
                this.writeScatterDithered(output, frames, fps);
                break;
            }
            case BLUE_NOISE: {
                this.writeBlueNoiseDithered(output, frames, fps);
                break;
            }
            default: {
                this.writeNeueDithered(output, frames, fps);
            }
        }
    }

    private void writeGradientDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = width;
            float strength = this.palette.ditherStrength * this.palette.populationBias * 3.0f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(width);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                    prevLine = this.prevLineBytes.ensureCapacity(width);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = width;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float pos = (float)px * 0.06711056f + (float)py * 0.00583715f;
                        pos -= (float)((int)pos);
                        pos *= 52.982918f;
                        pos -= (float)((int)pos);
                        float adj = (pos - 0.5f) * strength;
                        rr = Math.min(Math.max((int)((float)rr + adj * (float)(rr - (used >>> 24))), 0), 255);
                        gg = Math.min(Math.max((int)((float)gg + adj * (float)(gg - (used >>> 16 & 0xFF))), 0), 255);
                        bb = Math.min(Math.max((int)((float)bb + adj * (float)(bb - (used >>> 8 & 0xFF))), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeBlueNoiseDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = width;
            float strength = 48.0f * this.palette.ditherStrength / this.palette.populationBias;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(width);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                    prevLine = this.prevLineBytes.ensureCapacity(width);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = width;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.007f;
                        int rr = MathUtils.clamp((int)((int)((adj *= strength + (float)(px + py << 3 & 0x18) - 12.0f) + (float)(color >>> 24))), (int)0, (int)255);
                        int gg = MathUtils.clamp((int)((int)(adj + (float)(color >>> 16 & 0xFF))), (int)0, (int)255);
                        int bb = MathUtils.clamp((int)((int)(adj + (float)(color >>> 8 & 0xFF))), (int)0, (int)255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeChaoticNoiseDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = width;
            double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(width);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                    prevLine = this.prevLineBytes.ensureCapacity(width);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = width;
                long s = -4521708957497675121L * (long)seq;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                        adj *= adj * adj;
                        long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                        s = (s ^ (long)color) * -3372029247567499371L + -7935046062780286179L;
                        rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                        gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                        bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeDiffusionDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = w;
            float w1 = this.palette.ditherStrength * 4.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(w);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                    prevLine = this.prevLineBytes.ensureCapacity(w);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = w;
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = curErrorRed[px];
                        float eg = curErrorGreen[px];
                        float eb = curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 24) - (used >>> 24)));
                        float gdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                        float bdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writePatternDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = width;
            float errorMul = this.palette.ditherStrength * this.palette.populationBias;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(width);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                    prevLine = this.prevLineBytes.ensureCapacity(width);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                this.lastLineLen = width;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int er = 0;
                        int eg = 0;
                        int eb = 0;
                        int cr = color >>> 24;
                        int cg = color >>> 16 & 0xFF;
                        int cb = color >>> 8 & 0xFF;
                        for (int c = 0; c < 16; ++c) {
                            int used;
                            int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                            int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                            int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                            int usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                            this.palette.candidates[c] = used = paletteArray[usedIndex];
                            this.palette.candidates[c | 0x10] = PaletteReducer.shrink(used);
                            er += cr - (used >>> 24);
                            eg += cg - (used >>> 16 & 0xFF);
                            eb += cb - (used >>> 8 & 0xFF);
                        }
                        PaletteReducer.sort16(this.palette.candidates);
                        curLine[px] = (byte)this.palette.reverseMap.get(this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]], 1);
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeScatterDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = w;
            float w1 = this.palette.ditherStrength * 3.5f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(w);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                    prevLine = this.prevLineBytes.ensureCapacity(w);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                        float er = curErrorRed[px] * tbn;
                        float eg = curErrorGreen[px] * tbn;
                        float eb = curErrorBlue[px] * tbn;
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 24) - (used >>> 24)));
                        float gdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                        float bdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    private void writeNeueDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0.0f);
                Arrays.fill(nextErrorGreen, 0.0f);
                Arrays.fill(nextErrorBlue, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            this.lastLineLen = w;
            float w1 = this.palette.ditherStrength * 7.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] prevLine;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                    this.prevLineBytes = new ByteArray(w);
                    prevLine = this.prevLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                    prevLine = this.prevLineBytes.ensureCapacity(w);
                    int n = this.lastLineLen;
                    for (int ln = 0; ln < n; ++ln) {
                        prevLine[ln] = 0;
                    }
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                        adj = Math.min(Math.max(adj * strength, -limit), limit);
                        float er = adj + curErrorRed[px];
                        float eg = adj + curErrorGreen[px];
                        float eb = adj + curErrorBlue[px];
                        int rr = MathUtils.clamp((int)((int)((float)(color >>> 24) + er + 0.5f)), (int)0, (int)255);
                        int gg = MathUtils.clamp((int)((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f)), (int)0, (int)255);
                        int bb = MathUtils.clamp((int)((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f)), (int)0, (int)255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 24) - (used >>> 24)));
                        float gdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                        float bdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    byte[] temp = curLine;
                    curLine = prevLine;
                    prevLine = temp;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void dispose() {
        this.deflater.end();
    }

    protected static OrderedMap<String, byte[]> readChunks(InputStream inStream) throws IOException {
        DataInputStream in = new DataInputStream(inStream);
        if (in.readLong() != -8552249625308161526L) {
            throw new IOException("PNG signature not found!");
        }
        OrderedMap chunks = new OrderedMap(10);
        boolean trucking = true;
        while (trucking) {
            try {
                int length = in.readInt();
                if (length < 0) {
                    throw new IOException("Sorry, that file is too long.");
                }
                byte[] typeBytes = new byte[4];
                in.readFully(typeBytes);
                byte[] data = new byte[length];
                in.readFully(data);
                int crc = in.readInt();
                String type = new String(typeBytes, "UTF8");
                chunks.put((Object)type, (Object)data);
            }
            catch (EOFException eofe) {
                trucking = false;
            }
        }
        in.close();
        return chunks;
    }

    protected static void writeChunks(OutputStream outStream, OrderedMap<String, byte[]> chunks) {
        DataOutputStream out = new DataOutputStream(outStream);
        CRC32 crc = new CRC32();
        try {
            out.writeLong(-8552249625308161526L);
            for (ObjectMap.Entry ent : chunks.entries()) {
                out.writeInt(((byte[])ent.value).length);
                byte[] k = ((String)ent.key).getBytes("UTF8");
                out.write(k);
                crc.update(k, 0, k.length);
                out.write((byte[])ent.value);
                crc.update((byte[])ent.value, 0, ((byte[])ent.value).length);
                out.writeInt((int)crc.getValue());
                crc.reset();
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void swapPalette(FileHandle input, FileHandle output, int[] palette) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            int p = 0;
            for (int i = 0; i < palette.length && p < pal.length - 2; ++i) {
                int rgba = palette[i];
                pal[p++] = (byte)(rgba >>> 24);
                pal[p++] = (byte)(rgba >>> 16);
                pal[p++] = (byte)(rgba >>> 8);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void editPalette(FileHandle input, FileHandle output, Interpolation editor) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length - 2; p += 3) {
                pal[p] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p] & 0xFF) / 255.0f);
                pal[p + 1] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p + 1] & 0xFF) / 255.0f);
                pal[p + 2] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p + 2] & 0xFF) / 255.0f);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void centralizePalette(FileHandle input, FileHandle output) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length; ++p) {
                pal[p] = OtherMath.centralize(pal[p]);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void centralizePalette(FileHandle input, FileHandle output, float amount) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length; ++p) {
                pal[p] = (byte)MathUtils.lerp((float)(pal[p] & 0xFF), (float)(OtherMath.centralize(pal[p]) & 0xFF), (float)amount);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

