/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.anim8.ConstantData;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.OtherMath;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class PaletteReducer {
    public static final int[] HALTONIC = new int[]{0, 0x10101FF, -16843009, 0x7B7B7BFF, 0x555555FF, -1431655681, 0x333333FF, -522133249, -926365441, -1095020801, 531536639, -1027888641, -1268033281, 2088944383, -226337793, -716073985, -1940759297, 1794071039, 524524543, 2033324287, 993616639, 383201023, -1254111489, -1283405825, -303855105, -2078226689, 689377535, 1775555583, 1980898559, 531180287, 1686449407, 2051202047, -363176193, 2118028543, -1191561729, 1326832383, -1136762369, -1584312065, -1682102785, -258620673, -4042753, 2071788799, -1679244289, -497105665, 1031384575, -1069405441, 638475775, -163208193, -122886913, -1333321729, 1113074943, 1419216895, -484728065, 505555711, -1281559041, -1944887297, 1909166847, -1217940481, 2119184639, 1080465407, 1344997119, -542346241, -1038473473, -318872065, 2120541439, -1076744449, -627863553, -1902843649, -1596026113, -1939101185, 375586047, -900797185, -2003195137, 616323071, 1745528831, -26704385, 773746431, -2024368641, -1742987009, 1198669567, -186298369, 1897352447, -973558785, 1975502847, -230934529, -59512321, -1992663041, 1330693631, -530172417, -1341284353, -384840961, 513604607, 892926463, -476636161, 1342264319, 766693119, -1267890433, -29101313, 1341755647, 1128608255, -485157377, -543011841, 1115875071, 1449291775, -122121729, 1258894079, -680925441, -1871897089, -720288513, 1991702783, 1308093695, 378754559, -1211597313, 1695319039, 183054591, -306767105, 2024699903, 135411455, 635827455, 1514373887, -1308689665, -361034753, -210583041, -1558939137, 1054567167, -1539174145, -1295910145, -1365801729, -399411713, -114958337, -1424797697, -1069644801, 293566207, -421388801, 1798854911, -1997729025, 1043629823, 1035670783, -749395457, -1031574017, 609117695, -1406535937, -417703681, 287812607, -796466945, 1231756543, -763455745, -2026554625, -754389505, 1564191487, 290851839, 1184548607, -304825857, -1532878081, 1218927871, -1150151681, -71632129, 2034766335, -2088743169, -1308916225, 1640328703, -1657359873, 538350591, 407615999, 1527121663, -1420389633, 151725055, -1487324417, 349679103, -1402211841, -871465217, 462468351, -1515631361, 642058751, -376111617, -1042061313, 488035839, 475823615, -814134017, -151022081, 2065336575, 1756798207, -1428490241, 1713758719, 573769983, 1900543743, -546668545, -167894273, -1229860097, 904496895, 745133311, 1835256063, 839134719, -190671873, 570691071, -218447105, -4476161, -1656783617, -2039918849, -750036993, 1529750783, -221282049, 283881471, 2069904639, -35280897, -1273493249, -1472246785, -1037978369, -1778080513, -2021488641, 1058805503, 1520959231, 1426681087, 513352447, 51400959, -1568366081, 606399999, -1882123777, 1208781823, 1912496383, -31653121, -6659841, -733298945, -25453825, 1754357503, -1627401729, -1414759169, 1142145023, -113343489, 2056664063, -1604619265, -2086419457, 307055359, 964562687, 1795077631, -1755835393, -20511489, -1139514625, -1610030849, 1099466495, 1489698559, 1316639743, 2047344639, -1924219649, -30255105, -1536436737, -1334181889, -1869317889, -60013825, 1597195007, 1785372159, -10283521, -1655254273, 1736615935, -1786829569, -795887105};
    public static final double[][] IPT = new double[3][32768];
    public static final float[][] OKLAB = new float[3][32768];
    public static final byte[] TRI_BLUE_NOISE = ConstantData.TRI_BLUE_NOISE;
    public static final float[] TRI_BLUE_NOISE_MULTIPLIERS = ConstantData.TRI_BLUE_NOISE_MULTIPLIERS;
    private static final double[] EXACT_LOOKUP = new double[256];
    private static final double[] ANALYTIC_LOOKUP = new double[256];
    public final byte[] paletteMapping = new byte[32768];
    public final int[] paletteArray = new int[256];
    FloatArray curErrorRedFloats;
    FloatArray nextErrorRedFloats;
    FloatArray curErrorGreenFloats;
    FloatArray nextErrorGreenFloats;
    FloatArray curErrorBlueFloats;
    FloatArray nextErrorBlueFloats;
    public int colorCount;
    public IntIntMap reverseMap;
    protected float ditherStrength = 1.0f;
    protected float populationBias = 0.5f;
    private static final Comparator<IntIntMap.Entry> entryComparator;
    static final int[] thresholdMatrix8;
    static final int[] thresholdMatrix16;
    final int[] candidates = new int[32];

    public static int shrink(int color) {
        return color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F;
    }

    public static int stretch(int color) {
        return color << 17 & 0xF8000000 | color << 12 & 0x7000000 | color << 14 & 0xF80000 | color << 9 & 0x70000 | color << 11 & 0xF800 | color << 6 & 0x700 | 0xFF;
    }

    public static float forwardLight(float L) {
        float shape = 0.64516133f;
        float turning = 0.95f;
        float d = 0.95f - L;
        float r = d < 0.0f ? 0.050000012f * (L - 1.0f) / (1.0f - (L + 0.64516133f * d)) + 1.0f : 0.95f * L / (1.0E-20f + (L + 0.64516133f * d));
        return r * r;
    }

    public static float reverseLight(float L) {
        L = (float)Math.sqrt(L);
        float shape = 1.55f;
        float turning = 0.95f;
        float d = 0.95f - L;
        float r = d < 0.0f ? 0.050000012f * (L - 1.0f) / (1.0f - (L + 1.55f * d)) + 1.0f : 0.95f * L / (1.0E-20f + (L + 1.55f * d));
        return r;
    }

    public int iptToRgb(double i, double p, double t, double a) {
        double lPrime = i + 0.0650395 * p + 0.1539195 * t;
        double mPrime = i - 0.07591241 * p + 0.09991275 * t;
        double sPrime = i + 0.02174116 * p - 0.5076675 * t;
        double l = Math.copySign(Math.pow(Math.abs(lPrime), 2.3256), lPrime);
        double m = Math.copySign(Math.pow(Math.abs(mPrime), 2.3256), mPrime);
        double s = Math.copySign(Math.pow(Math.abs(sPrime), 2.3256), sPrime);
        int r = (int)(Math.sqrt(Math.min(Math.max(5.432622 * l - 4.6791 * m + 0.246257 * s, 0.0), 1.0)) * 255.99999);
        int g = (int)(Math.sqrt(Math.min(Math.max(-1.10517 * l + 2.311198 * m - 0.20588 * s, 0.0), 1.0)) * 255.99999);
        int b = (int)(Math.sqrt(Math.min(Math.max(0.028104 * l - 0.19466 * m + 1.166325 * s, 0.0), 1.0)) * 255.99999);
        return r << 24 | g << 16 | b << 8 | (int)(a * 255.9999999999);
    }

    public static int oklabToRGB(float L, float A, float B, float alpha) {
        L = PaletteReducer.forwardLight(L);
        float l = L + 0.39633778f * A + 0.21580376f * B;
        float m = L - 0.105561346f * A - 0.06385417f * B;
        float s = L - 0.08948418f * A - 1.2914855f * B;
        l *= l * l;
        m *= m * m;
        s *= s * s;
        int r = (int)(Math.sqrt(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f)) * (double)255.999f);
        int g = (int)(Math.sqrt(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f)) * (double)255.999f);
        int b = (int)(Math.sqrt(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f)) * (double)255.999f);
        return r << 24 | g << 16 | b << 8 | (int)(alpha * 255.999f);
    }

    public void writePreloadFile(FileHandle file) {
        file.writeBytes(this.paletteMapping, false);
    }

    public static byte[] loadPreloadFile(FileHandle file) {
        return file.readBytes();
    }

    public PaletteReducer() {
        this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
    }

    public PaletteReducer(int[] rgbaPalette) {
        if (rgbaPalette == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.exact(rgbaPalette);
    }

    public PaletteReducer(int[] rgbaPalette, int limit) {
        if (rgbaPalette == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.exact(rgbaPalette, limit);
    }

    public PaletteReducer(Color[] colorPalette) {
        if (colorPalette == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.exact(colorPalette);
    }

    public PaletteReducer(Color[] colorPalette, int limit) {
        if (colorPalette == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.exact(colorPalette, limit);
    }

    public PaletteReducer(Pixmap pixmap) {
        if (pixmap == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.analyze(pixmap);
    }

    public PaletteReducer(Array<Pixmap> pixmaps) {
        if (pixmaps == null) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        this.analyze(pixmaps);
    }

    public PaletteReducer(int[] palette, byte[] preload) {
        this.exact(palette, preload);
    }

    public PaletteReducer(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold);
    }

    public double differenceMatch(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double differenceAnalyzing(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double differenceMatch(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double differenceAnalyzing(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double differenceMatch(int r1, int g1, int b1, int r2, int g2, int b2) {
        double rf = (EXACT_LOOKUP[r1] - EXACT_LOOKUP[r2]) * 1.55;
        double gf = (EXACT_LOOKUP[g1] - EXACT_LOOKUP[g2]) * 2.05;
        double bf = (EXACT_LOOKUP[b1] - EXACT_LOOKUP[b2]) * 0.9;
        return (rf * rf + gf * gf + bf * bf) * 196608.0;
    }

    public double differenceAnalyzing(int r1, int g1, int b1, int r2, int g2, int b2) {
        double rf = ANALYTIC_LOOKUP[r1] - ANALYTIC_LOOKUP[r2];
        double gf = ANALYTIC_LOOKUP[g1] - ANALYTIC_LOOKUP[g2];
        double bf = ANALYTIC_LOOKUP[b1] - ANALYTIC_LOOKUP[b2];
        return (rf * rf + gf * gf + bf * bf) * 163840.0;
    }

    public void setDefaultPalette() {
        this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
    }

    public void exact(int[] rgbaPalette) {
        this.exact(rgbaPalette, 256);
    }

    public void exact(int[] rgbaPalette, int limit) {
        int plen;
        if (rgbaPalette == null || rgbaPalette.length < 2 || limit < 2) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        this.colorCount = plen = Math.min(Math.min(256, limit), rgbaPalette.length);
        this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        this.reverseMap = new IntIntMap(this.colorCount);
        for (int i = 0; i < plen; ++i) {
            int color = rgbaPalette[i];
            if ((color & 0x80) != 0) {
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                this.reverseMap.put(color, i);
                continue;
            }
            this.reverseMap.put(0, i);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = 2.147483647E9;
                    for (int i = 1; i < plen; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceMatch(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    public void exact(int[] palette, byte[] preload) {
        if (palette == null || preload == null) {
            System.arraycopy(HALTONIC, 0, this.paletteArray, 0, 256);
            System.arraycopy(ConstantData.ENCODED_HALTONIC, 0, this.paletteMapping, 0, 32768);
            this.colorCount = 256;
            this.populationBias = (float)Math.exp(-0.00439453125);
            for (int i = 0; i < this.colorCount; ++i) {
                this.reverseMap.put(this.paletteArray[i], i);
            }
            return;
        }
        this.colorCount = Math.min(256, palette.length);
        System.arraycopy(palette, 0, this.paletteArray, 0, this.colorCount);
        System.arraycopy(preload, 0, this.paletteMapping, 0, 32768);
        this.reverseMap = new IntIntMap(this.colorCount);
        for (int i = 0; i < this.colorCount; ++i) {
            this.reverseMap.put(this.paletteArray[i], i);
        }
        this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
    }

    public void exact(Color[] colorPalette) {
        this.exact(colorPalette, 256);
    }

    public void exact(Color[] colorPalette, int limit) {
        int plen;
        if (colorPalette == null || colorPalette.length < 2 || limit < 2) {
            this.exact(HALTONIC, ConstantData.ENCODED_HALTONIC);
            return;
        }
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        this.colorCount = plen = Math.min(Math.min(256, colorPalette.length), limit);
        this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        this.reverseMap = new IntIntMap(this.colorCount);
        for (int i = 0; i < plen; ++i) {
            int color;
            this.paletteArray[i] = color = Color.rgba8888((Color)colorPalette[i]);
            this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
            this.reverseMap.put(color, i);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = 2.147483647E9;
                    for (int i = 1; i < plen; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceMatch(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    public void analyze(Pixmap pixmap) {
        this.analyze(pixmap, 150.0);
    }

    public void analyze(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold, 256);
    }

    public void analyze(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.pow(limit, 1.35) * 1.6E-4;
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y);
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block4: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    if (this.differenceAnalyzing(color, this.paletteArray[j]) < threshold) continue block4;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        }
        if (this.reverseMap == null) {
            this.reverseMap = new IntIntMap(this.colorCount);
        } else {
            this.reverseMap.clear(this.colorCount);
        }
        for (i = 0; i < this.colorCount; ++i) {
            this.reverseMap.put(this.paletteArray[i], i);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i2 = 1; i2 < this.colorCount; ++i2) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(this.paletteArray[i2], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i2;
                    }
                }
            }
        }
    }

    public void analyzeFast(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.pow(limit, 1.35) * 1.6E-4;
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y);
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block4: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    if (this.differenceAnalyzing(color, this.paletteArray[j]) < threshold) continue block4;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        }
        if (this.reverseMap == null) {
            this.reverseMap = new IntIntMap(this.colorCount);
        } else {
            this.reverseMap.clear(this.colorCount);
        }
        for (i = 0; i < this.colorCount; ++i) {
            this.reverseMap.put(this.paletteArray[i], i);
        }
        if (this.colorCount <= 1) {
            return;
        }
        int numUnassigned = 1;
        int iterations = 0;
        byte[] buffer = Arrays.copyOf(this.paletteMapping, 32768);
        while (numUnassigned != 0) {
            numUnassigned = 0;
            for (int r = 0; r < 32; ++r) {
                for (int g = 0; g < 32; ++g) {
                    for (int b = 0; b < 32; ++b) {
                        byte bt;
                        int c2 = r << 10 | g << 5 | b;
                        if (buffer[c2] != 0) continue;
                        if (iterations++ != 2) {
                            byte bt2;
                            if (b < 31 && (bt2 = this.paletteMapping[c2 + 1]) != 0) {
                                buffer[c2] = bt2;
                                continue;
                            }
                            if (g < 31 && (bt = this.paletteMapping[c2 + 32]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (r < 31 && (bt = this.paletteMapping[c2 + 1024]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (b > 0 && (bt = this.paletteMapping[c2 - 1]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (g > 0 && (bt = this.paletteMapping[c2 - 32]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (r > 0 && (bt = this.paletteMapping[c2 - 1024]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            ++numUnassigned;
                            continue;
                        }
                        iterations = 0;
                        if (b < 31 && (bt = this.paletteMapping[c2 + 1]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && (bt = this.paletteMapping[c2 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (r < 31 && (bt = this.paletteMapping[c2 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && (bt = this.paletteMapping[c2 - 1]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && (bt = this.paletteMapping[c2 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (r > 0 && (bt = this.paletteMapping[c2 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && g < 31 && (bt = this.paletteMapping[c2 + 1 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && r < 31 && (bt = this.paletteMapping[c2 + 1 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && r < 31 && (bt = this.paletteMapping[c2 + 32 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && g > 0 && (bt = this.paletteMapping[c2 - 1 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && r > 0 && (bt = this.paletteMapping[c2 - 1 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && r > 0 && (bt = this.paletteMapping[c2 - 32 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && g > 0 && (bt = this.paletteMapping[c2 + 1 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && r > 0 && (bt = this.paletteMapping[c2 + 1 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && r > 0 && (bt = this.paletteMapping[c2 + 32 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && g < 31 && (bt = this.paletteMapping[c2 - 1 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && r < 31 && (bt = this.paletteMapping[c2 - 1 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && r < 31 && (bt = this.paletteMapping[c2 - 32 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        ++numUnassigned;
                    }
                }
            }
            System.arraycopy(buffer, 0, this.paletteMapping, 0, 32768);
        }
    }

    public void analyzeMC(Pixmap pixmap, int limit) {
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntArray bin = new IntArray(width * height);
        IntIntMap counts = new IntIntMap(limit);
        int hasTransparent = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y);
                if ((color & 0x80) != 0) {
                    color |= color >>> 5 & 0x7070700 | 0xFF;
                    bin.add(color);
                    counts.getAndIncrement(color, 0, 1);
                    continue;
                }
                hasTransparent = 1;
            }
        }
        if (counts.size > (limit = Math.max(2 - hasTransparent, Math.min(limit - hasTransparent, 256)))) {
            int i;
            double b;
            double g;
            double r;
            int numCuts = 32 - Integer.numberOfLeadingZeros(limit - 1);
            int end = bin.size;
            int[] in = bin.items;
            int[] out = new int[end];
            int[] bufR = new int[32];
            int[] bufG = new int[32];
            int[] bufB = new int[32];
            for (int stage = 0; stage < numCuts; ++stage) {
                int size = bin.size >>> stage;
                int offset = 0;
                end = 0;
                for (int part = 1 << stage; part > 0; --part) {
                    int rangeB;
                    int rangeG;
                    int r2;
                    int rangeR;
                    int i2;
                    end = part == 1 ? bin.size : (end += size);
                    Arrays.fill(bufR, 0);
                    Arrays.fill(bufG, 0);
                    Arrays.fill(bufB, 0);
                    for (i2 = offset; i2 < end; ++i2) {
                        int ii = in[i2];
                        int n = ii >>> 27;
                        bufR[n] = bufR[n] + 1;
                        int n2 = ii >>> 19 & 0x1F;
                        bufG[n2] = bufG[n2] + 1;
                        int n3 = ii >>> 11 & 0x1F;
                        bufB[n3] = bufB[n3] + 1;
                    }
                    for (rangeR = 32; rangeR > 0 && bufR[rangeR - 1] == 0; --rangeR) {
                    }
                    for (r2 = 0; r2 < rangeR && bufR[r2] == 0; ++r2, --rangeR) {
                    }
                    for (rangeG = 32; rangeG > 0 && bufG[rangeG - 1] == 0; --rangeG) {
                    }
                    for (r2 = 0; r2 < rangeG && bufG[r2] == 0; ++r2, --rangeG) {
                    }
                    for (rangeB = 32; rangeB > 0 && bufB[rangeB - 1] == 0; --rangeB) {
                    }
                    for (r2 = 0; r2 < rangeB && bufB[r2] == 0; ++r2, --rangeB) {
                    }
                    if (rangeG >= rangeR && rangeG >= rangeB) {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufG[n] = bufG[n] + bufG[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 19 & 0x1F;
                            int n4 = bufG[n] - 1;
                            bufG[n] = n4;
                            out[offset + n4] = in[i2];
                        }
                    } else if (rangeR >= rangeG && rangeR >= rangeB) {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufR[n] = bufR[n] + bufR[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 27;
                            int n5 = bufR[n] - 1;
                            bufR[n] = n5;
                            out[offset + n5] = in[i2];
                        }
                    } else {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufB[n] = bufB[n] + bufB[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 11 & 0x1F;
                            int n6 = bufB[n] - 1;
                            bufB[n] = n6;
                            out[offset + n6] = in[i2];
                        }
                    }
                    offset += size;
                }
            }
            int jump = out.length >>> numCuts;
            int mid = 0;
            int assigned = 0;
            double fr = 270.0 / ((double)jump * 31.0);
            int n = (1 << numCuts) - 1;
            while (assigned < n) {
                r = 0.0;
                g = 0.0;
                b = 0.0;
                for (int i3 = mid + jump - 1; i3 >= mid; --i3) {
                    color = out[i3];
                    r += (double)(color >>> 27);
                    g += (double)(color >>> 19 & 0x1F);
                    b += (double)(color >>> 11 & 0x1F);
                }
                this.paletteArray[assigned] = Math.min(Math.max((int)((r - 7.0) * fr), 0), 255) << 24 | Math.min(Math.max((int)((g - 7.0) * fr), 0), 255) << 16 | Math.min(Math.max((int)((b - 7.0) * fr), 0), 255) << 8 | 0xFF;
                ++assigned;
                mid += jump;
            }
            int j2 = out.length - (mid - jump);
            r = 0.0;
            g = 0.0;
            b = 0.0;
            double fr2 = 270.0 / ((double)j2 * 31.0);
            for (int i4 = out.length - 1; i4 >= mid; --i4) {
                color = out[i4];
                r += (double)(color >>> 27);
                g += (double)(color >>> 19 & 0x1F);
                b += (double)(color >>> 11 & 0x1F);
            }
            this.paletteArray[assigned++] = Math.min(Math.max((int)((r - 7.0) * fr2), 0), 255) << 24 | Math.min(Math.max((int)((g - 7.0) * fr2), 0), 255) << 16 | Math.min(Math.max((int)((b - 7.0) * fr2), 0), 255) << 8 | 0xFF;
            block20: for (i = limit; i < assigned; ++i) {
                int currentCount = counts.get(this.paletteArray[i], 0);
                for (int j = 0; j < limit; ++j) {
                    if (counts.get(this.paletteArray[j], 0) >= currentCount) continue;
                    int temp = this.paletteArray[j];
                    this.paletteArray[j] = this.paletteArray[i];
                    this.paletteArray[i] = temp;
                    continue block20;
                }
            }
            if (hasTransparent == 1) {
                int min = Integer.MAX_VALUE;
                int worst = 0;
                for (int i5 = 0; i5 < limit; ++i5) {
                    int currentCount = counts.get(this.paletteArray[i5], 0);
                    if (currentCount >= min) continue;
                    min = currentCount;
                    worst = i5;
                }
                if (worst != 0) {
                    this.paletteArray[worst] = this.paletteArray[0];
                }
                this.paletteArray[0] = 0;
            }
            for (i = hasTransparent; i < limit; ++i) {
                color = this.paletteArray[i];
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
            }
            this.colorCount = limit;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        } else {
            IntIntMap.Keys it = counts.keys();
            Arrays.fill(this.paletteArray, 0);
            for (int i = hasTransparent; i < limit && it.hasNext; ++i) {
                this.paletteArray[i] = color = it.next();
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
            }
            this.colorCount = counts.size + hasTransparent;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        }
        this.reverseMap = new IntIntMap(this.colorCount);
        for (int i = 0; i < this.colorCount; ++i) {
            this.reverseMap.put(this.paletteArray[i], i);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.POSITIVE_INFINITY;
                    for (int i = 1; i < this.colorCount; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    public int blend(int rgba1, int rgba2, double preference) {
        int a1 = rgba1 & 0xFF;
        int a2 = rgba2 & 0xFF;
        if ((a1 & 0x80) == 0) {
            return rgba2;
        }
        if ((a2 & 0x80) == 0) {
            return rgba1;
        }
        rgba1 = PaletteReducer.shrink(rgba1);
        rgba2 = PaletteReducer.shrink(rgba2);
        double i = IPT[0][rgba1] + (IPT[0][rgba2] - IPT[0][rgba1]) * preference;
        double p = IPT[1][rgba1] + (IPT[1][rgba2] - IPT[1][rgba1]) * preference;
        double t = IPT[2][rgba1] + (IPT[2][rgba2] - IPT[2][rgba1]) * preference;
        double lPrime = i + 0.0650395 * p + 0.1539195 * t;
        double mPrime = i - 0.07591241 * p + 0.09991275 * t;
        double sPrime = i + 0.02174116 * p - 0.5076675 * t;
        double l = Math.copySign(Math.pow(Math.abs(lPrime), 2.3256), lPrime);
        double m = Math.copySign(Math.pow(Math.abs(mPrime), 2.3256), mPrime);
        double s = Math.copySign(Math.pow(Math.abs(sPrime), 2.3256), sPrime);
        int r = (int)(Math.sqrt(Math.min(Math.max(5.432622 * l - 4.6791 * m + 0.246257 * s, 0.0), 1.0)) * 255.99999);
        int g = (int)(Math.sqrt(Math.min(Math.max(-1.10517 * l + 2.311198 * m - 0.20588 * s, 0.0), 1.0)) * 255.99999);
        int b = (int)(Math.sqrt(Math.min(Math.max(0.028104 * l - 0.19466 * m + 1.166325 * s, 0.0), 1.0)) * 255.99999);
        int a = a1 + a2 + 1 >>> 1;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void analyze(Array<Pixmap> pixmaps) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, 150.0, 256);
    }

    public void analyze(Array<Pixmap> pixmaps, double threshold) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, 256);
    }

    public void analyze(Array<Pixmap> pixmaps, double threshold, int limit) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, limit);
    }

    public void analyze(Pixmap[] pixmaps, int pixmapCount, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.pow(limit, 1.35) * 1.6E-4;
        IntIntMap counts = new IntIntMap(limit);
        int[] reds = new int[limit];
        int[] greens = new int[limit];
        int[] blues = new int[limit];
        for (int i2 = 0; i2 < pixmapCount && i2 < pixmaps.length; ++i2) {
            Pixmap pixmap = pixmaps[i2];
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    color = pixmap.getPixel(x, y);
                    if ((color & 0x80) == 0) continue;
                    color |= color >>> 5 & 0x7070700 | 0xFF;
                    counts.getAndIncrement(color, 0, 1);
                }
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block5: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    double diff = this.differenceAnalyzing(color, this.paletteArray[j]);
                    if (diff < threshold) continue block5;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.125 / (double)this.colorCount);
        }
        this.reverseMap = new IntIntMap(this.colorCount);
        for (i = 0; i < this.colorCount; ++i) {
            this.reverseMap.put(this.paletteArray[i], i);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i3 = 1; i3 < this.colorCount; ++i3) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(reds[i3], greens[i3], blues[i3], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i3;
                    }
                }
            }
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    public Pixmap reduce(Pixmap pixmap) {
        return this.reduceNeue(pixmap);
    }

    public Pixmap reduce(Pixmap pixmap, Dithered.DitherAlgorithm ditherAlgorithm) {
        if (pixmap == null) {
            return null;
        }
        if (ditherAlgorithm == null) {
            return this.reduceScatter(pixmap);
        }
        switch (ditherAlgorithm) {
            case NONE: {
                return this.reduceSolid(pixmap);
            }
            case GRADIENT_NOISE: {
                return this.reduceJimenez(pixmap);
            }
            case PATTERN: {
                return this.reduceKnoll(pixmap);
            }
            case CHAOTIC_NOISE: {
                return this.reduceChaoticNoise(pixmap);
            }
            case DIFFUSION: {
                return this.reduceFloydSteinberg(pixmap);
            }
            case BLUE_NOISE: {
                return this.reduceBlueNoise(pixmap);
            }
            case SCATTER: {
                return this.reduceScatter(pixmap);
            }
        }
        return this.reduceNeue(pixmap);
    }

    public Pixmap reduceSolid(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceSierraLite(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            for (int i = 0; i < lineLen; ++i) {
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float ditherStrength = this.ditherStrength * 20.0f;
        float halfDitherStrength = ditherStrength * 0.5f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            for (int i = 0; i < lineLen; ++i) {
                curErrorRed[i] = nextErrorRed[i];
                curErrorGreen[i] = nextErrorGreen[i];
                curErrorBlue[i] = nextErrorBlue[i];
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = OtherMath.cbrtShape(0.0087890625f * (float)((color >>> 24) - (used >>> 24)));
                float gdiff = OtherMath.cbrtShape(0.0087890625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                float bdiff = OtherMath.cbrtShape(0.0087890625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * ditherStrength;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * ditherStrength;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * ditherStrength;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * halfDitherStrength;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * halfDitherStrength;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * halfDitherStrength;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * halfDitherStrength;
                int n6 = px;
                nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * halfDitherStrength;
                int n7 = px;
                nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * halfDitherStrength;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceFloydSteinberg(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            for (int i = 0; i < lineLen; ++i) {
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 4.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            for (int i = 0; i < lineLen; ++i) {
                curErrorRed[i] = nextErrorRed[i];
                curErrorGreen[i] = nextErrorGreen[i];
                curErrorBlue[i] = nextErrorBlue[i];
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 24) - (used >>> 24)));
                float gdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                float bdiff = OtherMath.cbrtShape(0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceJimenez(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float strength = this.ditherStrength * this.populationBias * 3.0f;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                int used = this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                float pos = (float)px * 0.06711056f + (float)y * 0.00583715f;
                pos -= (float)((int)pos);
                pos *= 52.982918f;
                pos -= (float)((int)pos);
                float adj = (pos - 0.5f) * strength;
                rr = Math.min(Math.max((int)((float)rr + adj * (float)(rr - (used >>> 24))), 0), 255);
                gg = Math.min(Math.max((int)((float)gg + adj * (float)(gg - (used >>> 16 & 0xFF))), 0), 255);
                bb = Math.min(Math.max((int)((float)bb + adj * (float)(bb - (used >>> 8 & 0xFF))), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceBlueNoise(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float strength = 48.0f * this.ditherStrength / this.populationBias;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float adj = ((float)TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007f;
                int rr = MathUtils.clamp((int)((int)((adj *= strength + (float)(px + y << 3 & 0x18) - 12.0f) + (float)(color >>> 24))), (int)0, (int)255);
                int gg = MathUtils.clamp((int)((int)(adj + (float)(color >>> 16 & 0xFF))), (int)0, (int)255);
                int bb = MathUtils.clamp((int)((int)(adj + (float)(color >>> 8 & 0xFF))), (int)0, (int)255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceChaoticNoise(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        double strength = (double)(this.ditherStrength * this.populationBias) * 1.5;
        long s = -4521708957497675121L;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                int used = this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                double adj = ((float)TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                adj *= adj * adj;
                long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                s = (s ^ (long)color) * -3372029247567499371L + -7935046062780286179L;
                rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceScatter(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            for (int i = 0; i < lineLen; ++i) {
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 3.5f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            for (int i = 0; i < lineLen; ++i) {
                curErrorRed[i] = nextErrorRed[i];
                curErrorGreen[i] = nextErrorGreen[i];
                curErrorBlue[i] = nextErrorBlue[i];
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float tbn = TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                float er = curErrorRed[px] * tbn;
                float eg = curErrorGreen[px] * tbn;
                float eb = curErrorBlue[px] * tbn;
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 24) - (used >>> 24)));
                float gdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                float bdiff = OtherMath.cbrtShape(0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceNeue(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            for (int i = 0; i < lineLen; ++i) {
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 7.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 32.0f * this.ditherStrength / (this.populationBias * this.populationBias);
        float limit = (float)Math.pow(80.0, 1.635 - (double)this.populationBias);
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            for (int i = 0; i < lineLen; ++i) {
                curErrorRed[i] = nextErrorRed[i];
                curErrorGreen[i] = nextErrorGreen[i];
                curErrorBlue[i] = nextErrorBlue[i];
                nextErrorRed[i] = 0.0f;
                nextErrorGreen[i] = 0.0f;
                nextErrorBlue[i] = 0.0f;
            }
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float adj = ((float)TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                adj = Math.min(Math.max(adj * strength, -limit), limit);
                float er = adj + curErrorRed[px];
                float eg = adj + curErrorGreen[px];
                float eb = adj + curErrorBlue[px];
                int rr = MathUtils.clamp((int)((int)((float)(color >>> 24) + er + 0.5f)), (int)0, (int)255);
                int gg = MathUtils.clamp((int)((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f)), (int)0, (int)255);
                int bb = MathUtils.clamp((int)((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f)), (int)0, (int)255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                float rdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 24) - (used >>> 24)));
                float gdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)));
                float bdiff = OtherMath.cbrtShape(0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    protected static void compareSwap(int[] ints, int a, int b) {
        if (OKLAB[0][ints[a | 0x10]] > OKLAB[0][ints[b | 0x10]]) {
            int t = ints[a];
            int st = ints[a | 0x10];
            ints[a] = ints[b];
            ints[a | 0x10] = ints[b | 0x10];
            ints[b] = t;
            ints[b | 0x10] = st;
        }
    }

    static void sort8(int[] i8) {
        PaletteReducer.compareSwap(i8, 0, 1);
        PaletteReducer.compareSwap(i8, 2, 3);
        PaletteReducer.compareSwap(i8, 0, 2);
        PaletteReducer.compareSwap(i8, 1, 3);
        PaletteReducer.compareSwap(i8, 1, 2);
        PaletteReducer.compareSwap(i8, 4, 5);
        PaletteReducer.compareSwap(i8, 6, 7);
        PaletteReducer.compareSwap(i8, 4, 6);
        PaletteReducer.compareSwap(i8, 5, 7);
        PaletteReducer.compareSwap(i8, 5, 6);
        PaletteReducer.compareSwap(i8, 0, 4);
        PaletteReducer.compareSwap(i8, 1, 5);
        PaletteReducer.compareSwap(i8, 1, 4);
        PaletteReducer.compareSwap(i8, 2, 6);
        PaletteReducer.compareSwap(i8, 3, 7);
        PaletteReducer.compareSwap(i8, 3, 6);
        PaletteReducer.compareSwap(i8, 2, 4);
        PaletteReducer.compareSwap(i8, 3, 5);
        PaletteReducer.compareSwap(i8, 3, 4);
    }

    static void sort16(int[] i16) {
        PaletteReducer.compareSwap(i16, 0, 1);
        PaletteReducer.compareSwap(i16, 2, 3);
        PaletteReducer.compareSwap(i16, 4, 5);
        PaletteReducer.compareSwap(i16, 6, 7);
        PaletteReducer.compareSwap(i16, 8, 9);
        PaletteReducer.compareSwap(i16, 10, 11);
        PaletteReducer.compareSwap(i16, 12, 13);
        PaletteReducer.compareSwap(i16, 14, 15);
        PaletteReducer.compareSwap(i16, 0, 2);
        PaletteReducer.compareSwap(i16, 4, 6);
        PaletteReducer.compareSwap(i16, 8, 10);
        PaletteReducer.compareSwap(i16, 12, 14);
        PaletteReducer.compareSwap(i16, 1, 3);
        PaletteReducer.compareSwap(i16, 5, 7);
        PaletteReducer.compareSwap(i16, 9, 11);
        PaletteReducer.compareSwap(i16, 13, 15);
        PaletteReducer.compareSwap(i16, 0, 4);
        PaletteReducer.compareSwap(i16, 8, 12);
        PaletteReducer.compareSwap(i16, 1, 5);
        PaletteReducer.compareSwap(i16, 9, 13);
        PaletteReducer.compareSwap(i16, 2, 6);
        PaletteReducer.compareSwap(i16, 10, 14);
        PaletteReducer.compareSwap(i16, 3, 7);
        PaletteReducer.compareSwap(i16, 11, 15);
        PaletteReducer.compareSwap(i16, 0, 8);
        PaletteReducer.compareSwap(i16, 1, 9);
        PaletteReducer.compareSwap(i16, 2, 10);
        PaletteReducer.compareSwap(i16, 3, 11);
        PaletteReducer.compareSwap(i16, 4, 12);
        PaletteReducer.compareSwap(i16, 5, 13);
        PaletteReducer.compareSwap(i16, 6, 14);
        PaletteReducer.compareSwap(i16, 7, 15);
        PaletteReducer.compareSwap(i16, 5, 10);
        PaletteReducer.compareSwap(i16, 6, 9);
        PaletteReducer.compareSwap(i16, 3, 12);
        PaletteReducer.compareSwap(i16, 13, 14);
        PaletteReducer.compareSwap(i16, 7, 11);
        PaletteReducer.compareSwap(i16, 1, 2);
        PaletteReducer.compareSwap(i16, 4, 8);
        PaletteReducer.compareSwap(i16, 1, 4);
        PaletteReducer.compareSwap(i16, 7, 13);
        PaletteReducer.compareSwap(i16, 2, 8);
        PaletteReducer.compareSwap(i16, 11, 14);
        PaletteReducer.compareSwap(i16, 2, 4);
        PaletteReducer.compareSwap(i16, 5, 6);
        PaletteReducer.compareSwap(i16, 9, 10);
        PaletteReducer.compareSwap(i16, 11, 13);
        PaletteReducer.compareSwap(i16, 3, 8);
        PaletteReducer.compareSwap(i16, 7, 12);
        PaletteReducer.compareSwap(i16, 6, 8);
        PaletteReducer.compareSwap(i16, 10, 12);
        PaletteReducer.compareSwap(i16, 3, 5);
        PaletteReducer.compareSwap(i16, 7, 9);
        PaletteReducer.compareSwap(i16, 3, 4);
        PaletteReducer.compareSwap(i16, 5, 6);
        PaletteReducer.compareSwap(i16, 7, 8);
        PaletteReducer.compareSwap(i16, 9, 10);
        PaletteReducer.compareSwap(i16, 11, 12);
        PaletteReducer.compareSwap(i16, 6, 7);
        PaletteReducer.compareSwap(i16, 8, 9);
    }

    public Pixmap reduceKnoll(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float errorMul = this.ditherStrength * this.populationBias;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int er = 0;
                int eg = 0;
                int eb = 0;
                int cr = color >>> 24;
                int cg = color >>> 16 & 0xFF;
                int cb = color >>> 8 & 0xFF;
                for (int i = 0; i < 16; ++i) {
                    int used;
                    int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                    int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                    int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                    int usedIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                    this.candidates[i] = used = this.paletteArray[usedIndex];
                    this.candidates[i | 0x10] = PaletteReducer.shrink(used);
                    er += cr - (used >>> 24);
                    eg += cg - (used >>> 16 & 0xFF);
                    eb += cb - (used >>> 8 & 0xFF);
                }
                PaletteReducer.sort16(this.candidates);
                pixmap.drawPixel(px, y, this.candidates[thresholdMatrix16[px & 3 | (y & 3) << 2]]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceKnollRoberts(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float errorMul = this.ditherStrength * this.populationBias * 1.25f;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int er = 0;
                int eg = 0;
                int eb = 0;
                int cr = color >>> 24;
                int cg = color >>> 16 & 0xFF;
                int cb = color >>> 8 & 0xFF;
                for (int c = 0; c < 8; ++c) {
                    int used;
                    int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                    int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                    int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                    int usedIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                    this.candidates[c] = used = this.paletteArray[usedIndex];
                    this.candidates[c | 0x10] = PaletteReducer.shrink(used);
                    er += cr - (used >>> 24);
                    eg += cg - (used >>> 16 & 0xFF);
                    eb += cb - (used >>> 8 & 0xFF);
                }
                PaletteReducer.sort8(this.candidates);
                pixmap.drawPixel(px, y, this.candidates[thresholdMatrix8[(int)((double)px * 14.039021329973542 + (double)y * 0.4045084971874737) & 3 ^ (px & 3 | (y & 1) << 2)]]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public byte randomColorIndex(Random random) {
        return this.paletteMapping[random.nextInt() >>> 17];
    }

    public int randomColor(Random random) {
        return this.paletteArray[this.paletteMapping[random.nextInt() >>> 17] & 0xFF];
    }

    public int reduceSingle(int color) {
        if ((color & 0x80) == 0) {
            return 0;
        }
        return this.paletteArray[this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] & 0xFF];
    }

    public byte reduceIndex(int color) {
        if ((color & 0x80) == 0) {
            return 0;
        }
        return this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F];
    }

    public float reduceFloat(float packedColor) {
        int color = NumberUtils.floatToIntBits((float)packedColor);
        if (color >= 0) {
            return 0.0f;
        }
        return NumberUtils.intBitsToFloat((int)Integer.reverseBytes(this.paletteArray[this.paletteMapping[color << 7 & 0x7C00 | color >>> 6 & 0x3E0 | color >>> 19] & 0xFF] & 0xFFFFFFFE));
    }

    public Color reduceInPlace(Color color) {
        if (color.a < 0.5f) {
            return color.set(0);
        }
        return color.set(this.paletteArray[this.paletteMapping[(int)((double)color.r * 32256.0) & 0x7C00 | (int)((double)color.g * 1008.0) & 0x3E0 | (int)((double)color.r * 31.5)] & 0xFF]);
    }

    public PaletteReducer alterColorsLightness(Interpolation lightness) {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            palette[idx] = PaletteReducer.oklabToRGB(lightness.apply(OKLAB[0][s]), OKLAB[1][s], OKLAB[2][s], (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    public PaletteReducer alterColorsIPT(Interpolation lightness, Interpolation greenToRed, Interpolation blueToYellow) {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            double i = lightness.apply((float)IPT[0][s]);
            double p = greenToRed.apply(-1.0f, 1.0f, (float)IPT[1][s] * 0.5f + 0.5f);
            double t = blueToYellow.apply(-1.0f, 1.0f, (float)IPT[2][s] * 0.5f + 0.5f);
            palette[idx] = this.iptToRgb(i, p, t, (float)(palette[idx] >>> 1 & 0x7F) / 127.0f);
        }
        return this;
    }

    public PaletteReducer alterColorsOklab(Interpolation lightness, Interpolation greenToRed, Interpolation blueToYellow) {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            float L = lightness.apply(OKLAB[0][s]);
            float A = greenToRed.apply(-1.0f, 1.0f, OKLAB[1][s] * 0.5f + 0.5f);
            float B = blueToYellow.apply(-1.0f, 1.0f, OKLAB[2][s] * 0.5f + 0.5f);
            palette[idx] = PaletteReducer.oklabToRGB(L, A, B, (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    public PaletteReducer hueShift() {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            float L = OKLAB[0][s];
            float A = OKLAB[1][s] + (L - 0.5f) * 0.04f;
            float B = OKLAB[2][s] + (L - 0.5f) * 0.08f;
            palette[idx] = PaletteReducer.oklabToRGB(L, A, B, (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    static {
        int idx = 0;
        for (int ri = 0; ri < 32; ++ri) {
            double r = (double)(ri * ri) * 0.0010405827263267429;
            float rf = (float)r;
            for (int gi = 0; gi < 32; ++gi) {
                double g = (double)(gi * gi) * 0.0010405827263267429;
                float gf = (float)g;
                for (int bi = 0; bi < 32; ++bi) {
                    double b = (double)(bi * bi) * 0.0010405827263267429;
                    float bf = (float)b;
                    double l = Math.pow(0.313921 * r + 0.639468 * g + 0.046597 * b, 0.43);
                    double m = Math.pow(0.151693 * r + 0.748209 * g + 0.1000044 * b, 0.43);
                    double s = Math.pow(0.017753 * r + 0.109468 * g + 0.872969 * b, 0.43);
                    PaletteReducer.IPT[0][idx] = 0.4 * l + 0.4 * m + 0.2 * s;
                    PaletteReducer.IPT[1][idx] = 4.455 * l - 4.851 * m + 0.396 * s;
                    PaletteReducer.IPT[2][idx] = 0.8056 * l + 0.3572 * m - 1.1628 * s;
                    float lf = OtherMath.cbrt(0.4121656f * rf + 0.5362752f * gf + 0.051457565f * bf);
                    float mf = OtherMath.cbrt(0.2118591f * rf + 0.68071896f * gf + 0.10740658f * bf);
                    float sf = OtherMath.cbrt(0.088309795f * rf + 0.28184742f * gf + 0.63026136f * bf);
                    PaletteReducer.OKLAB[0][idx] = PaletteReducer.forwardLight(0.21045426f * lf + 0.7936178f * mf - 0.004072047f * sf);
                    PaletteReducer.OKLAB[1][idx] = 1.9779985f * lf - 2.4285922f * mf + 0.4505937f * sf;
                    PaletteReducer.OKLAB[2][idx] = 0.025904037f * lf + 0.78277177f * mf - 0.80867577f * sf;
                    ++idx;
                }
            }
        }
        for (int i = 1; i < 256; ++i) {
            PaletteReducer.EXACT_LOOKUP[i] = OtherMath.barronSpline((float)i / 255.0f, 4.0f, 0.5f);
            PaletteReducer.ANALYTIC_LOOKUP[i] = OtherMath.barronSpline((float)i / 255.0f, 3.0f, 0.5f);
        }
        entryComparator = new Comparator<IntIntMap.Entry>(){

            @Override
            public int compare(IntIntMap.Entry o1, IntIntMap.Entry o2) {
                return o2.value - o1.value;
            }
        };
        thresholdMatrix8 = new int[]{0, 4, 2, 6, 3, 7, 1, 5};
        thresholdMatrix16 = new int[]{0, 12, 3, 15, 8, 4, 11, 7, 2, 14, 1, 13, 10, 6, 9, 5};
    }
}

