/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.anim8.AnimationWriter;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.LZWEncoder;
import com.github.tommyettinger.anim8.OtherMath;
import com.github.tommyettinger.anim8.PaletteReducer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class AnimatedGif
implements AnimationWriter,
Dithered {
    protected Dithered.DitherAlgorithm ditherAlgorithm = Dithered.DitherAlgorithm.OVERBOARD;
    protected int width;
    protected int height;
    protected int x = 0;
    protected int y = 0;
    protected boolean flipY = true;
    protected int transIndex = -1;
    protected int repeat = 0;
    protected int delay = 16;
    protected boolean started = false;
    protected OutputStream out;
    protected Pixmap image;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int seq = 0;
    protected boolean clearPalette;
    public boolean fastAnalysis = true;
    public PaletteReducer palette;
    protected float ditherStrength = 1.0f;

    @Override
    public void write(FileHandle file, Array<Pixmap> frames) {
        this.write(file, frames, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileHandle file, Array<Pixmap> frames, int fps) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, fps);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps) {
        if (frames == null || frames.isEmpty()) {
            return;
        }
        boolean bl = this.clearPalette = this.palette == null;
        if (this.clearPalette) {
            if (this.fastAnalysis && frames.size > 1) {
                this.palette = new PaletteReducer();
                this.palette.analyzeFast((Pixmap)frames.first(), 300.0, 256);
            } else {
                this.palette = new PaletteReducer((Pixmap)frames.first());
            }
        }
        if (!this.start(output)) {
            return;
        }
        this.setFrameRate(fps);
        for (int i = 0; i < frames.size; ++i) {
            this.addFrame((Pixmap)frames.get(i));
        }
        this.finish();
        if (this.clearPalette) {
            this.palette = null;
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    @Override
    public PaletteReducer getPalette() {
        return this.palette;
    }

    @Override
    public void setPalette(PaletteReducer palette) {
        this.palette = palette;
    }

    public void setDelay(int ms) {
        this.delay = ms;
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    @Override
    public Dithered.DitherAlgorithm getDitherAlgorithm() {
        return this.ditherAlgorithm;
    }

    @Override
    public void setDitherAlgorithm(Dithered.DitherAlgorithm ditherAlgorithm) {
        if (ditherAlgorithm != null) {
            this.ditherAlgorithm = ditherAlgorithm;
        }
    }

    public boolean addFrame(Pixmap im) {
        if (im == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            ++this.seq;
            this.image = im;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException e) {
            ok = false;
        }
        return ok;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.transIndex = -1;
        this.out = null;
        this.image = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.sizeSet = false;
        this.firstFrame = true;
        this.seq = 0;
        return ok;
    }

    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            this.delay = (int)(1000.0f / fps);
        }
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean start(OutputStream os) {
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
            Gdx.app.error("anim8", e.getMessage());
        }
        this.started = ok;
        return this.started;
    }

    protected void analyzeNone() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    this.indexedPixels[i] = paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzePattern() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float errorMul = this.palette.ditherStrength * 0.5f / this.palette.populationBias;
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    int er = 0;
                    int eg = 0;
                    int eb = 0;
                    int cr = color >>> 24;
                    int cg = color >>> 16 & 0xFF;
                    int cb = color >>> 8 & 0xFF;
                    for (int c = 0; c < 16; ++c) {
                        int usedIndex;
                        int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                        int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                        int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                        this.palette.candidates[c] = usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                        int used = paletteArray[this.palette.candidates[c]];
                        this.palette.candidates[c | 0x10] = PaletteReducer.shrink(used);
                        er += cr - (used >>> 24);
                        eg += cg - (used >>> 16 & 0xFF);
                        eb += cb - (used >>> 8 & 0xFF);
                    }
                    PaletteReducer.sort16(this.palette.candidates);
                    this.indexedPixels[i] = (byte)this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeChaotic() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
        long s = -4521708957497675121L * (long)this.seq;
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    int used = paletteArray[paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                    double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                    adj *= adj * adj;
                    long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                    s = (s ^ (long)(rr + gg + bb)) * -3372029247567499371L + -7935046062780286179L;
                    rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                    gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                    bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                    this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeGradient() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    float adj = (float)px * 0.06711056f + (float)y * 0.00583715f;
                    adj -= (float)((int)adj);
                    adj *= 52.982918f;
                    adj -= (float)((int)adj);
                    adj = (adj - 0.5f) * strength;
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + adj), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + adj), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + adj), 0), 255);
                    this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeRoberts() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float populationBias = this.palette.populationBias;
        float str = 32.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    float theta = (float)((long)px * -4521708957497675121L + (long)y * -7935046062780286179L >>> 41) * 7.490141E-7f;
                    rr = Math.min(Math.max((int)((float)rr + MathUtils.cos((float)theta) * str + 0.5f), 0), 255);
                    gg = Math.min(Math.max((int)((float)gg + MathUtils.cos((float)(theta + 1.04f)) * str + 0.5f), 0), 255);
                    bb = Math.min(Math.max((int)((float)bb + MathUtils.cos((float)(theta + 2.09f)) * str + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeLoaf() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float strength = this.ditherStrength * this.palette.populationBias;
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    int adj = (int)((float)(((px + y & 1) << 5) - 16) * strength);
                    int rr = Math.min(Math.max((color >>> 24) + adj, 0), 255);
                    int gg = Math.min(Math.max((color >>> 16 & 0xFF) + adj, 0), 255);
                    int bb = Math.min(Math.max((color >>> 8 & 0xFF) + adj, 0), 255);
                    int rgb555 = rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3;
                    this.indexedPixels[i] = paletteMapping[rgb555];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeDiffusion() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float w1 = this.palette.ditherStrength * 4.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    byte paletteIndex;
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[paletteIndex & 0xFF] = true;
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.005859375f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                    gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                    bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny < this.height) {
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeBlue() {
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * OtherMath.cbrtPositive(this.palette.colorCount));
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, flipped + flipDir * y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    float adj = (float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    rr = Math.min(Math.max((int)(adj + (float)rr + 0.5f), 0), 255);
                    adj = (float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    gg = Math.min(Math.max((int)(adj + (float)gg + 0.5f), 0), 255);
                    adj = (float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    bb = Math.min(Math.max((int)(adj + (float)bb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[this.indexedPixels[i] & 0xFF] = true;
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeScatter() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float w1 = this.palette.ditherStrength * 3.5f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    byte paletteIndex;
                    float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                    float er = curErrorRed[px] * tbn;
                    float eg = curErrorGreen[px] * tbn;
                    float eb = curErrorBlue[px] * tbn;
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[paletteIndex & 0xFF] = true;
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.011230469f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                    gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                    bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny < this.height) {
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeWoven() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float populationBias = this.palette.populationBias;
        float w1 = (float)(20.0 * Math.sqrt(this.ditherStrength) * (double)populationBias * (double)populationBias * (double)populationBias * (double)populationBias);
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 48.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
        float limit = 5.0f + 130.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            for (int px = 0; px < this.width && i < nPix; ++px) {
                byte paletteIndex;
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float er = Math.min(Math.max(((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorRed[px];
                float eg = Math.min(Math.max(((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorGreen[px];
                float eb = Math.min(Math.max(((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = 0.0048828125f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0048828125f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0048828125f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < w - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny < this.height) {
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                ++i;
            }
        }
    }

    protected void analyzeDodgy() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float populationBias = this.palette.populationBias;
        float w1 = 25.0f * this.ditherStrength * populationBias * populationBias;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 0.25f * this.ditherStrength / (populationBias * populationBias);
        float limit = 5.0f + 90.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
        float dmul = 0.0029296875f;
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            for (int px = 0; px < this.width && i < nPix; ++px) {
                byte paletteIndex;
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorRed[px];
                float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorGreen[px];
                float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = dmul * (float)((color >>> 24) - (used >>> 24));
                float gdiff = dmul * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = dmul * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < w - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny < this.height) {
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                ++i;
            }
        }
    }

    protected void analyzeNeue() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float w1 = this.palette.ditherStrength * 7.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
        float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            for (int px = 0; px < this.width && i < nPix; ++px) {
                byte paletteIndex;
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                adj = Math.min(Math.max(adj * strength, -limit), limit);
                float er = adj + curErrorRed[px];
                float eg = adj + curErrorGreen[px];
                float eb = adj + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = 0.0014038086f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                if (px < w - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny < this.height) {
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                ++i;
            }
        }
    }

    protected void analyzeWrenOriginal() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float populationBias = this.palette.populationBias;
        float w1 = (float)(32.0 * (double)this.ditherStrength * (double)(populationBias * populationBias));
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 0.2f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
        float limit = 5.0f + 125.0f / (float)Math.sqrt((double)this.palette.colorCount + 1.5);
        float dmul = 0.00390625f;
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            for (int px = 0; px < this.width && i < nPix; ++px) {
                byte paletteIndex;
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorRed[px], -limit), limit);
                float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorGreen[px], -limit), limit);
                float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorBlue[px], -limit), limit);
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = 0.00390625f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.00390625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.00390625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < w - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny < this.height) {
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                ++i;
            }
        }
    }

    protected void analyzeWren() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float populationBias = this.palette.populationBias;
        float partialDitherStrength = 0.4f * this.ditherStrength * (populationBias * populationBias);
        float strength = 40.0f * this.ditherStrength / (populationBias * populationBias);
        float blueStrength = 0.15f * this.ditherStrength / (populationBias * populationBias);
        float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int i = 0;
        for (int by = 0; by < this.height && i < nPix; ++by) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            int y = flipped + flipDir * by;
            for (int x = 0; x < this.width && i < nPix; ++x) {
                byte paletteIndex;
                int color = this.image.getPixel(x, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorRed[x];
                float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorGreen[x];
                float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorBlue[x];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = (float)((color >>> 24) - (used >>> 24)) * partialDitherStrength;
                float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * partialDitherStrength;
                float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * partialDitherStrength;
                float r1 = rdiff * 16.0f / (float)Math.sqrt(2048.0f + rdiff * rdiff);
                float g1 = gdiff * 16.0f / (float)Math.sqrt(2048.0f + gdiff * gdiff);
                float b1 = bdiff * 16.0f / (float)Math.sqrt(2048.0f + bdiff * bdiff);
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (x < w - 1) {
                    int n = x + 1;
                    curErrorRed[n] = curErrorRed[n] + r4;
                    int n2 = x + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4;
                    int n3 = x + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4;
                    if (x < w - 2) {
                        int n4 = x + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2;
                        int n5 = x + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2;
                        int n6 = x + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2;
                    }
                }
                if (by + 1 < this.height) {
                    if (x > 0) {
                        int n = x - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2;
                        int n7 = x - 1;
                        nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                        int n8 = x - 1;
                        nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                        if (x > 1) {
                            int n9 = x - 2;
                            nextErrorRed[n9] = nextErrorRed[n9] + r1;
                            int n10 = x - 2;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                            int n11 = x - 2;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                        }
                    }
                    int n = x;
                    nextErrorRed[n] = nextErrorRed[n] + r4;
                    int n12 = x;
                    nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                    int n13 = x;
                    nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                    if (x < w - 1) {
                        int n14 = x + 1;
                        nextErrorRed[n14] = nextErrorRed[n14] + r2;
                        int n15 = x + 1;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                        int n16 = x + 1;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                        if (x < w - 2) {
                            int n17 = x + 2;
                            nextErrorRed[n17] = nextErrorRed[n17] + r1;
                            int n18 = x + 2;
                            nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                            int n19 = x + 2;
                            nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void analyzeOverboard() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float populationBias = this.palette.populationBias;
        float strength = this.ditherStrength * 0.5f * (populationBias * populationBias);
        float noiseStrength = 2.0f / populationBias;
        float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
        }
        int by = 0;
        int y = flipped;
        int i = 0;
        while (by < this.height && i < nPix) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0.0f);
            Arrays.fill(nextErrorGreen, 0.0f);
            Arrays.fill(nextErrorBlue, 0.0f);
            for (int x = 0; x < this.width && i < nPix; ++x) {
                byte paletteIndex;
                int color = this.image.getPixel(x, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                    continue;
                }
                float er = 0.0f;
                float eg = 0.0f;
                float eb = 0.0f;
                switch (x << 1 & 2 | y & 1) {
                    case 0: {
                        er += (float)((x ^ y) % 9 - 4);
                        er += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        eg += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        eb += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        break;
                    }
                    case 1: {
                        er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        er += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        eg += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        eb += (float)((x ^ y) % 11 - 5);
                        eb += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        break;
                    }
                    case 2: {
                        er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        er += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        eg += (float)((x ^ y) % 11 - 5);
                        eg += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        eb += (float)((x ^ y) % 9 - 4);
                        eb += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        break;
                    }
                    default: {
                        er += (float)((x ^ y) % 11 - 5);
                        er += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        eg += (float)((x ^ y) % 9 - 4);
                        eg += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        eb += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                    }
                }
                er = er * noiseStrength + curErrorRed[x];
                eg = eg * noiseStrength + curErrorGreen[x];
                eb = eb * noiseStrength + curErrorBlue[x];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + Math.min(Math.max(er, -limit), limit) + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + Math.min(Math.max(eg, -limit), limit) + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + Math.min(Math.max(eb, -limit), limit) + 0.5f), 0), 255);
                this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                this.usedEntry[paletteIndex & 0xFF] = true;
                int used = paletteArray[paletteIndex & 0xFF];
                float rdiff = (float)((color >>> 24) - (used >>> 24)) * strength;
                float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * strength;
                float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * strength;
                float r1 = rdiff * 16.0f / (45.0f + Math.abs(rdiff));
                float g1 = gdiff * 16.0f / (45.0f + Math.abs(gdiff));
                float b1 = bdiff * 16.0f / (45.0f + Math.abs(bdiff));
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (x < w - 1) {
                    int n = x + 1;
                    curErrorRed[n] = curErrorRed[n] + r4;
                    int n2 = x + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4;
                    int n3 = x + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4;
                    if (x < w - 2) {
                        int n4 = x + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2;
                        int n5 = x + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2;
                        int n6 = x + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2;
                    }
                }
                if (by + 1 < this.height) {
                    if (x > 0) {
                        int n = x - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2;
                        int n7 = x - 1;
                        nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                        int n8 = x - 1;
                        nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                        if (x > 1) {
                            int n9 = x - 2;
                            nextErrorRed[n9] = nextErrorRed[n9] + r1;
                            int n10 = x - 2;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                            int n11 = x - 2;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                        }
                    }
                    int n = x;
                    nextErrorRed[n] = nextErrorRed[n] + r4;
                    int n12 = x;
                    nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                    int n13 = x;
                    nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                    if (x < w - 1) {
                        int n14 = x + 1;
                        nextErrorRed[n14] = nextErrorRed[n14] + r2;
                        int n15 = x + 1;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                        int n16 = x + 1;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                        if (x < w - 2) {
                            int n17 = x + 2;
                            nextErrorRed[n17] = nextErrorRed[n17] + r1;
                            int n18 = x + 2;
                            nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                            int n19 = x + 2;
                            nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                        }
                    }
                }
                ++i;
            }
            ++by;
            y += flipDir;
        }
    }

    protected void analyzeBurkes() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        int w = this.width;
        float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
        float strength = s * 0.29f / (0.19f + s);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    byte paletteIndex;
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[paletteIndex & 0xFF] = true;
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    float r1 = (float)rdiff * strength;
                    float g1 = (float)gdiff * strength;
                    float b1 = (float)bdiff * strength;
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4;
                        if (px < w - 2) {
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2;
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2;
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2;
                        }
                    }
                    if (ny < this.height) {
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + r2;
                            int n7 = px - 1;
                            nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                            int n8 = px - 1;
                            nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                            if (px > 1) {
                                int n9 = px - 2;
                                nextErrorRed[n9] = nextErrorRed[n9] + r1;
                                int n10 = px - 2;
                                nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                                int n11 = px - 2;
                                nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                            }
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + r4;
                        int n12 = px;
                        nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                        int n13 = px;
                        nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                        if (px < w - 1) {
                            int n14 = px + 1;
                            nextErrorRed[n14] = nextErrorRed[n14] + r2;
                            int n15 = px + 1;
                            nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                            int n16 = px + 1;
                            nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                            if (px < w - 2) {
                                int n17 = px + 2;
                                nextErrorRed[n17] = nextErrorRed[n17] + r1;
                                int n18 = px + 2;
                                nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                                int n19 = px + 2;
                                nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                            }
                        }
                    }
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeOceanic() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float[] noise = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        int w = this.width;
        float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
        float strength = s * 0.29f / (0.19f + s);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    float modifier;
                    byte paletteIndex;
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[paletteIndex & 0xFF] = true;
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    float r1 = (float)rdiff * strength;
                    float g1 = (float)gdiff * strength;
                    float b1 = (float)bdiff * strength;
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        modifier = noise[px + 1 & 0x3F | py << 6 & 0xFC0];
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4 * modifier;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4 * modifier;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4 * modifier;
                        if (px < w - 2) {
                            modifier = noise[px + 2 & 0x3F | py << 6 & 0xFC0];
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2 * modifier;
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2 * modifier;
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2 * modifier;
                        }
                    }
                    if (ny < this.height) {
                        if (px > 0) {
                            modifier = noise[px - 1 & 0x3F | ny << 6 & 0xFC0];
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + r2 * modifier;
                            int n7 = px - 1;
                            nextErrorGreen[n7] = nextErrorGreen[n7] + g2 * modifier;
                            int n8 = px - 1;
                            nextErrorBlue[n8] = nextErrorBlue[n8] + b2 * modifier;
                            if (px > 1) {
                                modifier = noise[px - 2 & 0x3F | ny << 6 & 0xFC0];
                                int n9 = px - 2;
                                nextErrorRed[n9] = nextErrorRed[n9] + r1 * modifier;
                                int n10 = px - 2;
                                nextErrorGreen[n10] = nextErrorGreen[n10] + g1 * modifier;
                                int n11 = px - 2;
                                nextErrorBlue[n11] = nextErrorBlue[n11] + b1 * modifier;
                            }
                        }
                        modifier = noise[px & 0x3F | ny << 6 & 0xFC0];
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + r4 * modifier;
                        int n12 = px;
                        nextErrorGreen[n12] = nextErrorGreen[n12] + g4 * modifier;
                        int n13 = px;
                        nextErrorBlue[n13] = nextErrorBlue[n13] + b4 * modifier;
                        if (px < w - 1) {
                            modifier = noise[px + 1 & 0x3F | ny << 6 & 0xFC0];
                            int n14 = px + 1;
                            nextErrorRed[n14] = nextErrorRed[n14] + r2 * modifier;
                            int n15 = px + 1;
                            nextErrorGreen[n15] = nextErrorGreen[n15] + g2 * modifier;
                            int n16 = px + 1;
                            nextErrorBlue[n16] = nextErrorBlue[n16] + b2 * modifier;
                            if (px < w - 2) {
                                modifier = noise[px + 2 & 0x3F | ny << 6 & 0xFC0];
                                int n17 = px + 2;
                                nextErrorRed[n17] = nextErrorRed[n17] + r1 * modifier;
                                int n18 = px + 2;
                                nextErrorGreen[n18] = nextErrorGreen[n18] + g1 * modifier;
                                int n19 = px + 2;
                                nextErrorBlue[n19] = nextErrorBlue[n19] + b1 * modifier;
                            }
                        }
                    }
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzeSeaside() {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        int nPix = this.indexedPixels.length;
        int flipped = this.flipY ? this.height - 1 : 0;
        int flipDir = this.flipY ? -1 : 1;
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        boolean hasTransparent = paletteArray[0] == 0;
        float[] noiseA = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        float[] noiseB = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_B;
        float[] noiseC = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_C;
        int w = this.width;
        float s = 0.13f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias);
        float strength = s * 0.29f / (0.18f + s);
        if (this.palette.curErrorRedFloats == null) {
            this.palette.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.palette.curErrorRedFloats.items;
            this.palette.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.palette.nextErrorRedFloats.items;
            this.palette.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.palette.curErrorGreenFloats.items;
            this.palette.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.items;
            this.palette.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.palette.curErrorBlueFloats.items;
            this.palette.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
        }
        int i = 0;
        for (int y = 0; y < this.height && i < nPix; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            int py = flipped + flipDir * y;
            int ny = y + 1;
            int px = 0;
            while (px < this.width & i < nPix) {
                int color = this.image.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    this.indexedPixels[i++] = 0;
                } else {
                    byte paletteIndex;
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    this.indexedPixels[i] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    this.usedEntry[paletteIndex & 0xFF] = true;
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    int modifier = px & 0x3F | py << 6 & 0xFC0;
                    float r1 = (float)rdiff * strength * noiseA[modifier];
                    float g1 = (float)gdiff * strength * noiseB[modifier];
                    float b1 = (float)bdiff * strength * noiseC[modifier];
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        modifier = px + 1 & 0x3F | py << 6 & 0xFC0;
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4 * noiseA[modifier];
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4 * noiseB[modifier];
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4 * noiseC[modifier];
                        if (px < w - 2) {
                            modifier = px + 2 & 0x3F | py << 6 & 0xFC0;
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2 * noiseA[modifier];
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2 * noiseB[modifier];
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2 * noiseC[modifier];
                        }
                        if (px < w - 3) {
                            modifier = px + 3 & 0x3F | py << 6 & 0xFC0;
                            int n7 = px + 2;
                            curErrorRed[n7] = curErrorRed[n7] + r1 * noiseA[modifier];
                            int n8 = px + 2;
                            curErrorGreen[n8] = curErrorGreen[n8] + g1 * noiseB[modifier];
                            int n9 = px + 2;
                            curErrorBlue[n9] = curErrorBlue[n9] + b1 * noiseC[modifier];
                        }
                    }
                    if (ny < this.height) {
                        if (px > 0) {
                            modifier = px - 1 & 0x3F | ny << 6 & 0xFC0;
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + r2 * noiseA[modifier];
                            int n10 = px - 1;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g2 * noiseB[modifier];
                            int n11 = px - 1;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b2 * noiseC[modifier];
                            if (px > 1) {
                                modifier = px - 2 & 0x3F | ny << 6 & 0xFC0;
                                int n12 = px - 2;
                                nextErrorRed[n12] = nextErrorRed[n12] + r1 * noiseA[modifier];
                                int n13 = px - 2;
                                nextErrorGreen[n13] = nextErrorGreen[n13] + g1 * noiseB[modifier];
                                int n14 = px - 2;
                                nextErrorBlue[n14] = nextErrorBlue[n14] + b1 * noiseC[modifier];
                            }
                        }
                        modifier = px & 0x3F | ny << 6 & 0xFC0;
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + r4 * noiseA[modifier];
                        int n15 = px;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g4 * noiseB[modifier];
                        int n16 = px;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b4 * noiseC[modifier];
                        if (px < w - 1) {
                            modifier = px + 1 & 0x3F | ny << 6 & 0xFC0;
                            int n17 = px + 1;
                            nextErrorRed[n17] = nextErrorRed[n17] + r2 * noiseA[modifier];
                            int n18 = px + 1;
                            nextErrorGreen[n18] = nextErrorGreen[n18] + g2 * noiseB[modifier];
                            int n19 = px + 1;
                            nextErrorBlue[n19] = nextErrorBlue[n19] + b2 * noiseC[modifier];
                            if (px < w - 2) {
                                modifier = px + 2 & 0x3F | ny << 6 & 0xFC0;
                                int n20 = px + 2;
                                nextErrorRed[n20] = nextErrorRed[n20] + r1 * noiseA[modifier];
                                int n21 = px + 2;
                                nextErrorGreen[n21] = nextErrorGreen[n21] + g1 * noiseB[modifier];
                                int n22 = px + 2;
                                nextErrorBlue[n22] = nextErrorBlue[n22] + b1 * noiseC[modifier];
                            }
                        }
                    }
                    ++i;
                }
                ++px;
            }
        }
    }

    protected void analyzePixels() {
        int nPix = this.width * this.height;
        this.indexedPixels = new byte[nPix];
        this.palette.setDitherStrength(this.ditherStrength);
        if (this.seq > 1 && this.clearPalette) {
            if (this.fastAnalysis) {
                this.palette.analyzeFast(this.image, 300.0, 256);
            } else {
                this.palette.analyze(this.image, 300.0, 256);
            }
        }
        int[] paletteArray = this.palette.paletteArray;
        this.colorTab = new byte[768];
        int bi = 0;
        for (int i = 0; i < 256; ++i) {
            int pa = paletteArray[i];
            this.colorTab[bi++] = (byte)(pa >>> 24);
            this.colorTab[bi++] = (byte)(pa >>> 16);
            this.colorTab[bi++] = (byte)(pa >>> 8);
            this.usedEntry[i] = false;
        }
        boolean hasTransparent = paletteArray[0] == 0;
        switch (this.ditherAlgorithm) {
            case NONE: {
                this.analyzeNone();
                break;
            }
            case PATTERN: {
                this.analyzePattern();
                break;
            }
            case CHAOTIC_NOISE: {
                this.analyzeChaotic();
                break;
            }
            case GRADIENT_NOISE: {
                this.analyzeGradient();
                break;
            }
            case ROBERTS: {
                this.analyzeRoberts();
                break;
            }
            case LOAF: {
                this.analyzeLoaf();
                break;
            }
            case DIFFUSION: {
                this.analyzeDiffusion();
                break;
            }
            case BLUE_NOISE: {
                this.analyzeBlue();
                break;
            }
            case SCATTER: {
                this.analyzeScatter();
                break;
            }
            case WOVEN: {
                this.analyzeWoven();
                break;
            }
            case DODGY: {
                this.analyzeDodgy();
                break;
            }
            case NEUE: {
                this.analyzeNeue();
                break;
            }
            case WREN: {
                this.analyzeWren();
                break;
            }
            case BURKES: {
                this.analyzeBurkes();
                break;
            }
            case OCEANIC: {
                this.analyzeOceanic();
                break;
            }
            case SEASIDE: {
                this.analyzeSeaside();
                break;
            }
            default: {
                this.analyzeOverboard();
            }
        }
        this.colorDepth = 8;
        this.palSize = 7;
        if (hasTransparent) {
            this.transIndex = 0;
        }
    }

    protected void getImagePixels() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        if (w != this.width || h != this.height) {
            Pixmap temp = new Pixmap(this.width, this.height, Pixmap.Format.RGBA8888);
            temp.drawPixmap(this.image, 0, 0);
            this.image = temp;
        }
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transIndex == -1) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(Math.round((float)this.delay / 10.0f));
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(this.x);
        this.writeShort(this.y);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >>> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }

    public boolean isFastAnalysis() {
        return this.fastAnalysis;
    }

    public boolean setFastAnalysis(boolean fastAnalysis) {
        this.fastAnalysis = fastAnalysis;
        return this.fastAnalysis;
    }
}

