/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.anim8.AnimationWriter;
import com.github.tommyettinger.anim8.ChunkBuffer;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class AnimatedPNG
implements AnimationWriter,
Disposable {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int acTL = 1633899596;
    private static final int fcTL = 1717785676;
    private static final int IDAT = 1229209940;
    private static final int fdAT = 1717846356;
    private static final int IEND = 1229278788;
    private static final byte COLOR_ARGB = 6;
    private static final byte COMPRESSION_DEFLATE = 0;
    private static final byte FILTER_NONE = 0;
    private static final byte INTERLACE_NONE = 0;
    private final ChunkBuffer buffer;
    private final Deflater deflater;
    private ByteArray curLineBytes;
    private boolean flipY = true;

    public AnimatedPNG() {
        this(16384);
    }

    public AnimatedPNG(int initialBufferSize) {
        this.buffer = new ChunkBuffer(initialBufferSize);
        this.deflater = new Deflater();
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void setCompression(int level) {
        this.deflater.setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileHandle file, Array<Pixmap> frames) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, 60);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileHandle file, Array<Pixmap> frames, int fps) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, fps);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(6);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int lineLen = width * 4;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(lineLen);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(lineLen);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    int x = 0;
                    for (int px = 0; px < width; ++px) {
                        int pixel = pixmap.getPixel(px, py);
                        curLine[x++] = (byte)(pixel >>> 24 & 0xFF);
                        curLine[x++] = (byte)(pixel >>> 16 & 0xFF);
                        curLine[x++] = (byte)(pixel >>> 8 & 0xFF);
                        curLine[x++] = (byte)(pixel & 0xFF);
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, lineLen);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void dispose() {
        this.deflater.end();
    }
}

